/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.entity.LightBlockEntity;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LightBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape MIN_ANCHOR_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private final VoxelShape floorShape;
    private final VoxelShape eastWallShape;
    private final VoxelShape westWallShape;
    private final VoxelShape northWallShape;
    private final VoxelShape southWallShape;
    private final VoxelShape ceilingShape;
    private final LightVariant<?> variant;

    public LightBlock(BlockBehaviour.Properties properties, LightVariant<?> variant) {
        super(properties);
        this.variant = variant;
        AABB bb = this.variant.getBounds();
        double w = Math.max(bb.m_82362_(), bb.m_82385_());
        double w0 = 0.5 - w * 0.5;
        double w1 = 0.5 + w * 0.5;
        if (variant.isOrientable()) {
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, -bb.f_82289_, w1);
            this.eastWallShape = LightBlock.clampBox(0.0, w0, w0, -bb.f_82289_, w1, w1);
            this.westWallShape = LightBlock.clampBox(1.0 + bb.f_82289_, w0, w0, 1.0, w1, w1);
            this.southWallShape = LightBlock.clampBox(w0, w0, 0.0, w1, w1, -bb.f_82289_);
            this.northWallShape = LightBlock.clampBox(w0, w0, 1.0 + bb.f_82289_, w1, w1, 1.0);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.f_82289_, w0, w1, 1.0, w1);
        } else {
            double t = 0.125;
            double u = 0.6875;
            this.floorShape = LightBlock.clampBox(w0, 0.0, w0, w1, bb.m_82376_() - this.variant.getFloorOffset(), w1);
            this.eastWallShape = LightBlock.clampBox(w0 - 0.125, 0.6875 + bb.f_82289_, w0, w1 - 0.125, 0.6875 + bb.f_82292_, w1);
            this.westWallShape = LightBlock.clampBox(w0 + 0.125, 0.6875 + bb.f_82289_, w0, w1 + 0.125, 0.6875 + bb.f_82292_, w1);
            this.southWallShape = LightBlock.clampBox(w0, 0.6875 + bb.f_82289_, w0 - 0.125, w1, 0.6875 + bb.f_82292_, w1 - 0.125);
            this.northWallShape = LightBlock.clampBox(w0, 0.6875 + bb.f_82289_, w0 + 0.125, w1, 0.6875 + bb.f_82292_, w1 + 0.125);
            this.ceilingShape = LightBlock.clampBox(w0, 1.0 + bb.f_82289_ - 0.25, w0, w1, 1.0, w1);
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    private static VoxelShape clampBox(double x0, double y0, double z0, double x1, double y1, double z1) {
        return Shapes.m_83048_((double)Mth.m_14008_((double)x0, (double)0.0, (double)1.0), (double)Mth.m_14008_((double)y0, (double)0.0, (double)1.0), (double)Mth.m_14008_((double)z0, (double)0.0, (double)1.0), (double)Mth.m_14008_((double)x1, (double)0.0, (double)1.0), (double)Mth.m_14008_((double)y1, (double)0.0, (double)1.0), (double)Mth.m_14008_((double)z1, (double)0.0, (double)1.0));
    }

    public LightVariant<?> getVariant() {
        return this.variant;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LightBlockEntity(pos, state);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        AttachFace value = (AttachFace)state.m_61143_((Property)f_53179_);
        if (value == AttachFace.WALL) {
            Direction facing = (Direction)state.m_61143_((Property)f_54117_);
            BlockPos anchorPos = pos.m_121945_(facing.m_122424_());
            BlockState anchorState = world.m_8055_(anchorPos);
            if (anchorState.m_204336_(BlockTags.f_13035_)) {
                return true;
            }
            VoxelShape shape = anchorState.m_60816_((BlockGetter)world, anchorPos);
            return Block.m_49918_((VoxelShape)shape, (Direction)facing);
        }
        Direction facing = value == AttachFace.FLOOR ? Direction.DOWN : Direction.UP;
        BlockPos anchorPos = pos.m_121945_(facing);
        BlockState anchorState = world.m_8055_(anchorPos);
        if (anchorState.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        VoxelShape shape = anchorState.m_60816_((BlockGetter)world, anchorPos);
        return !Shapes.m_83157_((VoxelShape)shape.m_83263_(facing.m_122424_()), (VoxelShape)MIN_ANCHOR_SHAPE, (BooleanOp)BooleanOp.f_82683_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        for (Direction dir : context.m_6232_()) {
            BlockState state = dir.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)(dir == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_53179_, (Comparable)AttachFace.WALL)).m_61124_((Property)f_54117_, (Comparable)dir.m_122424_());
            if (!state.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return state;
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof LightBlockEntity) {
            ItemStack lightItem = stack.m_41777_();
            lightItem.m_41764_(1);
            ((LightBlockEntity)entity).setItemStack(lightItem);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity entity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (entity instanceof LightBlockEntity) {
            return Collections.singletonList(((LightBlockEntity)entity).getLight().getItem().m_41777_());
        }
        return Collections.emptyList();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).interact(world, pos, state, player, hand, hit);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rng) {
        super.m_214162_(state, world, pos, rng);
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof LightBlockEntity) {
            ((LightBlockEntity)entity).animateTick();
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            default: {
                return this.floorShape;
            }
            case WALL: {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    default: {
                        return this.eastWallShape;
                    }
                    case WEST: {
                        return this.westWallShape;
                    }
                    case SOUTH: {
                        return this.southWallShape;
                    }
                    case NORTH: 
                }
                return this.northWallShape;
            }
            case CEILING: 
        }
        return this.ceilingShape;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof LightBlockEntity) {
            return ((LightBlockEntity)entity).getLight().getItem().m_41777_();
        }
        ItemStack stack = new ItemStack((ItemLike)this);
        DyeableItem.setColor(stack, DyeColor.YELLOW);
        return stack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_53179_, f_54117_, LIT});
    }
}

