/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.statistics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import org.threadly.concurrent.AbstractSubmitterExecutor;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.statistics.StatisticExecutor;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.Pair;
import org.threadly.util.StatisticsUtils;

public class ExecutorStatisticWrapper
extends AbstractSubmitterExecutor
implements StatisticExecutor {
    private final Executor executor;
    private final StatsContainer statsContainer;

    public ExecutorStatisticWrapper(Executor executor) {
        this(executor, false);
    }

    public ExecutorStatisticWrapper(Executor executor, boolean accurateTime) {
        this(executor, 1000, accurateTime);
    }

    public ExecutorStatisticWrapper(Executor executor, int maxStatisticWindowSize) {
        this(executor, maxStatisticWindowSize, false);
    }

    public ExecutorStatisticWrapper(Executor executor, int maxStatisticWindowSize, boolean accurateTime) {
        ArgumentVerifier.assertGreaterThanZero(maxStatisticWindowSize, "maxStatisticWindowSize");
        this.executor = executor;
        this.statsContainer = new StatsContainer(maxStatisticWindowSize, accurateTime);
    }

    @Override
    protected void doExecute(Runnable task) {
        this.statsContainer.queuedTaskCount.increment();
        this.executor.execute(new StatisticRunnable(task, Clock.accurateForwardProgressingMillis(), this.statsContainer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getExecutionDelaySamples() {
        ArrayList<Long> runDelays;
        Deque<Long> deque = this.statsContainer.runDelays;
        synchronized (deque) {
            runDelays = new ArrayList<Long>(this.statsContainer.runDelays);
        }
        return runDelays;
    }

    @Override
    public double getAverageExecutionDelay() {
        List<Long> delaySamples = this.getExecutionDelaySamples();
        if (delaySamples.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(delaySamples);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(double ... percentiles) {
        List<Long> samples = this.getExecutionDelaySamples();
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getExecutionDurationSamples() {
        ArrayList<Long> runDurations;
        Deque<Long> deque = this.statsContainer.runDurations;
        synchronized (deque) {
            runDurations = new ArrayList<Long>(this.statsContainer.runDurations);
        }
        return runDurations;
    }

    @Override
    public double getAverageExecutionDuration() {
        List<Long> durationSamples = this.getExecutionDurationSamples();
        if (durationSamples.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(durationSamples);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(double ... percentiles) {
        List<Long> samples = this.getExecutionDurationSamples();
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    @Override
    public List<Pair<Runnable, StackTraceElement[]>> getLongRunningTasks(long durationLimitMillis) {
        ArrayList<Pair<Runnable, StackTraceElement[]>> result = new ArrayList<Pair<Runnable, StackTraceElement[]>>();
        if (this.statsContainer.accurateTime) {
            Clock.accurateForwardProgressingMillis();
        }
        for (Map.Entry<Pair<Thread, Runnable>, Long> e : this.statsContainer.runningTasks.entrySet()) {
            ListenableFutureTask lft;
            if (Clock.lastKnownForwardProgressingMillis() - e.getValue() <= durationLimitMillis) continue;
            Runnable task = e.getKey().getRight();
            if (task instanceof ListenableFutureTask && (lft = (ListenableFutureTask)task).getContainedCallable() instanceof RunnableCallableAdapter) {
                RunnableCallableAdapter rca = (RunnableCallableAdapter)lft.getContainedCallable();
                task = rca.getContainedRunnable();
            }
            StackTraceElement[] stack = e.getKey().getLeft().getStackTrace();
            if (!this.statsContainer.runningTasks.containsKey(e.getKey())) continue;
            result.add(new Pair<Runnable, StackTraceElement[]>(task, stack));
        }
        return result;
    }

    @Override
    public int getLongRunningTasksQty(long durationLimitMillis) {
        int result = 0;
        if (this.statsContainer.accurateTime) {
            Clock.accurateForwardProgressingMillis();
        }
        for (Long l : this.statsContainer.runningTasks.values()) {
            if (Clock.lastKnownForwardProgressingMillis() - l <= durationLimitMillis) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getQueuedTaskCount() {
        return this.statsContainer.queuedTaskCount.intValue();
    }

    @Override
    public long getTotalExecutionCount() {
        return this.statsContainer.totalExecutionCount.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetCollectedStats() {
        Deque<Long> deque = this.statsContainer.runDelays;
        synchronized (deque) {
            this.statsContainer.runDelays.clear();
        }
        deque = this.statsContainer.runDurations;
        synchronized (deque) {
            this.statsContainer.runDurations.clear();
        }
    }

    protected static class StatsContainer {
        public final int maxStatisticWindowSize;
        public final boolean accurateTime;
        protected final LongAdder totalExecutionCount;
        protected final LongAdder queuedTaskCount;
        protected final Map<Pair<Thread, Runnable>, Long> runningTasks;
        protected final Deque<Long> runDurations;
        protected final Deque<Long> runDelays;

        public StatsContainer(int maxStatisticWindowSize, boolean accurateTime) {
            this.maxStatisticWindowSize = maxStatisticWindowSize;
            this.accurateTime = accurateTime;
            this.totalExecutionCount = new LongAdder();
            this.queuedTaskCount = new LongAdder();
            this.runningTasks = new ConcurrentHashMap<Pair<Thread, Runnable>, Long>();
            this.runDurations = new ArrayDeque<Long>();
            this.runDelays = new ArrayDeque<Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackStart(Pair<Thread, Runnable> taskPair, long expectedRunTime) {
            long startTime = Clock.accurateForwardProgressingMillis();
            this.queuedTaskCount.decrement();
            this.totalExecutionCount.increment();
            Deque<Long> deque = this.runDelays;
            synchronized (deque) {
                this.runDelays.addLast(startTime - expectedRunTime);
                if (this.runDelays.size() > this.maxStatisticWindowSize) {
                    this.runDelays.removeFirst();
                }
            }
            this.runningTasks.put(taskPair, Clock.lastKnownForwardProgressingMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackFinish(Pair<Thread, Runnable> taskPair) {
            long runDuration = (this.accurateTime ? Clock.accurateForwardProgressingMillis() : Clock.lastKnownForwardProgressingMillis()) - this.runningTasks.remove(taskPair);
            Deque<Long> deque = this.runDurations;
            synchronized (deque) {
                this.runDurations.addLast(runDuration);
                if (this.runDurations.size() > this.maxStatisticWindowSize) {
                    this.runDurations.removeFirst();
                }
            }
        }
    }

    protected static class StatisticRunnable
    implements RunnableContainer,
    Runnable {
        private final Runnable task;
        private final long expectedRunTime;
        private final StatsContainer statsContainer;

        public StatisticRunnable(Runnable task, long expectedRunTime, StatsContainer statsContainer) {
            this.task = task;
            this.expectedRunTime = expectedRunTime;
            this.statsContainer = statsContainer;
        }

        @Override
        public void run() {
            Pair<Thread, Runnable> taskPair = new Pair<Thread, Runnable>(Thread.currentThread(), this.task);
            this.statsContainer.trackStart(taskPair, this.expectedRunTime);
            try {
                this.task.run();
            }
            finally {
                this.statsContainer.trackFinish(taskPair);
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }
}

