/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.priority;

import java.util.concurrent.Callable;
import org.threadly.concurrent.AbstractSubmitterScheduler;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.SchedulerService;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.util.ArgumentVerifier;

public class PriorityDelegatingScheduler
extends AbstractSubmitterScheduler
implements PrioritySchedulerService {
    private final SchedulerService highPriorityScheduler;
    private final SchedulerService lowPriorityScheduler;
    private final SchedulerService starvablePriorityScheduler;
    private final TaskPriority defaultPriority;

    public PriorityDelegatingScheduler(SchedulerService highPriorityScheduler, SchedulerService lowPriorityScheduler, SchedulerService starvablePriorityScheduler, TaskPriority defaultPriority) {
        ArgumentVerifier.assertNotNull(highPriorityScheduler, "highPriorityScheduler");
        ArgumentVerifier.assertNotNull(lowPriorityScheduler, "lowPriorityScheduler");
        ArgumentVerifier.assertNotNull((Object)defaultPriority, "defaultPriority");
        this.highPriorityScheduler = highPriorityScheduler;
        this.lowPriorityScheduler = lowPriorityScheduler;
        this.starvablePriorityScheduler = starvablePriorityScheduler == null ? lowPriorityScheduler : starvablePriorityScheduler;
        this.defaultPriority = defaultPriority;
    }

    protected SchedulerService scheduler(TaskPriority priority) {
        if (priority == TaskPriority.High) {
            return this.highPriorityScheduler;
        }
        if (priority == TaskPriority.Low) {
            return this.lowPriorityScheduler;
        }
        if (priority == TaskPriority.Starvable) {
            return this.starvablePriorityScheduler;
        }
        return this.scheduler(this.defaultPriority);
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return 0L;
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return this.scheduler(priority).getQueuedTaskCount();
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        return this.scheduler(priority).getWaitingForExecutionTaskCount();
    }

    @Override
    public boolean isShutdown() {
        return this.highPriorityScheduler.isShutdown() | this.lowPriorityScheduler.isShutdown() | this.starvablePriorityScheduler.isShutdown();
    }

    @Override
    public int getQueuedTaskCount() {
        return this.scheduler(this.defaultPriority).getQueuedTaskCount();
    }

    @Override
    public int getWaitingForExecutionTaskCount() {
        return this.scheduler(this.defaultPriority).getWaitingForExecutionTaskCount();
    }

    @Override
    public int getActiveTaskCount() {
        return this.scheduler(this.defaultPriority).getActiveTaskCount();
    }

    @Override
    public boolean remove(Runnable task) {
        if (this.highPriorityScheduler.remove(task)) {
            return true;
        }
        if (this.lowPriorityScheduler != this.highPriorityScheduler && this.lowPriorityScheduler.remove(task)) {
            return true;
        }
        return this.starvablePriorityScheduler != this.highPriorityScheduler && this.starvablePriorityScheduler != this.lowPriorityScheduler && this.starvablePriorityScheduler.remove(task);
    }

    @Override
    public boolean remove(Callable<?> task) {
        if (this.highPriorityScheduler.remove(task)) {
            return true;
        }
        if (this.lowPriorityScheduler != this.highPriorityScheduler && this.lowPriorityScheduler.remove(task)) {
            return true;
        }
        return this.starvablePriorityScheduler != this.highPriorityScheduler && this.starvablePriorityScheduler != this.lowPriorityScheduler && this.starvablePriorityScheduler.remove(task);
    }

    @Override
    protected void doSchedule(Runnable task, long delayInMs) {
        this.scheduler(this.defaultPriority).schedule(task, delayInMs);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay) {
        this.scheduler(this.defaultPriority).scheduleWithFixedDelay(task, initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period) {
        this.scheduler(this.defaultPriority).scheduleAtFixedRate(task, initialDelay, period);
    }

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        this.scheduler(priority).execute(task);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.scheduler(priority).submit(task, result);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        return this.scheduler(priority).submit(task);
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        this.scheduler(priority).schedule(task, delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.scheduler(priority).submitScheduled(task, result, delayInMs);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        return this.scheduler(priority).submitScheduled(task, delayInMs);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.scheduler(priority).scheduleWithFixedDelay(task, initialDelay, recurringDelay);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.scheduler(priority).scheduleAtFixedRate(task, initialDelay, period);
    }
}

