/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.limiter;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import org.threadly.concurrent.PrioritySchedulerService;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.limiter.ExecutorQueueLimitRejector;
import org.threadly.concurrent.wrapper.limiter.RejectedExecutionHandler;
import org.threadly.concurrent.wrapper.limiter.SchedulerServiceQueueLimitRejector;
import org.threadly.util.ArgumentVerifier;

public class PrioritySchedulerServiceQueueLimitRejector
extends SchedulerServiceQueueLimitRejector
implements PrioritySchedulerService {
    protected final PrioritySchedulerService parentScheduler;
    protected final boolean dontLimitStarvable;

    public PrioritySchedulerServiceQueueLimitRejector(PrioritySchedulerService parentScheduler, int queuedTaskLimit) {
        this(parentScheduler, queuedTaskLimit, null);
    }

    public PrioritySchedulerServiceQueueLimitRejector(PrioritySchedulerService parentScheduler, int queuedTaskLimit, RejectedExecutionHandler rejectedExecutionHandler) {
        this(parentScheduler, queuedTaskLimit, false, rejectedExecutionHandler);
    }

    public PrioritySchedulerServiceQueueLimitRejector(PrioritySchedulerService parentScheduler, int queuedTaskLimit, boolean dontLimitStarvable) {
        this(parentScheduler, queuedTaskLimit, dontLimitStarvable, null);
    }

    public PrioritySchedulerServiceQueueLimitRejector(PrioritySchedulerService parentScheduler, int queuedTaskLimit, boolean dontLimitStarvable, RejectedExecutionHandler rejectedExecutionHandler) {
        super(parentScheduler, queuedTaskLimit, rejectedExecutionHandler);
        this.parentScheduler = parentScheduler;
        this.dontLimitStarvable = dontLimitStarvable;
    }

    protected void doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        int casValue;
        if (this.dontLimitStarvable && priority == TaskPriority.Starvable) {
            this.parentScheduler.schedule(task, delayInMillis, priority);
            return;
        }
        do {
            if ((casValue = this.queuedTaskCount.get()) < this.getQueueLimit()) continue;
            this.rejectedExecutionHandler.handleRejectedTask(task);
            return;
        } while (!this.queuedTaskCount.weakCompareAndSetVolatile(casValue, casValue + 1));
        try {
            this.parentScheduler.schedule(new ExecutorQueueLimitRejector.DecrementingRunnable(task, this.queuedTaskCount), delayInMillis, priority);
        }
        catch (RejectedExecutionException e) {
            this.queuedTaskCount.decrementAndGet();
            throw e;
        }
    }

    @Override
    public void execute(Runnable task, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        this.doSchedule(task, 0L, priority);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task, TaskPriority priority) {
        return this.submit(task, null, priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result, TaskPriority priority) {
        return this.submit(RunnableCallableAdapter.adapt(task, result), priority);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.doSchedule(lft, 0L, priority);
        return lft;
    }

    @Override
    public void schedule(Runnable task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        this.doSchedule(task, delayInMs, priority);
    }

    @Override
    public ListenableFuture<?> submitScheduled(Runnable task, long delayInMs, TaskPriority priority) {
        return this.submitScheduled(task, null, delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Runnable task, T result, long delayInMs, TaskPriority priority) {
        return this.submitScheduled(RunnableCallableAdapter.adapt(task, result), delayInMs, priority);
    }

    @Override
    public <T> ListenableFuture<T> submitScheduled(Callable<T> task, long delayInMs, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(delayInMs, "delayInMs");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.doSchedule(lft, delayInMs, priority);
        return lft;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        this.parentScheduler.scheduleWithFixedDelay(task, initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        this.parentScheduler.scheduleAtFixedRate(task, initialDelay, period, priority);
    }

    @Override
    public TaskPriority getDefaultPriority() {
        return this.parentScheduler.getDefaultPriority();
    }

    @Override
    public long getMaxWaitForLowPriority() {
        return this.parentScheduler.getMaxWaitForLowPriority();
    }

    @Override
    public int getQueuedTaskCount(TaskPriority priority) {
        return this.parentScheduler.getQueuedTaskCount(priority);
    }

    @Override
    public int getWaitingForExecutionTaskCount(TaskPriority priority) {
        return this.parentScheduler.getWaitingForExecutionTaskCount(priority);
    }
}

