/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.interceptor;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;

public class ExecutorTaskInterceptor
implements SubmitterExecutor {
    protected final Executor parentExecutor;
    protected final Function<Runnable, Runnable> taskManipulator;

    protected ExecutorTaskInterceptor(Executor parentExecutor) {
        this(parentExecutor, r -> {
            throw new RuntimeException("Must override wrapTask(Runnable)");
        });
    }

    public ExecutorTaskInterceptor(Executor parentExecutor, Function<Runnable, Runnable> taskManipulator) {
        ArgumentVerifier.assertNotNull(parentExecutor, "parentExecutor");
        ArgumentVerifier.assertNotNull(taskManipulator, "taskManipulator");
        this.taskManipulator = taskManipulator;
        this.parentExecutor = parentExecutor;
    }

    public Runnable wrapTask(Runnable task) {
        return this.taskManipulator.apply(task);
    }

    @Override
    public void execute(Runnable task) {
        this.parentExecutor.execute(task == null ? null : this.wrapTask(task));
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(this.wrapTask(task), result, this);
        this.parentExecutor.execute(lft);
        return lft;
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> lft = new ListenableFutureTask<T>(task, this);
        this.parentExecutor.execute(this.wrapTask(lft));
        return lft;
    }
}

