/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper.compatibility;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.threadly.concurrent.SingleThreadScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.ThreadlyInternalAccessor;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.concurrent.wrapper.compatibility.AbstractExecutorServiceWrapper;
import org.threadly.concurrent.wrapper.compatibility.ListenableScheduledFuture;
import org.threadly.concurrent.wrapper.priority.DefaultPriorityWrapper;

public class SingleThreadSchedulerServiceWrapper
extends AbstractExecutorServiceWrapper {
    protected final SingleThreadScheduler singleThreadScheduler;
    protected final TaskPriority taskPriority;

    public SingleThreadSchedulerServiceWrapper(SingleThreadScheduler scheduler) {
        this(scheduler, null);
    }

    public SingleThreadSchedulerServiceWrapper(SingleThreadScheduler scheduler, TaskPriority taskPriority) {
        super(DefaultPriorityWrapper.ensurePriority(scheduler, taskPriority));
        this.singleThreadScheduler = scheduler;
        this.taskPriority = taskPriority == null ? scheduler.getDefaultPriority() : taskPriority;
    }

    @Override
    public void shutdown() {
        this.singleThreadScheduler.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.singleThreadScheduler.shutdownNow();
    }

    @Override
    public boolean isTerminated() {
        return this.singleThreadScheduler.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.singleThreadScheduler.awaitTermination(unit.toMillis(timeout));
    }

    @Override
    protected ListenableScheduledFuture<?> schedule(Runnable task, long delayInMillis) {
        ListenableFutureTask<Object> lft = new ListenableFutureTask<Object>(task, null, this.singleThreadScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAndGetDelayed(this.singleThreadScheduler, lft, this.taskPriority, delayInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate<Object>(lft, d);
    }

    @Override
    protected <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delayInMillis) {
        ListenableFutureTask<V> lft = new ListenableFutureTask<V>(callable, this.singleThreadScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAndGetDelayed(this.singleThreadScheduler, lft, this.taskPriority, delayInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate<V>(lft, d);
    }

    @Override
    protected ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delayInMillis) {
        task = new AbstractExecutorServiceWrapper.ThrowableHandlingRecurringRunnable(this.scheduler, task);
        AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask lft = new AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask(this.scheduler, true, task, this.singleThreadScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleWithFixedDelayAndGetDelayed(this.singleThreadScheduler, lft, this.taskPriority, initialDelay, delayInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate(lft, d);
    }

    @Override
    protected ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long periodInMillis) {
        task = new AbstractExecutorServiceWrapper.ThrowableHandlingRecurringRunnable(this.scheduler, task);
        AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask lft = new AbstractExecutorServiceWrapper.CancelRemovingListenableFutureTask(this.scheduler, true, task, this.singleThreadScheduler);
        Delayed d = ThreadlyInternalAccessor.doScheduleAtFixedRateAndGetDelayed(this.singleThreadScheduler, lft, this.taskPriority, initialDelay, periodInMillis);
        return new AbstractExecutorServiceWrapper.ScheduledFutureDelegate(lft, d);
    }
}

