/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.wrapper;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiFunction;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.SubmitterExecutor;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.ExceptionUtils;

public class KeyDistributedExecutor {
    protected static final short CONCURRENT_HASH_MAP_INITIAL_SIZE = 16;
    protected static final short ARRAY_DEQUE_INITIAL_SIZE = 8;
    protected final Executor executor;
    protected final int maxTasksPerCycle;
    protected final BiFunction<Object, Runnable, TaskQueueWorker> wFactory;
    protected final ConcurrentHashMap<Object, TaskQueueWorker> taskWorkers;

    public KeyDistributedExecutor(Executor executor) {
        this(executor, Integer.MAX_VALUE, false);
    }

    public KeyDistributedExecutor(Executor executor, boolean accurateQueueSize) {
        this(executor, Integer.MAX_VALUE, accurateQueueSize);
    }

    public KeyDistributedExecutor(Executor executor, int maxTasksPerCycle) {
        this(executor, maxTasksPerCycle, false);
    }

    public KeyDistributedExecutor(Executor executor, int maxTasksPerCycle, boolean accurateQueueSize) {
        ArgumentVerifier.assertNotNull(executor, "executor");
        ArgumentVerifier.assertGreaterThanZero(maxTasksPerCycle, "maxTasksPerCycle");
        this.executor = executor;
        this.maxTasksPerCycle = maxTasksPerCycle;
        this.wFactory = accurateQueueSize ? (x$0, x$1) -> new StatisticWorker(x$0, (Runnable)x$1) : (x$0, x$1) -> new TaskQueueWorker(x$0, (Runnable)x$1);
        this.taskWorkers = new ConcurrentHashMap(16);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public SubmitterExecutor getExecutorForKey(Object threadKey) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        return new KeySubmitter(threadKey);
    }

    public int getTaskQueueSize(Object threadKey) {
        TaskQueueWorker worker = this.taskWorkers.get(threadKey);
        if (worker == null) {
            return 0;
        }
        return worker.getQueueSize();
    }

    public Map<Object, Integer> getTaskQueueSizeMap() {
        HashMap<Object, Integer> result = new HashMap<Object, Integer>();
        for (Map.Entry<Object, TaskQueueWorker> e : this.taskWorkers.entrySet()) {
            result.put(e.getKey(), e.getValue().getQueueSize());
        }
        return result;
    }

    public void execute(Object threadKey, Runnable task) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        this.addTask(threadKey, task, this.executor);
    }

    protected void addTask(Object threadKey, Runnable task, Executor executor) {
        boolean[] startCapture = new boolean[1];
        TaskQueueWorker worker = this.taskWorkers.compute(threadKey, (k, v) -> {
            if (v == null) {
                startCapture[0] = true;
                v = this.wFactory.apply(threadKey, task);
            } else {
                startCapture[0] = false;
                v.add(task);
            }
            return v;
        });
        if (startCapture[0]) {
            executor.execute(worker);
        }
    }

    public ListenableFuture<?> submit(Object threadKey, Runnable task) {
        return this.submit(threadKey, task, null);
    }

    public <T> ListenableFuture<T> submit(Object threadKey, Runnable task, T result) {
        return this.submit(threadKey, RunnableCallableAdapter.adapt(task, result));
    }

    public <T> ListenableFuture<T> submit(Object threadKey, Callable<T> task) {
        ArgumentVerifier.assertNotNull(threadKey, "threadKey");
        ArgumentVerifier.assertNotNull(task, "task");
        ListenableFutureTask<T> rf = new ListenableFutureTask<T>(task);
        this.addTask(threadKey, rf, this.executor);
        return rf;
    }

    protected class KeySubmitter
    implements SubmitterExecutor {
        protected final Object threadKey;

        protected KeySubmitter(Object threadKey) {
            this.threadKey = threadKey;
        }

        @Override
        public void execute(Runnable command) {
            KeyDistributedExecutor.this.execute(this.threadKey, command);
        }

        @Override
        public ListenableFuture<?> submit(Runnable task) {
            return KeyDistributedExecutor.this.submit(this.threadKey, task);
        }

        @Override
        public <T> ListenableFuture<T> submit(Runnable task, T result) {
            return KeyDistributedExecutor.this.submit(this.threadKey, task, result);
        }

        @Override
        public <T> ListenableFuture<T> submit(Callable<T> task) {
            return KeyDistributedExecutor.this.submit(this.threadKey, task);
        }
    }

    protected class StatisticWorker
    extends TaskQueueWorker {
        private final LongAdder queueSize;

        protected StatisticWorker(Object mapKey, Runnable firstTask) {
            super(mapKey, firstTask);
            this.queueSize = new LongAdder();
            this.queueSize.increment();
        }

        @Override
        public int getQueueSize() {
            return this.queueSize.intValue();
        }

        @Override
        protected void add(Runnable task) {
            this.queueSize.increment();
            super.add(task);
        }

        @Override
        protected void runTask(Runnable task) {
            this.queueSize.decrement();
            super.runTask(task);
        }
    }

    protected class TaskQueueWorker
    implements Runnable {
        protected final Object mapKey;
        protected volatile Runnable firstTask;
        protected Queue<Runnable> queue;

        protected TaskQueueWorker(Object mapKey, Runnable firstTask) {
            this.mapKey = mapKey;
            this.queue = null;
            this.firstTask = firstTask;
        }

        public int getQueueSize() {
            int[] resultCapture = new int[1];
            KeyDistributedExecutor.this.taskWorkers.computeIfPresent(this.mapKey, (k, v) -> {
                resultCapture[0] = (v.firstTask == null ? 0 : 1) + (v.queue == null ? 0 : v.queue.size());
                return v;
            });
            return resultCapture[0];
        }

        protected void add(Runnable task) {
            if (this.queue == null) {
                this.queue = new ArrayDeque<Runnable>(8);
            }
            this.queue.add(task);
        }

        protected void runTask(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable t) {
                ExceptionUtils.handleException(t);
            }
        }

        @Override
        public void run() {
            block3: {
                TaskQueueWorker self;
                int consumedItems = 0;
                if (this.firstTask != null) {
                    ++consumedItems;
                    Runnable task = this.firstTask;
                    this.firstTask = null;
                    this.runTask(task);
                }
                block0: while (true) {
                    Queue[] nextQueue = new Queue[1];
                    int fConsumedItems = consumedItems;
                    self = KeyDistributedExecutor.this.taskWorkers.compute(this.mapKey, (k, v) -> {
                        if (this.queue == null) {
                            return null;
                        }
                        if (fConsumedItems < KeyDistributedExecutor.this.maxTasksPerCycle) {
                            if (this.queue.size() + fConsumedItems <= KeyDistributedExecutor.this.maxTasksPerCycle) {
                                nextQueue[0] = this.queue;
                                this.queue = null;
                            } else {
                                int nextListSize = KeyDistributedExecutor.this.maxTasksPerCycle - fConsumedItems;
                                nextQueue[0] = new ArrayDeque(nextListSize);
                                Iterator it = this.queue.iterator();
                                do {
                                    nextQueue[0].add((Runnable)it.next());
                                    it.remove();
                                } while (nextQueue[0].size() < nextListSize);
                            }
                        } else {
                            nextQueue[0] = null;
                        }
                        return v;
                    });
                    if (nextQueue[0] == null) break;
                    consumedItems += nextQueue[0].size();
                    Iterator iterator = nextQueue[0].iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block0;
                        Runnable r = (Runnable)iterator.next();
                        this.runTask(r);
                    }
                    break;
                }
                if (self == null) break block3;
                KeyDistributedExecutor.this.executor.execute(this);
            }
        }
    }
}

