/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.statistics;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.threadly.concurrent.RunnableCallableAdapter;
import org.threadly.concurrent.RunnableContainer;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.concurrent.future.ListenableFutureTask;
import org.threadly.util.Clock;
import org.threadly.util.Pair;
import org.threadly.util.StatisticsUtils;

class PriorityStatisticManager {
    protected final int maxWindowSize;
    protected final boolean accurateTime;
    protected final LongAdder totalHighPriorityExecutions;
    protected final LongAdder totalLowPriorityExecutions;
    protected final LongAdder totalStarvablePriorityExecutions;
    protected final ConcurrentHashMap<Pair<Thread, TaskStatWrapper>, Long> runningTasks;
    protected final ConcurrentArrayList<Long> starvablePriorityRunDurations;
    protected final ConcurrentArrayList<Long> lowPriorityRunDurations;
    protected final ConcurrentArrayList<Long> highPriorityRunDurations;
    protected final ConcurrentArrayList<Long> starvablePriorityExecutionDelay;
    protected final ConcurrentArrayList<Long> lowPriorityExecutionDelay;
    protected final ConcurrentArrayList<Long> highPriorityExecutionDelay;

    protected PriorityStatisticManager(int maxWindowSize, boolean accurateTime) {
        this.maxWindowSize = maxWindowSize;
        this.accurateTime = accurateTime;
        this.totalHighPriorityExecutions = new LongAdder();
        this.totalLowPriorityExecutions = new LongAdder();
        this.totalStarvablePriorityExecutions = new LongAdder();
        this.runningTasks = new ConcurrentHashMap();
        this.starvablePriorityRunDurations = new ConcurrentArrayList(0, maxWindowSize);
        this.lowPriorityRunDurations = new ConcurrentArrayList(0, maxWindowSize);
        this.highPriorityRunDurations = new ConcurrentArrayList(0, maxWindowSize);
        this.starvablePriorityExecutionDelay = new ConcurrentArrayList(0, maxWindowSize);
        this.lowPriorityExecutionDelay = new ConcurrentArrayList(0, maxWindowSize);
        this.highPriorityExecutionDelay = new ConcurrentArrayList(0, maxWindowSize);
    }

    ConcurrentArrayList<Long> getExecutionDurationSamplesInternal(TaskPriority priority) {
        switch (priority) {
            case High: {
                return this.highPriorityRunDurations;
            }
            case Low: {
                return this.lowPriorityRunDurations;
            }
            case Starvable: {
                return this.starvablePriorityRunDurations;
            }
        }
        throw new UnsupportedOperationException();
    }

    ConcurrentArrayList<Long> getExecutionDelaySamplesInternal(TaskPriority priority) {
        switch (priority) {
            case High: {
                return this.highPriorityExecutionDelay;
            }
            case Low: {
                return this.lowPriorityExecutionDelay;
            }
            case Starvable: {
                return this.starvablePriorityExecutionDelay;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected LongAdder getExecutionCount(TaskPriority priority) {
        switch (priority) {
            case High: {
                return this.totalHighPriorityExecutions;
            }
            case Low: {
                return this.totalLowPriorityExecutions;
            }
            case Starvable: {
                return this.totalStarvablePriorityExecutions;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected void trackTaskStart(Pair<Thread, TaskStatWrapper> taskPair) {
        this.getExecutionCount(taskPair.getRight().priority).increment();
        this.runningTasks.put(taskPair, Clock.accurateForwardProgressingMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackTaskFinish(Pair<Thread, TaskStatWrapper> taskPair) {
        long finishTime = this.accurateTime ? Clock.accurateForwardProgressingMillis() : Clock.lastKnownForwardProgressingMillis();
        ConcurrentArrayList<Long> runDurations = this.getExecutionDurationSamplesInternal(taskPair.getRight().priority);
        Long startTime = this.runningTasks.remove(taskPair);
        Object object = runDurations.getModificationLock();
        synchronized (object) {
            runDurations.add(finishTime - startTime);
            this.trimWindow(runDurations);
        }
    }

    protected void trimWindow(Deque window) {
        while (window.size() > this.maxWindowSize) {
            window.removeFirst();
        }
    }

    public List<Long> getExecutionDelaySamples() {
        ArrayList<Long> resultList = new ArrayList<Long>(this.highPriorityExecutionDelay);
        resultList.addAll(this.lowPriorityExecutionDelay);
        resultList.addAll(this.starvablePriorityExecutionDelay);
        return resultList;
    }

    public List<Long> getExecutionDelaySamples(TaskPriority priority) {
        if (priority == null) {
            return this.getExecutionDelaySamples();
        }
        return new ArrayList<Long>(this.getExecutionDelaySamplesInternal(priority));
    }

    public double getAverageExecutionDelay() {
        List<Long> resultList = this.getExecutionDelaySamples();
        if (resultList.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(resultList);
    }

    public double getAverageExecutionDelay(TaskPriority priority) {
        if (priority == null) {
            return this.getAverageExecutionDelay();
        }
        List<Long> stats = this.getExecutionDelaySamples(priority);
        if (stats.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(stats);
    }

    public Map<Double, Long> getExecutionDelayPercentiles(double ... percentiles) {
        List<Long> samples = this.getExecutionDelaySamples();
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    public Map<Double, Long> getExecutionDelayPercentiles(TaskPriority priority, double ... percentiles) {
        List<Long> samples = this.getExecutionDelaySamples(priority);
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    public List<Long> getExecutionDurationSamples() {
        ArrayList<Long> resultList = new ArrayList<Long>(this.highPriorityRunDurations);
        resultList.addAll(this.lowPriorityRunDurations);
        resultList.addAll(this.starvablePriorityRunDurations);
        return resultList;
    }

    public List<Long> getExecutionDurationSamples(TaskPriority priority) {
        if (priority == null) {
            return this.getExecutionDurationSamples();
        }
        return new ArrayList<Long>(this.getExecutionDurationSamplesInternal(priority));
    }

    public double getAverageExecutionDuration() {
        List<Long> runDurations = this.getExecutionDurationSamples();
        if (runDurations.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(runDurations);
    }

    public double getAverageExecutionDuration(TaskPriority priority) {
        List<Long> runDurations = this.getExecutionDurationSamples(priority);
        if (runDurations.isEmpty()) {
            return -1.0;
        }
        return StatisticsUtils.getAverage(runDurations);
    }

    public Map<Double, Long> getExecutionDurationPercentiles(double ... percentiles) {
        List<Long> samples = this.getExecutionDurationSamples();
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    public Map<Double, Long> getExecutionDurationPercentiles(TaskPriority priority, double ... percentiles) {
        List<Long> samples = this.getExecutionDurationSamples(priority);
        if (samples.isEmpty()) {
            samples.add(0L);
        }
        return StatisticsUtils.getPercentiles(samples, percentiles);
    }

    public List<Pair<Runnable, StackTraceElement[]>> getLongRunningTasks(long durationLimitMillis) {
        ArrayList<Pair<Runnable, StackTraceElement[]>> result = new ArrayList<Pair<Runnable, StackTraceElement[]>>();
        if (this.accurateTime) {
            Clock.accurateForwardProgressingMillis();
        }
        for (Map.Entry<Pair<Thread, TaskStatWrapper>, Long> e : this.runningTasks.entrySet()) {
            ListenableFutureTask lft;
            if (Clock.lastKnownForwardProgressingMillis() - e.getValue() <= durationLimitMillis) continue;
            Runnable task = e.getKey().getRight().task;
            if (task instanceof ListenableFutureTask && (lft = (ListenableFutureTask)task).getContainedCallable() instanceof RunnableCallableAdapter) {
                RunnableCallableAdapter rca = (RunnableCallableAdapter)lft.getContainedCallable();
                task = rca.getContainedRunnable();
            }
            StackTraceElement[] stack = e.getKey().getLeft().getStackTrace();
            if (!this.runningTasks.containsKey(e.getKey())) continue;
            result.add(new Pair<Runnable, StackTraceElement[]>(task, stack));
        }
        return result;
    }

    public int getLongRunningTasksQty(long durationLimitMillis) {
        int result = 0;
        long now = this.accurateTime ? Clock.accurateForwardProgressingMillis() : Clock.lastKnownForwardProgressingMillis();
        for (Long startTime : this.runningTasks.values()) {
            if (now - startTime < durationLimitMillis) continue;
            ++result;
        }
        return result;
    }

    public void resetCollectedStats() {
        for (TaskPriority p : TaskPriority.values()) {
            this.getExecutionDelaySamplesInternal(p).clear();
            this.getExecutionDurationSamplesInternal(p).clear();
        }
    }

    public long getTotalExecutionCount() {
        long result = 0L;
        for (TaskPriority p : TaskPriority.values()) {
            result += this.getExecutionCount(p).sum();
        }
        return result;
    }

    public long getTotalExecutionCount(TaskPriority priority) {
        if (priority == null) {
            return this.getTotalExecutionCount();
        }
        return this.getExecutionCount(priority).sum();
    }

    protected static class TaskStatWrapper
    implements Runnable,
    RunnableContainer {
        protected final PriorityStatisticManager statsManager;
        protected final TaskPriority priority;
        protected final Runnable task;

        public TaskStatWrapper(PriorityStatisticManager statsManager, TaskPriority priority, Runnable toRun) {
            this.statsManager = statsManager;
            this.priority = priority;
            this.task = toRun;
        }

        @Override
        public void run() {
            Pair<Thread, TaskStatWrapper> taskPair = new Pair<Thread, TaskStatWrapper>(Thread.currentThread(), this);
            this.statsManager.trackTaskStart(taskPair);
            try {
                this.task.run();
            }
            finally {
                this.statsManager.trackTaskFinish(taskPair);
            }
        }

        @Override
        public Runnable getContainedRunnable() {
            return this.task;
        }
    }
}

