/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.statistics;

import java.util.List;
import java.util.Map;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.NoThreadScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.concurrent.collections.ConcurrentArrayList;
import org.threadly.concurrent.statistics.PriorityStatisticManager;
import org.threadly.concurrent.statistics.StatisticPriorityScheduler;
import org.threadly.util.Clock;
import org.threadly.util.Pair;

public class NoThreadSchedulerStatisticTracker
extends NoThreadScheduler
implements StatisticPriorityScheduler {
    protected final PriorityStatisticManager statsManager;

    public NoThreadSchedulerStatisticTracker() {
        this(null, 500L);
    }

    public NoThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        this(defaultPriority, maxWaitForLowPriorityInMs, 1000);
    }

    public NoThreadSchedulerStatisticTracker(int maxStatisticWindowSize) {
        this(null, 500L, maxStatisticWindowSize);
    }

    public NoThreadSchedulerStatisticTracker(int maxStatisticWindowSize, boolean accurateTime) {
        this(null, 500L, maxStatisticWindowSize, accurateTime);
    }

    public NoThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, int maxStatisticWindowSize) {
        this(defaultPriority, maxWaitForLowPriorityInMs, maxStatisticWindowSize, false);
    }

    public NoThreadSchedulerStatisticTracker(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs, int maxStatisticWindowSize, boolean accurateTime) {
        super(defaultPriority, maxWaitForLowPriorityInMs);
        this.statsManager = new PriorityStatisticManager(maxStatisticWindowSize, accurateTime);
    }

    private Runnable wrap(Runnable task, TaskPriority priority) {
        if (task == null) {
            return null;
        }
        return new PriorityStatisticManager.TaskStatWrapper(this.statsManager, priority == null ? this.getDefaultPriority() : priority, task);
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        return super.doSchedule(new PriorityStatisticManager.TaskStatWrapper(this.statsManager, priority, task), delayInMillis, priority);
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        super.scheduleWithFixedDelay(this.wrap(task, priority), initialDelay, recurringDelay, priority);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        super.scheduleAtFixedRate(this.wrap(task, priority), initialDelay, period, priority);
    }

    @Override
    public List<Long> getExecutionDelaySamples() {
        return this.statsManager.getExecutionDelaySamples();
    }

    @Override
    public List<Long> getExecutionDelaySamples(TaskPriority priority) {
        return this.statsManager.getExecutionDelaySamples(priority);
    }

    @Override
    public double getAverageExecutionDelay() {
        return this.statsManager.getAverageExecutionDelay();
    }

    @Override
    public double getAverageExecutionDelay(TaskPriority priority) {
        return this.statsManager.getAverageExecutionDelay(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(double ... percentiles) {
        return this.statsManager.getExecutionDelayPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDelayPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statsManager.getExecutionDelayPercentiles(priority, percentiles);
    }

    @Override
    public List<Long> getExecutionDurationSamples() {
        return this.statsManager.getExecutionDurationSamples();
    }

    @Override
    public List<Long> getExecutionDurationSamples(TaskPriority priority) {
        return this.statsManager.getExecutionDurationSamples(priority);
    }

    @Override
    public double getAverageExecutionDuration() {
        return this.statsManager.getAverageExecutionDuration();
    }

    @Override
    public double getAverageExecutionDuration(TaskPriority priority) {
        return this.statsManager.getAverageExecutionDuration(priority);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(double ... percentiles) {
        return this.statsManager.getExecutionDurationPercentiles(percentiles);
    }

    @Override
    public Map<Double, Long> getExecutionDurationPercentiles(TaskPriority priority, double ... percentiles) {
        return this.statsManager.getExecutionDurationPercentiles(priority, percentiles);
    }

    @Override
    public List<Pair<Runnable, StackTraceElement[]>> getLongRunningTasks(long durationLimitMillis) {
        return this.statsManager.getLongRunningTasks(durationLimitMillis);
    }

    @Override
    public int getLongRunningTasksQty(long durationLimitMillis) {
        return this.statsManager.getLongRunningTasksQty(durationLimitMillis);
    }

    @Override
    public void resetCollectedStats() {
        this.statsManager.resetCollectedStats();
    }

    @Override
    public long getTotalExecutionCount() {
        return this.statsManager.getTotalExecutionCount();
    }

    @Override
    public long getTotalExecutionCount(TaskPriority priority) {
        return this.statsManager.getTotalExecutionCount(priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPriorityScheduler.TaskWrapper getNextReadyTask() {
        AbstractPriorityScheduler.TaskWrapper result = super.getNextReadyTask();
        if (result != null && result.getContainedRunnable() instanceof PriorityStatisticManager.TaskStatWrapper) {
            long taskDelay = Clock.lastKnownForwardProgressingMillis() - result.getPureRunTime();
            PriorityStatisticManager.TaskStatWrapper statWrapper = (PriorityStatisticManager.TaskStatWrapper)result.getContainedRunnable();
            ConcurrentArrayList<Long> priorityStats = this.statsManager.getExecutionDelaySamplesInternal(statWrapper.priority);
            Object object = priorityStats.getModificationLock();
            synchronized (object) {
                priorityStats.add(taskDelay);
                this.statsManager.trimWindow(priorityStats);
            }
        }
        return result;
    }
}

