/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future.watchdog;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;
import org.threadly.concurrent.future.watchdog.AbstractWatchdog;
import org.threadly.concurrent.future.watchdog.ConstantTimeWatchdog;
import org.threadly.util.ArgumentVerifier;

public class MixedTimeWatchdog {
    protected static final int INSPECTION_INTERVAL_MILLIS = 10000;
    protected static final int DEFAULT_RESOLUTION_MILLIS = 200;
    private static final AtomicReference<MixedTimeWatchdog> INTERRUPTING_WATCHDOG_CACHE = new AtomicReference();
    private static final AtomicReference<MixedTimeWatchdog> NONINTERRUPTING_WATCHDOG_CACHE = new AtomicReference();
    protected final SubmitterScheduler scheduler;
    protected final boolean sendInterruptOnFutureCancel;
    protected final ConcurrentMap<Long, ConstantTimeWatchdog> cachedDogs;
    protected final Function<Long, ConstantTimeWatchdog> watchdogProducer;
    protected final Runnable cacheCleaner;
    protected final long resolutionMillis;
    private final AtomicBoolean cleanerScheduled;

    public static final MixedTimeWatchdog centralWatchdog(boolean sendInterruptOnFutureCancel) {
        AtomicReference<MixedTimeWatchdog> ar = sendInterruptOnFutureCancel ? INTERRUPTING_WATCHDOG_CACHE : NONINTERRUPTING_WATCHDOG_CACHE;
        MixedTimeWatchdog wd = ar.get();
        if (wd == null) {
            ar.compareAndSet(null, new MixedTimeWatchdog(AbstractWatchdog.getStaticScheduler(), sendInterruptOnFutureCancel));
            wd = ar.get();
        }
        return wd;
    }

    public MixedTimeWatchdog(SubmitterScheduler scheduler, boolean sendInterruptOnFutureCancel) {
        this(scheduler, sendInterruptOnFutureCancel, 200L);
    }

    public MixedTimeWatchdog(SubmitterScheduler scheduler, boolean sendInterruptOnFutureCancel, long resolutionMillis) {
        ArgumentVerifier.assertGreaterThanZero(resolutionMillis, "resolutionMillis");
        this.scheduler = scheduler;
        this.sendInterruptOnFutureCancel = sendInterruptOnFutureCancel;
        this.cachedDogs = new ConcurrentHashMap<Long, ConstantTimeWatchdog>();
        this.watchdogProducer = timeout -> {
            this.maybeScheduleCleaner();
            return new ConstantTimeWatchdog(scheduler, (long)timeout, sendInterruptOnFutureCancel);
        };
        this.cacheCleaner = new CleanRunner();
        this.cleanerScheduled = new AtomicBoolean(false);
        this.resolutionMillis = resolutionMillis;
    }

    public int getWatchingCount() {
        int result = 0;
        for (ConstantTimeWatchdog wd : this.cachedDogs.values()) {
            result += wd.getWatchingCount();
        }
        return result;
    }

    public void watch(long timeoutInMillis, ListenableFuture<?> future) {
        long adjustedTimeout = timeoutInMillis / this.resolutionMillis;
        if ((adjustedTimeout *= this.resolutionMillis) != timeoutInMillis) {
            adjustedTimeout += this.resolutionMillis;
        }
        if (future == null || future.isDone()) {
            return;
        }
        this.cachedDogs.computeIfAbsent(adjustedTimeout, this.watchdogProducer).watch(future);
    }

    private void maybeScheduleCleaner() {
        if (!this.cleanerScheduled.get() && this.cleanerScheduled.compareAndSet(false, true)) {
            this.scheduler.schedule(this.cacheCleaner, 10000L);
        }
    }

    private class CleanRunner
    implements Runnable {
        private CleanRunner() {
        }

        @Override
        public void run() {
            try {
                Iterator it = MixedTimeWatchdog.this.cachedDogs.values().iterator();
                while (it.hasNext()) {
                    if (((ConstantTimeWatchdog)it.next()).isActive()) continue;
                    it.remove();
                }
            }
            finally {
                if (MixedTimeWatchdog.this.cachedDogs.isEmpty()) {
                    MixedTimeWatchdog.this.cleanerScheduled.set(false);
                    if (!MixedTimeWatchdog.this.cachedDogs.isEmpty()) {
                        MixedTimeWatchdog.this.maybeScheduleCleaner();
                    }
                } else {
                    MixedTimeWatchdog.this.scheduler.schedule(this, 10000L);
                }
            }
        }
    }
}

