/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.future.watchdog;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.threadly.concurrent.CentralThreadlyPool;
import org.threadly.concurrent.ReschedulingOperation;
import org.threadly.concurrent.SameThreadSubmitterExecutor;
import org.threadly.concurrent.SubmitterScheduler;
import org.threadly.concurrent.future.ListenableFuture;

class AbstractWatchdog {
    private static final AtomicReference<SubmitterScheduler> STATIC_SCHEDULER = new AtomicReference();
    protected final Collection<Object> futures = new ConcurrentLinkedQueue<Object>();
    protected final ReschedulingOperation checkRunner;

    protected static final SubmitterScheduler getStaticScheduler() {
        SubmitterScheduler ss = STATIC_SCHEDULER.get();
        if (ss == null) {
            STATIC_SCHEDULER.compareAndSet(null, CentralThreadlyPool.threadPool(2, "WatchdogDefaultScheduler"));
            ss = STATIC_SCHEDULER.get();
        }
        return ss;
    }

    protected AbstractWatchdog(Function<Collection<?>, ReschedulingOperation> checkFactory) {
        this.checkRunner = checkFactory.apply(this.futures);
    }

    public boolean isActive() {
        return this.checkRunner.isActive() || !this.futures.isEmpty();
    }

    public int getWatchingCount() {
        return this.futures.size();
    }

    protected void watchWrapper(Object fw, ListenableFuture<?> future) {
        this.futures.add(fw);
        future.listener(new WrapperRemover(fw), SameThreadSubmitterExecutor.instance());
        this.checkRunner.signalToRun();
    }

    protected class WrapperRemover
    implements Runnable {
        private final Object fw;

        protected WrapperRemover(Object fw) {
            this.fw = fw;
        }

        @Override
        public void run() {
            AbstractWatchdog.this.futures.remove(this.fw);
        }
    }
}

