/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent.event;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.Executor;
import org.threadly.concurrent.event.ListenerHelper;
import org.threadly.util.ArgumentVerifier;

public class AsyncCallListenerHelper<T>
extends ListenerHelper<T> {
    protected final Executor executor;

    public AsyncCallListenerHelper(Class<? super T> listenerInterface, Executor executor) {
        super(listenerInterface);
        ArgumentVerifier.assertNotNull(executor, "executor");
        this.executor = executor;
    }

    @Override
    protected T makeProxyInstance(Class<? super T> listenerInterface) {
        return (T)Proxy.newProxyInstance(listenerInterface.getClassLoader(), new Class[]{listenerInterface}, (InvocationHandler)new AsyncListenerCaller());
    }

    protected class AsyncListenerCaller
    extends ListenerHelper.ListenerCaller {
        protected AsyncListenerCaller() {
            super(AsyncCallListenerHelper.this);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            this.verifyValidMethod(method);
            AsyncCallListenerHelper.this.executor.execute(new CallListenersTask(method, args));
            return null;
        }

        protected class CallListenersTask
        implements Runnable {
            private final Method method;
            private final Object[] args;

            public CallListenersTask(Method method, Object[] args) {
                this.method = method;
                this.args = args;
            }

            @Override
            public void run() {
                AsyncListenerCaller.this.callListeners(this.method, this.args);
            }
        }
    }
}

