/*
 * Decompiled with CFR 0.152.
 */
package org.threadly.concurrent;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.threadly.concurrent.AbstractPriorityScheduler;
import org.threadly.concurrent.TaskPriority;
import org.threadly.util.ArgumentVerifier;
import org.threadly.util.Clock;
import org.threadly.util.ExceptionHandler;
import org.threadly.util.ExceptionUtils;

public class NoThreadScheduler
extends AbstractPriorityScheduler {
    protected final AbstractPriorityScheduler.QueueSetListener queueListener = new AbstractPriorityScheduler.QueueSetListener(){

        @Override
        public void handleQueueUpdate() {
            Thread t = NoThreadScheduler.this.blockingThread.get();
            if (t != null) {
                LockSupport.unpark(t);
            }
        }
    };
    protected final AbstractPriorityScheduler.QueueManager queueManager;
    protected final AtomicReference<Thread> blockingThread;
    private volatile boolean tickRunning;
    private volatile boolean tickCanceled;

    public NoThreadScheduler() {
        this(null, 500L);
    }

    public NoThreadScheduler(TaskPriority defaultPriority, long maxWaitForLowPriorityInMs) {
        super(defaultPriority);
        this.queueManager = new AbstractPriorityScheduler.QueueManager(this.queueListener, maxWaitForLowPriorityInMs);
        this.blockingThread = new AtomicReference<Object>(null);
        this.tickRunning = false;
        this.tickCanceled = false;
        this.setMaxWaitForLowPriority(maxWaitForLowPriorityInMs);
    }

    protected long nowInMillis(boolean accurate) {
        if (accurate) {
            return Clock.accurateForwardProgressingMillis();
        }
        return Clock.lastKnownForwardProgressingMillis();
    }

    public void cancelTick() {
        this.tickCanceled = true;
        this.queueListener.handleQueueUpdate();
    }

    public int tick(ExceptionHandler exceptionHandler) {
        return this.tick(exceptionHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tick(ExceptionHandler exceptionHandler, boolean resetCancelTickIfNoTasksRan) {
        int tasks = 0;
        this.tickRunning = true;
        try {
            AbstractPriorityScheduler.TaskWrapper nextTask;
            while ((nextTask = this.getNextReadyTask()) != null && !this.tickCanceled) {
                if (!nextTask.canExecute(nextTask.getExecuteReference())) continue;
                try {
                    nextTask.runTask();
                }
                catch (Throwable t) {
                    if (exceptionHandler != null) {
                        exceptionHandler.handleException(t);
                    }
                    throw ExceptionUtils.makeRuntime(t);
                }
                ++tasks;
            }
            if ((tasks != 0 || resetCancelTickIfNoTasksRan) && this.tickCanceled) {
                this.tickCanceled = false;
            }
            int n = tasks;
            return n;
        }
        finally {
            this.tickRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockingTick(ExceptionHandler exceptionHandler) throws InterruptedException {
        int initialTickResult = this.tick(exceptionHandler, false);
        if (initialTickResult == 0) {
            Thread currentThread = Thread.currentThread();
            if (!this.blockingThread.compareAndSet(null, currentThread)) {
                throw new IllegalStateException("Another thread is already blocking!!");
            }
            try {
                while (true) {
                    if (this.tickCanceled) {
                        this.tickCanceled = false;
                        int n = 0;
                        return n;
                    }
                    if (currentThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    AbstractPriorityScheduler.TaskWrapper nextTask = this.queueManager.getNextTask(true);
                    if (nextTask == null) {
                        LockSupport.park();
                        continue;
                    }
                    long nextTaskDelay = nextTask.getScheduleDelay();
                    if (nextTaskDelay > 0L) {
                        LockSupport.parkNanos(1000000L * nextTaskDelay);
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.blockingThread.lazySet(null);
            }
            return this.tick(exceptionHandler, true);
        }
        return initialTickResult;
    }

    @Override
    protected AbstractPriorityScheduler.OneTimeTaskWrapper doSchedule(Runnable task, long delayInMillis, TaskPriority priority) {
        NoThreadOneTimeTaskWrapper result;
        AbstractPriorityScheduler.QueueSet queueSet = this.queueManager.getQueueSet(priority);
        if (delayInMillis == 0L) {
            result = new NoThreadOneTimeTaskWrapper(task, queueSet.executeQueue, this.nowInMillis(false));
            queueSet.addExecute(result);
        } else {
            result = new NoThreadOneTimeTaskWrapper(task, queueSet.scheduleQueue, this.nowInMillis(true) + delayInMillis);
            queueSet.addScheduled(result);
        }
        return result;
    }

    @Override
    public void scheduleWithFixedDelay(Runnable task, long initialDelay, long recurringDelay, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertNotNegative(recurringDelay, "recurringDelay");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        AbstractPriorityScheduler.QueueSet queueSet = this.queueManager.getQueueSet(priority);
        NoThreadRecurringDelayTaskWrapper taskWrapper = new NoThreadRecurringDelayTaskWrapper(task, queueSet, this.nowInMillis(true) + initialDelay, recurringDelay);
        queueSet.addScheduled(taskWrapper);
    }

    @Override
    public void scheduleAtFixedRate(Runnable task, long initialDelay, long period, TaskPriority priority) {
        ArgumentVerifier.assertNotNull(task, "task");
        ArgumentVerifier.assertNotNegative(initialDelay, "initialDelay");
        ArgumentVerifier.assertGreaterThanZero(period, "period");
        if (priority == null) {
            priority = this.defaultPriority;
        }
        AbstractPriorityScheduler.QueueSet queueSet = this.queueManager.getQueueSet(priority);
        NoThreadRecurringRateTaskWrapper taskWrapper = new NoThreadRecurringRateTaskWrapper(task, queueSet, this.nowInMillis(true) + initialDelay, period);
        queueSet.addScheduled(taskWrapper);
    }

    @Override
    public int getActiveTaskCount() {
        return this.tickRunning ? 1 : 0;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    protected AbstractPriorityScheduler.TaskWrapper getNextReadyTask() {
        AbstractPriorityScheduler.TaskWrapper tw = this.queueManager.getNextTask(true);
        if (tw == null || tw.getScheduleDelay() > 0L) {
            return null;
        }
        return tw;
    }

    public boolean hasTaskReadyToRun() {
        for (TaskPriority p : TaskPriority.values()) {
            if (!NoThreadScheduler.hasTaskReadyToRun(this.queueManager.getQueueSet(p))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTaskReadyToRun(AbstractPriorityScheduler.QueueSet queueSet) {
        if (queueSet.executeQueue.isEmpty()) {
            AbstractPriorityScheduler.TaskWrapper headTask = queueSet.scheduleQueue.peekFirst();
            return headTask != null && headTask.getScheduleDelay() <= 0L;
        }
        return true;
    }

    public long getDelayTillNextTask() {
        AbstractPriorityScheduler.TaskWrapper tw = this.queueManager.getNextTask(true);
        if (tw != null) {
            return tw.getRunTime() - this.nowInMillis(true);
        }
        return Long.MAX_VALUE;
    }

    public List<Runnable> clearTasks() {
        return this.queueManager.clearQueue();
    }

    @Override
    protected AbstractPriorityScheduler.QueueManager getQueueManager() {
        return this.queueManager;
    }

    protected class NoThreadRecurringRateTaskWrapper
    extends NoThreadRecurringTaskWrapper {
        protected final long period;

        protected NoThreadRecurringRateTaskWrapper(Runnable task, AbstractPriorityScheduler.QueueSet queueSet, long firstRunTime, long period) {
            super(task, queueSet, firstRunTime);
            this.period = period;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime += this.period;
        }
    }

    protected class NoThreadRecurringDelayTaskWrapper
    extends NoThreadRecurringTaskWrapper {
        protected final long recurringDelay;

        protected NoThreadRecurringDelayTaskWrapper(Runnable task, AbstractPriorityScheduler.QueueSet queueSet, long firstRunTime, long recurringDelay) {
            super(task, queueSet, firstRunTime);
            this.recurringDelay = recurringDelay;
        }

        @Override
        protected void updateNextRunTime() {
            this.nextRunTime = NoThreadScheduler.this.nowInMillis(true) + this.recurringDelay;
        }
    }

    protected abstract class NoThreadRecurringTaskWrapper
    extends AbstractPriorityScheduler.RecurringTaskWrapper {
        protected NoThreadRecurringTaskWrapper(Runnable task, AbstractPriorityScheduler.QueueSet queueSet, long firstRunTime) {
            super(task, queueSet, firstRunTime);
        }

        @Override
        public long getScheduleDelay() {
            if (this.getRunTime() > NoThreadScheduler.this.nowInMillis(false)) {
                return this.getRunTime() - NoThreadScheduler.this.nowInMillis(true);
            }
            return 0L;
        }

        @Override
        protected abstract void updateNextRunTime();

        @Override
        public void runTask() {
            if (this.invalidated) {
                return;
            }
            try {
                this.task.run();
            }
            finally {
                if (!this.invalidated) {
                    this.updateNextRunTime();
                    this.reschedule();
                }
            }
        }
    }

    protected class NoThreadOneTimeTaskWrapper
    extends AbstractPriorityScheduler.OneTimeTaskWrapper {
        protected NoThreadOneTimeTaskWrapper(Runnable task, Queue<? extends AbstractPriorityScheduler.TaskWrapper> taskQueue, long runTime) {
            super(task, taskQueue, runTime);
        }

        @Override
        public long getScheduleDelay() {
            if (this.getRunTime() > NoThreadScheduler.this.nowInMillis(false)) {
                return this.getRunTime() - NoThreadScheduler.this.nowInMillis(true);
            }
            return 0L;
        }

        @Override
        public void runTask() {
            if (!this.invalidated) {
                this.task.run();
            }
        }
    }
}

