/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server.event;

import com.bonker.stardewfishing.common.FishBehavior;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.bonker.stardewfishing.server.event.StardewMinigameEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;

public class StardewMinigameStartedEvent
extends StardewMinigameEvent {
    private final ItemStack fish;
    private int idleTime;
    private float topSpeed;
    private float upAcceleration;
    private float downAcceleration;
    private int avgDistance;
    private int moveVariation;
    private double lineStrength;
    private int barSize;
    private double treasureChanceBonus;
    private double goldenChestBonus;
    private double expMultiplier;
    private boolean forcedTreasureChest = false;
    private boolean forcedGoldenChest = false;
    private boolean lavaFishing;
    private int qualityBoost = 0;

    public StardewMinigameStartedEvent(ServerPlayer player, FishingHook hook, ItemStack fishingRod, ItemStack fish, FishBehavior behavior, boolean lavaFishing) {
        super(player, hook, fishingRod);
        this.fish = fish;
        this.idleTime = behavior.idleTime();
        this.topSpeed = behavior.topSpeed();
        this.upAcceleration = behavior.upAcceleration();
        this.downAcceleration = behavior.downAcceleration();
        this.avgDistance = behavior.avgDistance();
        this.moveVariation = behavior.moveVariation();
        this.lineStrength = 0.0;
        this.barSize = 36;
        this.treasureChanceBonus = 0.0;
        this.expMultiplier = 1.0;
        this.lavaFishing = lavaFishing;
        float luckBonus = (float)ItemUtils.getLuck(hook) * 0.021f;
        this.treasureChanceBonus += (double)luckBonus;
    }

    public ItemStack getFish() {
        return this.fish;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public void setIdleTime(int idleTime) {
        this.idleTime = Math.max(idleTime, 0);
    }

    public float getTopSpeed() {
        return this.topSpeed;
    }

    public void setTopSpeed(float topSpeed) {
        this.topSpeed = Math.max(topSpeed, 0.0f);
    }

    public float getUpAcceleration() {
        return this.upAcceleration;
    }

    public void setUpAcceleration(float upAcceleration) {
        this.upAcceleration = Math.max(upAcceleration, 0.0f);
    }

    public float getDownAcceleration() {
        return this.downAcceleration;
    }

    public void setDownAcceleration(float downAcceleration) {
        this.downAcceleration = Math.max(downAcceleration, 0.0f);
    }

    public int getAvgDistance() {
        return this.avgDistance;
    }

    public void setAvgDistance(int avgDistance) {
        this.avgDistance = Mth.m_14045_((int)avgDistance, (int)1, (int)126);
    }

    public int getMoveVariation() {
        return this.moveVariation;
    }

    public void setMoveVariation(int moveVariation) {
        this.moveVariation = Math.max(moveVariation, 0);
    }

    public double getLineStrength() {
        return this.lineStrength;
    }

    public void setLineStrength(double lineStrength) {
        this.lineStrength = Mth.m_14008_((double)lineStrength, (double)0.0, (double)1.0);
    }

    public int getBarSize() {
        return this.barSize;
    }

    public void setBarSize(int barSize) {
        this.barSize = Mth.m_14045_((int)barSize, (int)4, (int)142);
    }

    public double getTreasureChanceBonus() {
        return this.treasureChanceBonus;
    }

    public void setTreasureChanceBonus(double treasureChanceBonus) {
        this.treasureChanceBonus = Mth.m_14008_((double)treasureChanceBonus, (double)0.0, (double)1.0);
    }

    public double getGoldenChanceBonus() {
        return this.goldenChestBonus;
    }

    public void setGoldenChanceBonus(double goldenChestBonus) {
        this.goldenChestBonus = Mth.m_14008_((double)goldenChestBonus, (double)0.0, (double)1.0);
    }

    public double getExpMultiplier() {
        return this.expMultiplier;
    }

    public void setExpMultiplier(double expMultiplier) {
        this.expMultiplier = Math.max(expMultiplier, 0.0);
    }

    public boolean isForcedTreasureChest() {
        return this.forcedTreasureChest;
    }

    public void setForcedTreasureChest(boolean forcedTreasureChest) {
        this.forcedTreasureChest = forcedTreasureChest;
    }

    public boolean isForcedGoldenChest() {
        return this.forcedGoldenChest;
    }

    public void setForcedGoldenChest(boolean forcedGoldenChest) {
        this.forcedGoldenChest = forcedGoldenChest;
    }

    public boolean isLavaFishing() {
        return this.lavaFishing;
    }

    public void setLavaFishing(boolean lavaFishing) {
        this.lavaFishing = lavaFishing;
    }

    public int getQualityBoost() {
        return this.qualityBoost;
    }

    public void setQualityBoost(int qualityBoost) {
        this.qualityBoost = qualityBoost;
    }
}

