/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server.data;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.proxy.MinigameModifiersSupplier;
import com.bonker.stardewfishing.server.data.MinigameModifiers;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class MinigameModifiersReloadListener
extends SimplePreparableReloadListener<Map<String, JsonObject>>
implements MinigameModifiersSupplier {
    private static final Gson GSON_INSTANCE = new Gson();
    private static final ResourceLocation LOCATION = StardewFishing.resource("minigame_modifiers.json");
    @Nullable
    private static MinigameModifiersReloadListener INSTANCE;
    private final Map<Item, MinigameModifiers> modifiers = new HashMap<Item, MinigameModifiers>();

    protected Map<String, JsonObject> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        HashMap<String, JsonObject> objects = new HashMap<String, JsonObject>();
        for (Resource resource : pResourceManager.m_213829_(LOCATION)) {
            try {
                InputStream inputstream = resource.m_215507_();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    objects.put(resource.m_215506_(), (JsonObject)GsonHelper.m_13776_((Gson)GSON_INSTANCE, (Reader)reader, JsonObject.class));
                }
                finally {
                    if (inputstream == null) continue;
                    inputstream.close();
                }
            }
            catch (IOException | RuntimeException exception) {
                StardewFishing.LOGGER.error("Invalid json in minigame modifiers list {} in data pack {}", new Object[]{LOCATION, resource.m_215506_(), exception});
            }
        }
        return objects;
    }

    protected void apply(Map<String, JsonObject> jsonObjects, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        for (Map.Entry<String, JsonObject> entry : jsonObjects.entrySet()) {
            ModifiersList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(errorMsg -> StardewFishing.LOGGER.warn("Failed to decode minigame modifiers list {} in data pack {} - {}", new Object[]{LOCATION, entry.getKey(), errorMsg})).ifPresent(behaviorList -> behaviorList.modifiers.forEach((loc, minigameModifiers) -> {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
                if (item == Items.f_41852_) {
                    if (ModList.get().isLoaded(loc.m_135827_())) {
                        StardewFishing.LOGGER.warn("Mod '{}' present but item not registered: {}. Is the id incorrect?", (Object)loc.m_135827_(), (Object)loc.m_135815_());
                    }
                } else if (behaviorList.replace || !this.modifiers.containsKey(item)) {
                    this.modifiers.put(item, (MinigameModifiers)minigameModifiers);
                } else {
                    this.modifiers.computeIfPresent(item, (i, m) -> m.merge((MinigameModifiers)minigameModifiers));
                }
            }));
        }
    }

    public static MinigameModifiersReloadListener getOrCreate() {
        if (INSTANCE == null) {
            INSTANCE = new MinigameModifiersReloadListener();
        }
        return INSTANCE;
    }

    @Override
    public Map<Item, MinigameModifiers> getData() {
        if (this.modifiers.isEmpty()) {
            StardewFishing.LOGGER.error("No minigame modifiers data is present. Was it accessed before it was loaded?");
        }
        return this.modifiers;
    }

    private record ModifiersList(boolean replace, Map<ResourceLocation, MinigameModifiers> modifiers) {
        private static final Codec<ModifiersList> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(ModifiersList::replace), (App)Codec.unboundedMap((Codec)ResourceLocation.f_135803_, MinigameModifiers.CODEC).fieldOf("modifiers").forGetter(ModifiersList::modifiers)).apply((Applicative)inst, ModifiersList::new));
    }
}

