/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.server;

import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.bonker.stardewfishing.server.data.FishBehaviorReloadListener;
import com.bonker.stardewfishing.server.data.MinigameDisabledPlayers;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class SFCommands {
    private static final DynamicCommandExceptionType NO_BEHAVIOR = new DynamicCommandExceptionType(obj -> Component.m_237110_((String)"commands.stardew_fishing.no_behavior", (Object[])new Object[]{obj}));
    private static final SimpleCommandExceptionType NO_ROD = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.stardew_fishing.no_rod"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        ArgumentTypeInfos.registerByClass(FishBehaviorArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.m_235449_(FishBehaviorArgument::new));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stardew_fishing").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"start_minigame").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"item", (ArgumentType)new FishBehaviorArgument(buildContext)).executes(SFCommands::startMinigame)))).then(Commands.m_82127_((String)"toggle_minigame").executes(SFCommands::toggleMinigame)));
    }

    private static int startMinigame(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        FishingHook hook;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        InteractionHand rodHand = ItemUtils.getRodHand((Player)player);
        if (rodHand == null) {
            throw NO_ROD.create();
        }
        ItemStack stack = ((ItemInput)context.getArgument("item", ItemInput.class)).m_120980_(1, false);
        player.f_36083_ = hook = ItemUtils.spawnHook(player, player.m_21120_(rodHand), player.m_20182_().m_82520_(0.0, 1.0, 0.0));
        FishingHookLogic.getStoredRewards(hook).ifPresent(rewards -> {
            rewards.clear();
            rewards.add(stack);
        });
        FishingHookLogic.startStardewMinigame(((CommandSourceStack)context.getSource()).m_81375_());
        return 0;
    }

    private static int toggleMinigame(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        MinigameDisabledPlayers data;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        boolean disabled = (data = MinigameDisabledPlayers.get(source.m_81377_())).isMinigameDisabled(player);
        data.setMinigameDisabled(player, !disabled);
        source.m_288197_(() -> Component.m_237115_((String)("commands.stardew_fishing." + (disabled ? "enabled" : "disabled") + "_minigame")), true);
        return 0;
    }

    public static class FishBehaviorArgument
    extends ItemArgument {
        public FishBehaviorArgument(CommandBuildContext pContext) {
            super(pContext);
        }

        public ItemInput parse(StringReader pReader) throws CommandSyntaxException {
            ItemInput item = super.parse(pReader);
            if (!FishBehaviorReloadListener.getKeys().contains(ForgeRegistries.ITEMS.getKey((Object)item.m_120979_()))) {
                throw NO_BEHAVIOR.createWithContext((ImmutableStringReader)pReader, (Object)item.m_120979_());
            }
            return item;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> pContext, SuggestionsBuilder pBuilder) {
            return SharedSuggestionProvider.m_82926_(FishBehaviorReloadListener.getKeys(), (SuggestionsBuilder)pBuilder);
        }
    }
}

