/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.proxy;

import com.bonker.stardewfishing.proxy.ItemUtils;
import com.li64.tide.data.TideTags;
import com.li64.tide.data.rods.CustomRodManager;
import com.li64.tide.registries.TideEntityTypes;
import com.li64.tide.registries.entities.misc.fishing.HookAccessor;
import com.li64.tide.registries.entities.misc.fishing.TideFishingHook;
import com.li64.tide.registries.items.TideFishingRodItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class TideProxy {
    public static void damageEquippedBobber(ItemStack fishingRod, ServerPlayer player) {
        if (!CustomRodManager.hasBobber((ItemStack)fishingRod)) {
            return;
        }
        ItemUtils.tryDamageBobber(TideProxy.getBobber(fishingRod), player).ifPresent(b -> CustomRodManager.setBobber((ItemStack)fishingRod, (ItemStack)b));
    }

    public static ItemStack getBobber(ItemStack fishingRod) {
        return CustomRodManager.hasBobber((ItemStack)fishingRod) ? CustomRodManager.getBobber((ItemStack)fishingRod) : ItemStack.f_41583_;
    }

    public static boolean isTideRod(ItemStack fishingRod) {
        return fishingRod.m_41720_() instanceof TideFishingRodItem;
    }

    public static boolean isTideBobber(ItemStack stack) {
        return stack.m_204117_(TideTags.Items.BOBBERS);
    }

    public static void setBobber(ItemStack fishingRod, ItemStack bobber) {
        CustomRodManager.setBobber((ItemStack)fishingRod, (ItemStack)bobber);
    }

    public static FishingHook spawnHook(Player player, ItemStack fishingRod, Vec3 pos) {
        TideFishingHook hook = new TideFishingHook(TideEntityTypes.FISHING_BOBBER, player, player.m_9236_(), 0, 0, 1.0f, fishingRod){

            public void m_8119_() {
                this.m_6075_();
            }
        };
        player.m_9236_().m_7967_((Entity)hook);
        hook.m_146884_(pos);
        HookAccessor accessor = new HookAccessor(hook, player.m_9236_());
        player.m_9236_().m_7967_((Entity)accessor);
        return accessor;
    }

    public static List<ItemStack> getAllModifierItems(ItemStack fishingRod) {
        ArrayList<ItemStack> modifiers = new ArrayList<ItemStack>();
        modifiers.add(fishingRod);
        if (CustomRodManager.hasBobber((ItemStack)fishingRod)) {
            modifiers.add(CustomRodManager.getBobber((ItemStack)fishingRod));
        }
        if (CustomRodManager.hasHook((ItemStack)fishingRod)) {
            modifiers.add(CustomRodManager.getHook((ItemStack)fishingRod));
        }
        if (CustomRodManager.hasLine((ItemStack)fishingRod)) {
            modifiers.add(CustomRodManager.getLine((ItemStack)fishingRod));
        }
        return modifiers;
    }

    public static boolean isTideHookEntity(FishingHook hook) {
        return hook instanceof HookAccessor;
    }

    public static int getLuck(FishingHook hook) {
        if (hook instanceof HookAccessor) {
            HookAccessor accessor = (HookAccessor)hook;
            Player owner = accessor.m_37168_();
            return owner == null ? 0 : HookAccessor.getHook((Player)owner).getLuck();
        }
        return 0;
    }
}

