/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.proxy;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.proxy.AquacultureProxy;
import com.bonker.stardewfishing.proxy.TideProxy;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;

public class ItemUtils {
    public static ItemStack getBobber(ItemStack fishingRod) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(fishingRod)) {
            return AquacultureProxy.getBobber(fishingRod);
        }
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(fishingRod)) {
            return TideProxy.getBobber(fishingRod);
        }
        return ItemUtils.getBobberNBT(fishingRod);
    }

    public static boolean isFishingRod(ItemStack stack) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(stack)) {
            return true;
        }
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(stack)) {
            return true;
        }
        return stack.m_204117_(StardewFishing.MODIFIABLE_RODS);
    }

    public static boolean isBobber(ItemStack stack) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaBobber(stack)) {
            return true;
        }
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideBobber(stack)) {
            return true;
        }
        return stack.m_204117_(StardewFishing.BOBBERS);
    }

    public static void setBobber(ItemStack fishingRod, ItemStack bobber) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(fishingRod)) {
            AquacultureProxy.setBobber(fishingRod, bobber);
        } else if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(fishingRod)) {
            TideProxy.setBobber(fishingRod, bobber);
        } else {
            ItemUtils.setBobberNBT(fishingRod, bobber);
        }
    }

    public static void damageAttachedBobber(ItemStack fishingRod, ServerPlayer player) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(fishingRod)) {
            AquacultureProxy.damageEquippedBobber(fishingRod, player);
        } else if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(fishingRod)) {
            TideProxy.damageEquippedBobber(fishingRod, player);
        } else {
            ItemStack bobber = ItemUtils.getBobber(fishingRod);
            if (bobber.m_41619_()) {
                return;
            }
            ItemUtils.tryDamageBobber(bobber, player).ifPresent(b -> ItemUtils.setBobber(fishingRod, b));
        }
    }

    public static Optional<ItemStack> tryDamageBobber(ItemStack bobber, ServerPlayer player) {
        if (!bobber.m_41763_()) {
            return Optional.empty();
        }
        ItemStack bobberCache = bobber.m_41777_();
        bobber.m_41622_(1, (LivingEntity)player, p -> {
            player.m_284548_().m_247517_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS);
            Vec3 particlePos = player.m_146892_().m_82549_(player.m_20154_());
            player.m_284548_().m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, bobberCache), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), 8, 0.1, 0.1, 0.1, 0.1);
            player.m_5661_((Component)Component.m_237110_((String)"stardew_fishing.bobber_broke", (Object[])new Object[]{bobberCache.m_41786_()}), true);
        });
        return Optional.of(bobber);
    }

    private static ItemStack getBobberNBT(ItemStack fishingRod) {
        CompoundTag modifier;
        CompoundTag nbt = fishingRod.m_41784_();
        if (nbt.m_128425_("modifier", 10) && (modifier = nbt.m_128469_("modifier")).m_128425_("bobber", 10)) {
            return ItemStack.m_41712_((CompoundTag)modifier.m_128469_("bobber"));
        }
        return ItemStack.f_41583_;
    }

    private static void setBobberNBT(ItemStack fishingRod, ItemStack bobber) {
        CompoundTag nbt = fishingRod.m_41784_();
        CompoundTag modifier = nbt.m_128425_("modifier", 10) ? nbt.m_128469_("modifier") : new CompoundTag();
        modifier.m_128365_("bobber", (Tag)bobber.m_41739_(new CompoundTag()));
        nbt.m_128365_("modifier", (Tag)modifier);
    }

    public static FishingHook spawnHook(ServerPlayer player, ItemStack fishingRod, Vec3 pos) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(fishingRod)) {
            return AquacultureProxy.spawnHook(player, fishingRod, pos);
        }
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(fishingRod)) {
            return TideProxy.spawnHook((Player)player, fishingRod, pos);
        }
        FishingHook hook = new FishingHook((Player)player, player.m_9236_(), 0, 0){

            public void m_8119_() {
                this.m_6075_();
            }
        };
        hook.m_146884_(pos);
        player.m_9236_().m_7967_((Entity)hook);
        return hook;
    }

    public static List<ItemStack> getAllModifierItems(ItemStack fishingRod) {
        if (StardewFishing.AQUACULTURE_INSTALLED && AquacultureProxy.isAquaRod(fishingRod)) {
            return AquacultureProxy.getAllModifierItems(fishingRod);
        }
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideRod(fishingRod)) {
            return TideProxy.getAllModifierItems(fishingRod);
        }
        ArrayList<ItemStack> modifiers = new ArrayList<ItemStack>();
        modifiers.add(fishingRod);
        ItemStack bobber = ItemUtils.getBobberNBT(fishingRod);
        if (!bobber.m_41619_()) {
            modifiers.add(bobber);
        }
        return modifiers;
    }

    public static int getLuck(FishingHook hook) {
        if (StardewFishing.TIDE_INSTALLED && TideProxy.isTideHookEntity(hook)) {
            return TideProxy.getLuck(hook);
        }
        return hook.f_37096_;
    }

    public static boolean isLegendaryFish(ItemStack stack) {
        return stack.m_204117_(StardewFishing.LEGENDARY_FISH);
    }

    public static void recordLegendaryCatch(ItemStack stack, Player player) {
        CompoundTag nbt = stack.m_41784_();
        CompoundTag object = new CompoundTag();
        object.m_128359_("player", player.m_6302_());
        object.m_128356_("time", new Date().getTime());
        nbt.m_128365_("legendary_catch", (Tag)object);
    }

    public static void addCatchTooltip(ItemStack stack, List<Component> tooltip) {
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        if (nbt.m_128441_("legendary_catch")) {
            CompoundTag object = nbt.m_128469_("legendary_catch");
            String player = object.m_128461_("player");
            String time = DateFormat.getDateTimeInstance().format(new Date(object.m_128454_("time")));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237110_((String)"tooltip.stardew_fishing.legendary_data", (Object[])new Object[]{player, time}).m_130948_(StardewFishing.LIGHTER_COLOR));
        }
    }

    public static InteractionHand getRodHand(Player player) {
        boolean mainHand = player.m_21120_(InteractionHand.MAIN_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (mainHand) {
            return InteractionHand.MAIN_HAND;
        }
        boolean offHand = player.m_21120_(InteractionHand.OFF_HAND).canPerformAction(ToolActions.FISHING_ROD_CAST);
        if (offHand) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }
}

