/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.mixin;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.scouter.netherdepthsupgrade.entity.entities.LavaFishingBobberEntity"})
public abstract class LavaFishingBobberEntityMixin
extends FishingHook {
    @Shadow
    private int nibble;
    @Shadow
    private int timeUntilHooked;
    @Shadow
    private int timeUntilLured;
    @Shadow
    @Final
    private int lureSpeed;

    private LavaFishingBobberEntityMixin(EntityType<? extends FishingHook> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"catchingFish(Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void cancel_catchingFish(BlockPos pPos, CallbackInfo ci) {
        if (this.nibble <= 0 && this.timeUntilHooked <= 0 && this.timeUntilLured <= 0) {
            this.timeUntilLured = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed * 20 * 5;
            this.timeUntilLured = Math.max(10, (int)((double)this.timeUntilLured * SFConfig.getBiteTimeMultiplier()));
        }
        if (FishingHookLogic.getStoredRewards(this).map(list -> !list.isEmpty()).orElse(false).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")}, cancellable=true)
    public void retrieve(ItemStack pStack, CallbackInfoReturnable<Integer> cir, @Local List<ItemStack> items) {
        ServerPlayer player = (ServerPlayer)this.m_37168_();
        if (player == null) {
            return;
        }
        if (items.stream().anyMatch(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME))) {
            FishingHookLogic.getStoredRewards(this).ifPresent(rewards -> rewards.addAll(items));
            if (FishingHookLogic.startStardewMinigame(player)) {
                cir.cancel();
            }
        } else {
            FishingHookLogic.modifyRewards(items, 0.0, 0);
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SFSoundEvents.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

