/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.mixin;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.mixin.FishingHookAccessor;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Entity
implements FishingHookAccessor {
    private FishingHookMixin(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"catchingFish"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancel_catchingFish(BlockPos pPos, CallbackInfo ci) {
        FishingHook hook = (FishingHook)this;
        if (this.getNibble() <= 0 && this.getTimeUntilHooked() <= 0 && this.getTimeUntilLured() <= 0) {
            int time = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
            time -= this.getLureSpeed() * 20 * 5;
            time = Math.max(10, (int)((double)time * SFConfig.getBiteTimeMultiplier()));
            this.setTimeUntilLured(time);
        }
        if (FishingHookLogic.getStoredRewards(hook).map(list -> !list.isEmpty()).orElse(false).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/eventbus/api/IEventBus;post(Lnet/minecraftforge/eventbus/api/Event;)Z")}, cancellable=true)
    public void retrieve(ItemStack pStack, CallbackInfoReturnable<Integer> cir, @Local List<ItemStack> items) {
        FishingHook hook = (FishingHook)this;
        ServerPlayer player = (ServerPlayer)hook.m_37168_();
        if (player == null) {
            return;
        }
        if (items.stream().anyMatch(stack -> stack.m_204117_(StardewFishing.STARTS_MINIGAME))) {
            FishingHookLogic.getStoredRewards(hook).ifPresent(rewards -> rewards.addAll(items));
            if (FishingHookLogic.startStardewMinigame(player)) {
                cir.cancel();
            }
        } else {
            FishingHookLogic.modifyRewards(items, 0.0, 0);
            player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)SFSoundEvents.PULL_ITEM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

