/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common.networking;

import com.bonker.stardewfishing.client.StardewFishingClient;
import com.bonker.stardewfishing.server.data.MinigameModifiers;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record S2CSyncModifiersPacket(Map<Item, MinigameModifiers> data) {
    public static S2CSyncModifiersPacket fromBytes(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        HashMap<Item, MinigameModifiers> data = new HashMap<Item, MinigameModifiers>(size);
        for (int i = 0; i < size; ++i) {
            Item item = (Item)buf.readRegistryId();
            MinigameModifiers modifiers = MinigameModifiers.read(buf);
            data.put(item, modifiers);
        }
        return new S2CSyncModifiersPacket(data);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.data.size());
        for (Map.Entry<Item, MinigameModifiers> entry : this.data.entrySet()) {
            buf.writeRegistryId(ForgeRegistries.ITEMS, (Object)entry.getKey());
            entry.getValue().write(buf);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            StardewFishingClient.modifiersSupplier = () -> this.data;
        });
    }
}

