/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common.networking;

import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.proxy.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkEvent;

public record C2SCompleteMinigamePacket(boolean success, double accuracy, boolean gotChest) {
    public static C2SCompleteMinigamePacket decode(FriendlyByteBuf buf) {
        boolean success;
        return new C2SCompleteMinigamePacket(success, (success = buf.readBoolean()) ? buf.readDouble() : -1.0, buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.success);
        if (this.success) {
            buf.writeDouble(this.accuracy);
        }
        buf.writeBoolean(this.gotChest);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer player = contextSupplier.get().getSender();
        if (player == null) {
            return;
        }
        FishingHook hook = player.f_36083_;
        if (hook == null || FishingHookLogic.getStoredRewards(hook).isEmpty()) {
            StardewFishing.LOGGER.warn("{} tried to complete a fishing minigame that doesn't exist", (Object)player.m_6302_());
            return;
        }
        contextSupplier.get().enqueueWork(() -> {
            InteractionHand hand = ItemUtils.getRodHand((Player)player);
            if (hand == null) {
                FishingHookLogic.endMinigame(player, false, 0.0, this.gotChest, 0, null);
                StardewFishing.LOGGER.warn("{} tried to complete a fishing minigame without a fishing rod", (Object)player.m_6302_());
            } else {
                ItemStack fishingRod = player.m_21120_(hand);
                ItemUtils.damageAttachedBobber(fishingRod, player);
                int[] qualityBoost = new int[]{0};
                hook.getCapability(FishingHookLogic.CapProvider.CAP).ifPresent(cap -> {
                    qualityBoost[0] = cap.event.getQualityBoost();
                });
                FishingHookLogic.endMinigame(player, this.success, this.accuracy, this.gotChest, qualityBoost[0], fishingRod);
                ItemStack rodCache = fishingRod.m_41777_();
                fishingRod.m_41622_(1, (LivingEntity)player, p -> {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)rodCache, (InteractionHand)hand);
                    p.m_21190_(hand);
                });
            }
        });
    }
}

