/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.common;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.RodTooltipHandler;
import com.bonker.stardewfishing.common.FishingHookLogic;
import com.bonker.stardewfishing.common.init.SFItems;
import com.bonker.stardewfishing.common.networking.S2CSyncModifiersPacket;
import com.bonker.stardewfishing.common.networking.SFNetworking;
import com.bonker.stardewfishing.proxy.ClientProxy;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.bonker.stardewfishing.server.SFCommands;
import com.bonker.stardewfishing.server.data.FishBehaviorReloadListener;
import com.bonker.stardewfishing.server.data.MinigameModifiersReloadListener;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class CommonEvents {

    @Mod.EventBusSubscriber(modid="stardew_fishing", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            SFNetworking.register();
        }
    }

    @Mod.EventBusSubscriber(modid="stardew_fishing")
    public static class ForgeBus {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onFishCaught(ItemFishedEvent event) {
            event.getDrops().forEach(stack -> {
                if (ItemUtils.isLegendaryFish(stack)) {
                    ItemUtils.recordLegendaryCatch(stack, event.getEntity());
                }
            });
        }

        @SubscribeEvent
        public static void onRegisterCommands(RegisterCommandsEvent event) {
            SFCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        @SubscribeEvent
        public static void onItemStackedOnOther(ItemStackedOnOtherEvent event) {
            if (!SFConfig.isInventoryEquippingEnabled()) {
                return;
            }
            if (event.getClickAction() != ClickAction.SECONDARY) {
                return;
            }
            ItemStack slotItem = event.getSlot().m_7993_();
            if (!ItemUtils.isFishingRod(slotItem)) {
                return;
            }
            ItemStack carried = event.getStackedOnItem();
            ItemStack currentBobber = ItemUtils.getBobber(slotItem);
            if (ItemUtils.isBobber(carried)) {
                ItemUtils.setBobber(slotItem, carried.m_41777_());
                event.getCarriedSlotAccess().m_142104_(currentBobber.m_41777_());
                event.setCanceled(true);
                if (event.getPlayer().m_9236_().f_46443_ && FMLEnvironment.dist.isClient()) {
                    RodTooltipHandler.addShake(event.getSlot(), true);
                }
            } else if (!currentBobber.m_41619_() && carried.m_41619_()) {
                ItemUtils.setBobber(slotItem, ItemStack.f_41583_);
                event.getCarriedSlotAccess().m_142104_(currentBobber.m_41777_());
                event.setCanceled(true);
                if (event.getPlayer().m_9236_().f_46443_ && FMLEnvironment.dist.isClient()) {
                    RodTooltipHandler.addShake(event.getSlot(), false);
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onTooltipHighPriority(ItemTooltipEvent event) {
            if (ItemUtils.isLegendaryFish(event.getItemStack())) {
                event.getToolTip().add(1, SFItems.LEGENDARY_FISH_TOOLTIP.m_6881_().m_130940_(ChatFormatting.BOLD));
                ItemUtils.addCatchTooltip(event.getItemStack(), event.getToolTip());
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onTooltipLowPriority(ItemTooltipEvent event) {
            if (ItemUtils.isFishingRod(event.getItemStack()) && !StardewFishing.TIDE_INSTALLED) {
                ItemStack bobber = ItemUtils.getBobber(event.getItemStack());
                if (bobber.m_41619_()) {
                    event.getToolTip().add(Component.m_237115_((String)("tooltip.stardew_fishing." + (SFConfig.isInventoryEquippingEnabled() ? "no_bobber" : "no_bobber_attach_disabled"))).m_130948_(StardewFishing.LIGHT_COLOR));
                } else {
                    event.getToolTip().add(Component.m_237110_((String)"tooltip.stardew_fishing.bobber", (Object[])new Object[]{bobber.m_41611_().m_6881_().m_130948_(StardewFishing.LIGHT_COLOR)}).m_130948_(StardewFishing.DARK_COLOR));
                }
            }
            StardewFishing.getModifiers(event.getItemStack()).ifPresent(modifiers -> {
                if (!((Component)event.getToolTip().get(event.getToolTip().size() - 1)).getString().isEmpty()) {
                    event.getToolTip().add(Component.m_237119_());
                }
                if (ClientProxy.isShiftDown()) {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.stardew_fishing.rod_modifier").m_130948_(StardewFishing.LIGHT_COLOR));
                    modifiers.appendTooltip(event.getToolTip());
                } else {
                    event.getToolTip().add(Component.m_237115_((String)"tooltip.stardew_fishing.rod_modifier_shift").m_130948_(StardewFishing.LIGHT_COLOR));
                }
            });
        }

        @SubscribeEvent
        public static void onItemDestroyed(PlayerDestroyItemEvent event) {
            ItemStack bobber;
            if (ItemUtils.isFishingRod(event.getOriginal()) && !(bobber = ItemUtils.getBobber(event.getOriginal())).m_41619_()) {
                event.getEntity().m_19983_(bobber);
            }
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof FishingHook) {
                FishingHookLogic.attachCap(event);
            }
        }

        @SubscribeEvent
        public static void onAddReloadListeners(AddReloadListenerEvent event) {
            event.addListener((PreparableReloadListener)FishBehaviorReloadListener.create());
            event.addListener((PreparableReloadListener)MinigameModifiersReloadListener.getOrCreate());
        }

        @SubscribeEvent
        public static void onPlayerJoin(OnDatapackSyncEvent event) {
            for (ServerPlayer player : event.getPlayers()) {
                SFNetworking.sendToPlayer(player, new S2CSyncModifiersPacket(MinigameModifiersReloadListener.getOrCreate().getData()));
            }
        }
    }
}

