/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.DimensionTextureManager;
import com.bonker.stardewfishing.client.FishingMinigame;
import com.bonker.stardewfishing.client.StardewFishingClient;
import com.bonker.stardewfishing.client.util.Animation;
import com.bonker.stardewfishing.client.util.RenderUtil;
import com.bonker.stardewfishing.client.util.Shake;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.common.networking.C2SCompleteMinigamePacket;
import com.bonker.stardewfishing.common.networking.S2CStartMinigamePacket;
import com.bonker.stardewfishing.common.networking.SFNetworking;
import com.bonker.stardewfishing.proxy.ItemUtils;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FishingScreen
extends Screen {
    private static final Component TITLE = Component.m_237113_((String)"Fishing Minigame");
    private static final ResourceLocation CHEST_TEXTURE = StardewFishing.resource("textures/gui/chest.png");
    private static final ResourceLocation GOLDEN_CHEST_TEXTURE = StardewFishing.resource("textures/gui/golden_chest.png");
    private static final int GUI_WIDTH = 38;
    private static final int GUI_HEIGHT = 152;
    private static final int HIT_WIDTH = 73;
    private static final int HIT_HEIGHT = 29;
    private static final int PERFECT_WIDTH = 41;
    private static final int PERFECT_HEIGHT = 12;
    private static final float ALPHA_PER_TICK = 0.1f;
    private static final float HANDLE_ROT_FAST = 1.0471976f;
    private static final float HANDLE_ROT_SLOW = -0.44879895f;
    private static final int REEL_FAST_LENGTH = 30;
    private static final int REEL_SLOW_LENGTH = 20;
    private static final int CREAK_LENGTH = 6;
    private final FishingMinigame minigame;
    private final ItemStack fish;
    private int leftPos;
    private int topPos;
    private Status status = Status.HIT_TEXT;
    private double accuracy = -1.0;
    private boolean inputDown = false;
    private int animationTimer = 0;
    private boolean gotChest = false;
    private boolean goldenChest = false;
    private final Animation textSize = new Animation(0.0f);
    private final Animation progressBar;
    private final Animation bobberPos = new Animation(0.0f);
    private final Animation bobberAlpha = new Animation(1.0f);
    private final Animation fishPos = new Animation(0.0f);
    private final Animation handleRot = new Animation(0.0f);
    private final Animation chestProgress = new Animation(0.0f);
    private final Animation chestAppear = new Animation(0.0f);
    private final Shake shake = new Shake(0.75f, 1);
    private final Shake chestShake = new Shake(0.75f, 1);
    public int reelSoundTimer = -1;
    private int creakSoundTimer = 0;
    private float partialTick = 0.0f;

    public FishingScreen(S2CStartMinigamePacket packet) {
        super(TITLE);
        this.minigame = new FishingMinigame(this, packet, (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_), packet.lineStrength(), packet.barSize());
        this.fish = packet.fish();
        this.progressBar = new Animation(this.minigame.getProgress());
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_96541_ == null) {
            return;
        }
        this.partialTick = this.f_96541_.m_91296_();
        PoseStack poseStack = pGuiGraphics.m_280168_();
        ResourceLocation texture = DimensionTextureManager.getOrCreate().getMinigameTexture(this.f_96541_.f_91073_);
        if (this.status == Status.HIT_TEXT) {
            float scale = this.textSize.getInterpolated(this.partialTick) * 1.5f;
            float x = ((float)this.f_96543_ - 73.0f * scale) / 2.0f;
            float y = ((float)this.f_96544_ - 29.0f * scale) / 3.0f;
            poseStack.m_85836_();
            poseStack.m_85841_(scale, scale, 1.0f);
            RenderUtil.blitF(pGuiGraphics, texture, x * (1.0f / scale), y * (1.0f / scale), 71, 0, 73, 29);
            poseStack.m_85849_();
        } else if (this.status == Status.CHEST_OPENING) {
            this.m_280273_(pGuiGraphics);
            int frame = Math.min(30 - this.animationTimer, 19) / 2;
            pGuiGraphics.m_280163_(this.goldenChest ? GOLDEN_CHEST_TEXTURE : CHEST_TEXTURE, this.leftPos + 19 - 64, this.topPos, 0.0f, (float)(frame * 128), 128, 128, 128, 1280);
        } else {
            this.m_280273_(pGuiGraphics);
            RenderUtil.drawWithShake(poseStack, this.shake, this.partialTick, this.status == Status.SUCCESS || this.status == Status.FAILURE, () -> {
                float scale;
                RenderUtil.drawWithBlend(() -> {
                    pGuiGraphics.m_280218_(texture, this.leftPos, this.topPos, 0, 0, 38, 152);
                    RenderUtil.drawWithAlpha(this.bobberAlpha.getInterpolated(this.partialTick), () -> {
                        int size = this.minigame.getBarSize();
                        float bobberY = (float)(4 - size) + (142.0f - this.bobberPos.getInterpolated(this.partialTick));
                        bobberY = (float)((int)(bobberY * 10.0f)) / 10.0f;
                        RenderUtil.blitF(pGuiGraphics, texture, this.leftPos + 18, (float)this.topPos + bobberY, 38, 0, 9, 2);
                        RenderUtil.blitRepeatingF(pGuiGraphics, texture, this.leftPos + 18, (float)this.topPos + bobberY + 2.0f, 38, 2, 9, size - 4, 9, 1);
                        RenderUtil.blitF(pGuiGraphics, texture, this.leftPos + 18, (float)this.topPos + bobberY + (float)size - 2.0f, 38, 3, 9, 2);
                    });
                });
                if (this.minigame.hasSonarBobber()) {
                    pGuiGraphics.m_280218_(texture, this.leftPos + 38, this.topPos + 2, 185, 0, 26, 25);
                    pGuiGraphics.m_280480_(this.fish, this.leftPos + 45, this.topPos + 8);
                    if (pMouseX >= this.leftPos + 38 && pMouseY >= this.topPos + 5 && pMouseX <= this.leftPos + 64 && pMouseY <= this.topPos + 27) {
                        pGuiGraphics.renderTooltip(this.f_96547_, AbstractContainerScreen.m_280152_((Minecraft)this.f_96541_, (ItemStack)this.fish).subList(0, 1), this.fish.m_150921_(), this.fish, pMouseX, pMouseY);
                    }
                }
                RenderUtil.drawWithShake(poseStack, this.shake, this.partialTick, this.minigame.isBobberOnFish() && this.status == Status.MINIGAME, () -> {
                    float pos = this.fishPos.getInterpolated(this.partialTick);
                    int offset = 0;
                    if (ItemUtils.isLegendaryFish(this.fish)) {
                        offset += 15;
                        if (SFConfig.isLegendaryFlashingEnabled() && (int)(pos / 8.0f) % 2 == 1) {
                            offset += 15;
                        }
                    }
                    float fishY = -12.0f + (142.0f - pos);
                    RenderUtil.blitF(pGuiGraphics, texture, this.leftPos + 14, (float)this.topPos + fishY, 55, offset, 16, 15);
                });
                if ((this.minigame.isChestVisible() || this.animationTimer < 0) && (scale = this.chestAppear.getInterpolated(this.partialTick)) != 0.0f) {
                    poseStack.m_85836_();
                    poseStack.m_85841_(scale, scale, 1.0f);
                    float chestX = ((float)(this.leftPos + 24) - 8.0f * scale) / scale;
                    float chestY = ((float)(this.topPos + 4 - 13) + (150.0f - 8.0f * scale - (float)this.minigame.getChestPos())) / scale;
                    RenderUtil.drawWithShake(poseStack, this.chestShake, this.partialTick, this.minigame.isBobberOnChest() && this.status == Status.MINIGAME, () -> RenderUtil.blitF(pGuiGraphics, texture, chestX, chestY, 211, this.minigame.isGoldenChest() ? 13 : 0, 13, 13));
                    RenderUtil.fillF(pGuiGraphics, chestX + 1.0f, chestY + 12.0f, chestX + 12.0f, chestY + 14.0f, 0.0f, 0x55000000);
                    float progress = this.chestProgress.getInterpolated(this.partialTick);
                    int color = Mth.m_14169_((float)(progress / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
                    RenderUtil.fillF(pGuiGraphics, chestX + 1.0f, chestY + 12.0f, chestX + 1.0f + progress * 11.0f, chestY + 14.0f, 200.0f, color);
                    poseStack.m_85849_();
                }
                float progress = this.progressBar.getInterpolated(this.partialTick);
                int color = Mth.m_14169_((float)(progress / 3.0f), (float)1.0f, (float)1.0f) | 0xFF000000;
                RenderUtil.fillF(pGuiGraphics, this.leftPos + 33, this.topPos + 148, this.leftPos + 37, (float)(this.topPos + 148) - progress * 145.0f, 0.0f, color);
                RenderUtil.drawRotatedAround(poseStack, this.handleRot.getInterpolated(this.partialTick), (float)this.leftPos + 6.5f, (float)this.topPos + 130.5f, () -> pGuiGraphics.m_280218_(texture, this.leftPos + 5, this.topPos + 129, 47, 0, 8, 3));
                if (this.status == Status.SUCCESS && this.accuracy == 1.0) {
                    float scale2 = this.textSize.getInterpolated(this.partialTick);
                    float x = (float)(this.leftPos + 2) + (41.0f - 41.0f * scale2) / 2.0f;
                    float y = (float)this.topPos - 12.0f * scale2;
                    poseStack.m_85836_();
                    poseStack.m_85841_(scale2, scale2, 1.0f);
                    RenderUtil.blitF(pGuiGraphics, texture, x / scale2, y / scale2, 144, 0, 41, 12);
                    poseStack.m_85849_();
                }
            });
        }
        if (this.status != Status.HIT_TEXT) {
            Objects.requireNonNull(this.f_96547_);
            pGuiGraphics.m_280488_(this.f_96547_, StardewFishing.MOD_NAME, 2, this.f_96544_ - 2 - 9, 1768515967);
        }
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 38) / 2;
        this.topPos = (this.f_96544_ - 152) / 2;
        if (this.f_96541_ != null && SFConfig.isolateAudioCues()) {
            for (SoundSource category : SoundSource.values()) {
                if (category == SoundSource.MASTER) continue;
                this.f_96541_.m_91106_().m_120386_(null, category);
            }
        }
    }

    public void m_86600_() {
        this.shake.tick();
        if (this.minigame.isChestVisible()) {
            this.chestShake.tick();
        }
        switch (this.status) {
            case HIT_TEXT: {
                if (this.animationTimer >= 20) break;
                if (++this.animationTimer == 20) {
                    this.status = Status.MINIGAME;
                    this.animationTimer = Integer.MAX_VALUE;
                    break;
                }
                if (this.animationTimer <= 5) {
                    this.textSize.addValue(0.2f);
                    break;
                }
                if (this.animationTimer <= 15) {
                    this.textSize.addValue(-0.013f);
                    break;
                }
                this.textSize.addValue(-0.16f);
                break;
            }
            case MINIGAME: {
                this.minigame.tick(this.inputDown);
                boolean onFish = this.minigame.isBobberOnFish();
                this.progressBar.setValue(this.minigame.getProgress());
                this.bobberPos.setValue(this.minigame.getBobberPos());
                this.bobberAlpha.addValue(onFish || this.minigame.isBobberOnChest() ? 0.1f : -0.1f, 0.4f, 1.0f);
                this.fishPos.setValue(this.minigame.getFishPos());
                this.handleRot.addValue(onFish ? 1.0471976f : -0.44879895f);
                if (this.status != Status.MINIGAME) break;
                if (this.minigame.isChestVisible()) {
                    if (this.animationTimer == Integer.MAX_VALUE) {
                        this.animationTimer = 5;
                    }
                    if (this.animationTimer > 0) {
                        --this.animationTimer;
                        this.chestAppear.addValue(0.2f);
                        if (this.animationTimer == 0) {
                            this.animationTimer = Integer.MIN_VALUE;
                            this.chestAppear.setValue(1.0f);
                        }
                    }
                    this.chestProgress.setValue(this.minigame.getChestProgress());
                } else {
                    if (this.animationTimer == Integer.MIN_VALUE) {
                        this.animationTimer = -5;
                        this.playSound((SoundEvent)SFSoundEvents.CHEST_GET.get());
                    }
                    if (this.animationTimer < 0) {
                        ++this.animationTimer;
                        this.chestAppear.addValue(-0.2f);
                        if (this.animationTimer == 0) {
                            this.chestAppear.setValue(0.0f);
                        }
                    }
                }
                if (this.reelSoundTimer == -1 || --this.reelSoundTimer == 0) {
                    int n = this.reelSoundTimer = onFish ? 30 : 20;
                    if (!SFConfig.isolateAudioCues()) {
                        this.playSound(onFish ? (SoundEvent)SFSoundEvents.REEL_FAST.get() : (SoundEvent)SFSoundEvents.REEL_SLOW.get());
                    }
                }
                if (this.creakSoundTimer > 0) {
                    --this.creakSoundTimer;
                }
                if (!this.inputDown || this.creakSoundTimer != 0) break;
                this.creakSoundTimer = 6;
                if (SFConfig.isolateAudioCues()) break;
                this.playSound((SoundEvent)SFSoundEvents.REEL_CREAK.get());
                break;
            }
            case SUCCESS: 
            case FAILURE: {
                if (--this.animationTimer == 0) {
                    if (this.gotChest) {
                        this.status = Status.CHEST_OPENING;
                        this.animationTimer = 30;
                        this.playSound(this.goldenChest ? (SoundEvent)SFSoundEvents.OPEN_CHEST_GOLDEN.get() : (SoundEvent)SFSoundEvents.OPEN_CHEST.get());
                        break;
                    }
                    this.m_7379_();
                    break;
                }
                if (this.animationTimer >= 15) {
                    this.textSize.addValue(0.2f);
                    break;
                }
                if (this.animationTimer >= 5) {
                    this.textSize.addValue(-0.013f);
                    break;
                }
                this.textSize.addValue(-0.16f);
                break;
            }
            case CHEST_OPENING: {
                if (--this.animationTimer != 0) break;
                this.m_7379_();
            }
        }
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84868_() == InputConstants.Type.MOUSE && pButton == StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84873_() && this.status == Status.MINIGAME) {
            this.setInputDown(true);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84868_() == InputConstants.Type.MOUSE && pButton == StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84873_()) {
            this.setInputDown(false);
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84868_() == InputConstants.Type.KEYSYM && keyCode == StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84873_() && this.status == Status.MINIGAME) {
            this.setInputDown(true);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84868_() == InputConstants.Type.KEYSYM && keyCode == StardewFishingClient.MINIGAME_BUTTON.get().getKey().m_84873_()) {
            this.setInputDown(false);
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public void setInputDown(boolean down) {
        if (down && !this.inputDown && !SFConfig.isolateAudioCues()) {
            this.playSound((SoundEvent)SFSoundEvents.REEL_CREAK.get());
        }
        this.inputDown = down;
    }

    public void m_7379_() {
        super.m_7379_();
        SFNetworking.sendToServer(new C2SCompleteMinigamePacket(this.status == Status.SUCCESS || this.status == Status.CHEST_OPENING, this.accuracy, this.gotChest));
        this.stopReelingSounds();
    }

    public boolean m_6913_() {
        return this.status == Status.MINIGAME;
    }

    public boolean m_7043_() {
        return this.status != Status.HIT_TEXT;
    }

    public void setResult(boolean success, double accuracy, boolean gotChest, boolean goldenChest) {
        this.status = success ? Status.SUCCESS : Status.FAILURE;
        this.accuracy = accuracy;
        this.gotChest = gotChest;
        this.goldenChest = goldenChest;
        this.animationTimer = 20;
        this.textSize.reset(0.0f);
        this.progressBar.freeze(this.partialTick);
        this.bobberPos.freeze(this.partialTick);
        this.bobberAlpha.freeze(this.partialTick);
        this.fishPos.freeze(this.partialTick);
        this.handleRot.freeze(this.partialTick);
        this.chestProgress.freeze(this.partialTick);
        this.chestAppear.freeze(this.partialTick);
        this.playSound(success ? (SoundEvent)SFSoundEvents.COMPLETE.get() : (SoundEvent)SFSoundEvents.FISH_ESCAPE.get());
        this.stopReelingSounds();
        this.reelSoundTimer = -2;
        this.shake.setValues(2.0f, 1);
    }

    public void playSound(SoundEvent soundEvent) {
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)soundEvent, (float)1.0f));
    }

    public void stopReelingSounds() {
        this.reelSoundTimer = 1;
        if (this.f_96541_ == null) {
            return;
        }
        this.f_96541_.m_91106_().m_120386_(SFSoundEvents.REEL_FAST.getId(), null);
        this.f_96541_.m_91106_().m_120386_(SFSoundEvents.REEL_SLOW.getId(), null);
    }

    public static enum Status {
        HIT_TEXT,
        MINIGAME,
        SUCCESS,
        FAILURE,
        CHEST_OPENING;

    }
}

