/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.client.FishingScreen;
import com.bonker.stardewfishing.common.init.SFItems;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.common.networking.S2CStartMinigamePacket;
import com.bonker.stardewfishing.proxy.ItemUtils;
import java.util.Random;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FishingMinigame {
    private static final int POINTS_TO_FINISH = 120;
    private static final int TREASURE_CHEST_TIME = 30;
    private static final float UP_ACCELERATION = 0.7f;
    private static final float GRAVITY = -0.7f;
    private static final int MAX_FISH_HEIGHT = 127;
    private final Random random = new Random();
    private final FishingScreen screen;
    private final S2CStartMinigamePacket packet;
    private final float lineStrength;
    private final int barSize;
    private final int maxBobberHeight;
    private boolean hasSonarBobber = false;
    private boolean hasTreasureBobber = false;
    private double bobberPos = 0.0;
    private double bobberVelocity = 0.0;
    private double fishPos = 0.0;
    private double fishVelocity = 0.0;
    private int fishTarget = -1;
    private boolean fishIsIdle = false;
    private int fishIdleTicks = 0;
    private boolean bobberOnFish = true;
    private boolean bobberOnChest = false;
    private float points = 24.0f;
    private int successTicks = 0;
    private int totalTicks = 0;
    private final boolean goldenChest;
    private final int chestPos;
    private int chestAppearTime;
    private float chestTimer = 0.0f;
    private boolean chestVisible = false;

    public FishingMinigame(FishingScreen screen, S2CStartMinigamePacket packet, Player player, float lineStrength, int barSize) {
        this.screen = screen;
        this.packet = packet;
        this.goldenChest = packet.goldenChest();
        this.chestPos = packet.treasureChest() ? (int)(5.0f + 125.0f * this.random.nextFloat()) : 0;
        this.chestAppearTime = packet.treasureChest() ? (int)(20.0f + 40.0f * this.random.nextFloat()) : -1;
        this.lineStrength = lineStrength;
        this.barSize = barSize;
        this.maxBobberHeight = 142 - barSize;
        InteractionHand hand = ItemUtils.getRodHand(player);
        if (hand != null) {
            ItemStack bobber = ItemUtils.getBobber(player.m_21120_(hand));
            if (bobber.m_150930_((Item)SFItems.SONAR_BOBBER.get())) {
                this.hasSonarBobber = true;
            } else if (bobber.m_150930_((Item)SFItems.TREASURE_BOBBER.get())) {
                this.hasTreasureBobber = true;
            }
        }
    }

    public void tick(boolean mouseDown) {
        if (mouseDown) {
            if (this.bobberVelocity < 0.0) {
                this.bobberVelocity *= 0.9;
            }
            this.bobberVelocity += (double)0.7f;
        } else if (this.bobberPos > 0.0) {
            this.bobberVelocity += (double)-0.7f;
        }
        this.bobberPos += this.bobberVelocity;
        if (this.bobberPos > (double)this.maxBobberHeight) {
            this.bobberVelocity = 0.0;
            this.bobberPos = this.maxBobberHeight;
        } else if (this.bobberPos <= 0.0) {
            this.bobberPos = 0.0;
            this.bobberVelocity = this.bobberVelocity < (double)-1.4f ? (this.bobberVelocity *= -0.4) : 0.0;
        }
        if (this.fishTarget == -1 || this.shouldMoveNow(this.fishIdleTicks, this.random)) {
            this.fishTarget = this.pickNextTargetPos((int)this.fishPos, this.random);
            this.fishIsIdle = false;
            this.fishIdleTicks = 0;
        }
        if (this.fishIsIdle) {
            ++this.fishIdleTicks;
            if (Math.abs(this.fishVelocity) > 0.0) {
                boolean up = this.fishVelocity > 0.0;
                this.fishVelocity -= (double)(up ? this.packet.upAcceleration() : this.packet.downAcceleration()) * Math.signum(this.fishVelocity);
                if (this.fishVelocity == 0.0 || up && this.fishVelocity < 0.0 || !up && this.fishVelocity > 0.0) {
                    this.fishVelocity = 0.0;
                }
            }
        } else {
            double distanceLeft = (double)this.fishTarget - this.fishPos;
            double acceleration = (double)(distanceLeft > 0.0 ? this.packet.upAcceleration() : this.packet.downAcceleration()) * Math.signum(distanceLeft);
            this.fishVelocity = Mth.m_14008_((double)(this.fishVelocity + acceleration), (double)(-this.packet.topSpeed()), (double)this.packet.topSpeed());
        }
        this.fishPos += this.fishVelocity;
        if (Math.abs((double)this.fishTarget - this.fishPos) < this.fishVelocity) {
            this.fishIsIdle = true;
        } else if (this.fishPos > 127.0) {
            this.fishVelocity = 0.0;
            this.fishPos = 127.0;
            this.fishIsIdle = true;
        } else if (this.fishPos < 0.0) {
            this.fishVelocity = 0.0;
            this.fishPos = 0.0;
            this.fishIsIdle = true;
        }
        if (this.chestAppearTime > 0 && --this.chestAppearTime == 0) {
            this.chestVisible = true;
        }
        int min = Mth.m_14107_((double)this.bobberPos) - 2;
        int max = Mth.m_14165_((double)this.bobberPos) + this.barSize - 12;
        boolean wasOnFish = this.bobberOnFish;
        boolean wasOnChest = this.bobberOnChest;
        this.bobberOnFish = this.fishPos >= (double)min && this.fishPos <= (double)max;
        this.bobberOnChest = this.chestVisible && this.chestPos >= min && this.chestPos <= max;
        ++this.totalTicks;
        if (this.bobberOnFish || this.hasTreasureBobber && this.bobberOnChest) {
            ++this.successTicks;
        }
        if (wasOnFish != this.bobberOnFish) {
            this.screen.stopReelingSounds();
            this.screen.playSound(SFSoundEvents.getDwop(this.bobberOnFish));
        }
        if (wasOnChest != this.bobberOnChest) {
            this.screen.playSound(SFSoundEvents.getDwop(this.bobberOnChest));
        }
        if (!this.bobberOnChest && this.chestTimer > 0.0f && this.chestTimer < 30.0f) {
            this.chestTimer -= 0.25f;
        }
        if (this.bobberOnChest && this.chestTimer < 30.0f) {
            float f;
            this.chestTimer += 1.0f;
            if (f >= 30.0f) {
                this.chestVisible = false;
            }
        }
        if (this.bobberOnFish) {
            this.points += 1.0f;
            if (this.points >= 120.0f) {
                this.screen.setResult(true, (double)this.successTicks / (double)this.totalTicks, this.gotChest(), this.isGoldenChest());
            }
        } else if (!this.hasTreasureBobber || !this.bobberOnChest) {
            this.points -= 1.0f - this.lineStrength;
            if (this.points <= 0.0f) {
                this.screen.setResult(false, 0.0, false, false);
            }
        }
    }

    private boolean shouldMoveNow(int idleTicks, Random random) {
        if (this.packet.idleTime() == 0) {
            return true;
        }
        if (this.packet.idleTime() == 1) {
            return idleTicks == 1;
        }
        int variation = idleTicks / 2;
        float chancePerTick = 1.0f / (float)variation;
        if (idleTicks >= this.packet.idleTime() - variation) {
            return random.nextFloat() <= chancePerTick;
        }
        return false;
    }

    private int pickNextTargetPos(int oldPos, Random random) {
        int shortestDistance = Math.max(10, this.packet.avgDistance() - this.packet.moveVariation());
        int longestDistance = Math.min(127, this.packet.avgDistance() + this.packet.moveVariation());
        int downLowerLimit = oldPos - shortestDistance;
        int upLowerLimit = oldPos + shortestDistance;
        boolean canGoDown = downLowerLimit >= 0;
        boolean canGoUp = upLowerLimit <= 127;
        boolean goingUp = canGoUp && canGoDown ? random.nextBoolean() : canGoUp;
        int distance = random.nextInt(shortestDistance, longestDistance + 1);
        return Mth.m_14045_((int)(oldPos + distance * (goingUp ? 1 : -1)), (int)0, (int)127);
    }

    public float getBobberPos() {
        return (float)this.bobberPos;
    }

    public float getFishPos() {
        return (float)this.fishPos;
    }

    public boolean isBobberOnFish() {
        return this.bobberOnFish;
    }

    public boolean isBobberOnChest() {
        return this.bobberOnChest;
    }

    public float getProgress() {
        return this.points / 120.0f;
    }

    public int getChestPos() {
        return this.chestPos;
    }

    public boolean isChestVisible() {
        return this.chestVisible;
    }

    public boolean isGoldenChest() {
        return this.goldenChest;
    }

    public float getChestProgress() {
        return this.chestTimer / 30.0f;
    }

    public boolean gotChest() {
        return this.chestTimer >= 30.0f;
    }

    public boolean hasSonarBobber() {
        return this.hasSonarBobber;
    }

    public int getBarSize() {
        return this.barSize;
    }
}

