/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.StardewFishing;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;

public class DimensionTextureManager
extends SimplePreparableReloadListener<Set<ResourceLocation>> {
    @Nullable
    private static DimensionTextureManager INSTANCE;
    private final Map<ResourceLocation, ResourceLocation> dimensionTextureMap = new HashMap<ResourceLocation, ResourceLocation>();

    public static DimensionTextureManager getOrCreate() {
        if (INSTANCE == null) {
            INSTANCE = new DimensionTextureManager();
        }
        return INSTANCE;
    }

    protected Set<ResourceLocation> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return pResourceManager.m_214159_("textures/gui/minigame_backgrounds", loc -> loc.m_135827_().equals("stardew_fishing") && loc.m_135815_().endsWith(".png")).keySet();
    }

    protected void apply(Set<ResourceLocation> candidates, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dimensionTextureMap.clear();
        for (ResourceLocation texture : candidates) {
            String[] parts = texture.m_135815_().substring(0, texture.m_135815_().length() - 4).split("/");
            if (parts.length != 5) {
                StardewFishing.LOGGER.warn("Invalid location for a minigame dimension texture: {}", (Object)texture);
                continue;
            }
            ResourceLocation dimensionId = ResourceLocation.m_214293_((String)parts[3], (String)parts[4]);
            if (dimensionId == null) {
                StardewFishing.LOGGER.warn("Minigame dimension texture path does not represent a valid dimension id: {}", (Object)texture);
                continue;
            }
            StardewFishing.LOGGER.info("Found minigame texture for dimension: {}", (Object)dimensionId);
            this.dimensionTextureMap.put(dimensionId, texture);
        }
    }

    public ResourceLocation getMinigameTexture(@Nullable ClientLevel level) {
        ResourceLocation dimensionId;
        if (level != null && this.dimensionTextureMap.containsKey(dimensionId = level.m_220362_().m_135782_())) {
            return this.dimensionTextureMap.get(dimensionId);
        }
        return this.dimensionTextureMap.get(BuiltinDimensionTypes.f_223538_.m_135782_());
    }
}

