/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.client.StardewFishingClient;
import com.bonker.stardewfishing.common.init.SFBlockEntities;
import com.bonker.stardewfishing.common.init.SFBlocks;
import com.bonker.stardewfishing.common.init.SFItems;
import com.bonker.stardewfishing.common.init.SFLootModifiers;
import com.bonker.stardewfishing.common.init.SFLootPoolEntryTypes;
import com.bonker.stardewfishing.common.init.SFParticles;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import com.bonker.stardewfishing.proxy.MinigameModifiersSupplier;
import com.bonker.stardewfishing.server.data.MinigameModifiers;
import com.bonker.stardewfishing.server.data.MinigameModifiersReloadListener;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod(value="stardew_fishing")
public class StardewFishing {
    public static final String MODID = "stardew_fishing";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean QUALITY_FOOD_INSTALLED = ModList.get().isLoaded("quality_food");
    public static final boolean AQUACULTURE_INSTALLED = ModList.get().isLoaded("aquaculture");
    public static final boolean TIDE_INSTALLED = ModList.get().isLoaded("tide");
    public static final TagKey<Item> STARTS_MINIGAME = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)StardewFishing.resource("starts_minigame"));
    public static final TagKey<Item> MODIFIABLE_RODS = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)StardewFishing.resource("modifiable_rods"));
    public static final TagKey<Item> BOBBERS = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)StardewFishing.resource("bobbers"));
    public static final TagKey<Item> LEGENDARY_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)StardewFishing.resource("legendary_fish"));
    public static final TagKey<Item> IN_FISH_DISPLAY = TagKey.m_203882_((ResourceKey)ForgeRegistries.ITEMS.getRegistryKey(), (ResourceLocation)StardewFishing.resource("in_fish_display"));
    public static final TagKey<Biome> HAS_NORMAL_OCEAN_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)StardewFishing.resource("has_normal_ocean_fish"));
    public static final TagKey<Biome> HAS_WARM_OCEAN_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)StardewFishing.resource("has_warm_ocean_fish"));
    public static final TagKey<Biome> HAS_RIVER_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)StardewFishing.resource("has_river_fish"));
    public static final TagKey<Biome> HAS_ARID_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)StardewFishing.resource("has_arid_fish"));
    public static final TagKey<Biome> HAS_JUNGLE_FISH = TagKey.m_203882_((ResourceKey)ForgeRegistries.BIOMES.getRegistryKey(), (ResourceLocation)StardewFishing.resource("has_jungle_fish"));
    public static final ResourceLocation TREASURE_CHEST_LOOT = StardewFishing.resource("treasure_chest");
    public static final ResourceLocation TREASURE_CHEST_NETHER_LOOT = StardewFishing.resource("treasure_chest_nether");
    public static String MOD_NAME;
    public static final Style GREEN;
    public static final Style RED;
    public static final Style LIGHTER_COLOR;
    public static final Style LIGHT_COLOR;
    public static final Style DARK_COLOR;
    public static final Style LEGENDARY;

    public StardewFishing() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus bus = context.getModEventBus();
        IModInfo info = context.getContainer().getModInfo();
        MOD_NAME = info.getDisplayName() + " " + info.getVersion();
        SFItems.ITEMS.register(bus);
        SFBlocks.BLOCKS.register(bus);
        SFItems.CREATIVE_MODE_TABS.register(bus);
        SFParticles.PARTICLE_TYPES.register(bus);
        SFSoundEvents.SOUND_EVENTS.register(bus);
        SFLootModifiers.LOOT_MODIFIERS.register(bus);
        SFBlockEntities.BLOCK_ENTITY_TYPES.register(bus);
        SFLootPoolEntryTypes.LOOT_POOL_ENTRY_TYPES.register(bus);
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SFConfig.SERVER_SPEC);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SFConfig.CLIENT_SPEC);
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static Optional<MinigameModifiers> getModifiers(ItemStack stack) {
        Map<Item, MinigameModifiers> data;
        MinigameModifiersSupplier modifiersSupplier = FMLEnvironment.dist == Dist.DEDICATED_SERVER ? MinigameModifiersReloadListener.getOrCreate() : StardewFishingClient.modifiersSupplier;
        if (modifiersSupplier != null && (data = modifiersSupplier.getData()).containsKey(stack.m_41720_())) {
            return Optional.of(data.get(stack.m_41720_()));
        }
        return Optional.empty();
    }

    static {
        GREEN = Style.f_131099_.m_178520_(11849369);
        RED = Style.f_131099_.m_178520_(13270380);
        LIGHTER_COLOR = Style.f_131099_.m_178520_(13410413);
        LIGHT_COLOR = Style.f_131099_.m_178520_(11500094);
        DARK_COLOR = Style.f_131099_.m_178520_(8280108);
        LEGENDARY = Style.f_131099_.m_178520_(0xFFFFBE);
    }
}

