/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.loot;

import dev.architectury.event.events.common.LootEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bandit.many_bows.config.BowLootConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLootModifiers {
    private static final BowLootConfig CONFIG = BowLootConfig.loadConfig();

    public static void registerLootModifiers() {
        Set<ResourceLocation> easyTables = ModLootModifiers.parseLootTables(ModLootModifiers.CONFIG.easyLootTables);
        Set<ResourceLocation> mediumTables = ModLootModifiers.parseLootTables(ModLootModifiers.CONFIG.mediumLootTables);
        Set<ResourceLocation> hardTables = ModLootModifiers.parseLootTables(ModLootModifiers.CONFIG.hardLootTables);
        Set<ResourceLocation> endgameTables = ModLootModifiers.parseLootTables(ModLootModifiers.CONFIG.endgameLootTables);
        LootEvent.MODIFY_LOOT_TABLE.register((lootDataManager, id, context, builtin) -> {
            if (!builtin) {
                return;
            }
            if (Boolean.TRUE.equals(ModLootModifiers.CONFIG.easyLootEnabled) && easyTables.contains(id)) {
                context.addPool(ModLootModifiers.createConfigDrivenPool(ModLootModifiers.CONFIG.easyLootDropChance.floatValue(), ModLootModifiers.CONFIG.easyLootItems));
            }
            if (Boolean.TRUE.equals(ModLootModifiers.CONFIG.mediumLootEnabled) && mediumTables.contains(id)) {
                context.addPool(ModLootModifiers.createConfigDrivenPool(ModLootModifiers.CONFIG.mediumLootDropChance.floatValue(), ModLootModifiers.CONFIG.mediumLootItems));
            }
            if (Boolean.TRUE.equals(ModLootModifiers.CONFIG.hardLootEnabled) && hardTables.contains(id)) {
                context.addPool(ModLootModifiers.createConfigDrivenPool(ModLootModifiers.CONFIG.hardLootDropChance.floatValue(), ModLootModifiers.CONFIG.hardLootItems));
            }
            if (Boolean.TRUE.equals(ModLootModifiers.CONFIG.endgameLootEnabled) && endgameTables.contains(id)) {
                context.addPool(ModLootModifiers.createConfigDrivenPool(ModLootModifiers.CONFIG.endgameLootDropChance.floatValue(), ModLootModifiers.CONFIG.endgameLootItems));
            }
        });
    }

    private static Set<ResourceLocation> parseLootTables(List<String> ids) {
        HashSet<ResourceLocation> out = new HashSet<ResourceLocation>();
        if (ids == null) {
            return out;
        }
        for (String s : ids) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)s);
            if (rl != null) {
                out.add(rl);
                continue;
            }
            System.err.println("[too_many_bows] Invalid loot table id in config: " + s);
        }
        return out;
    }

    private static LootPool.Builder createConfigDrivenPool(float chance, List<String> itemIds) {
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance));
        if (itemIds == null || itemIds.isEmpty()) {
            return pool;
        }
        for (String id : itemIds) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)id);
            if (rl == null) {
                System.err.println("[too_many_bows] Invalid item id in loot config: " + id);
                continue;
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
            if (item == Items.f_41852_) {
                System.err.println("[too_many_bows] Unknown item in loot config (not registered): " + id);
                continue;
            }
            pool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
        }
        return pool;
    }
}

