/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.entity;

import java.util.List;
import net.bandit.many_bows.registry.EntityRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class ShulkerBlastProjectile
extends AbstractArrow {
    private static final double HOMING_RANGE = 20.0;
    private static final float SPEED = 0.7f;
    private static final float DAMAGE = 6.0f;
    private static final int LEVITATION_DURATION = 40;
    private static final int MAX_LIFETIME = 100;
    private int lifetime = 0;

    public ShulkerBlastProjectile(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public ShulkerBlastProjectile(Level level, LivingEntity shooter) {
        super((EntityType)EntityRegistry.SHULKER_BLAST_PROJECTILE.get(), shooter, level);
        this.m_20242_(true);
    }

    public void m_8119_() {
        double dz;
        double dy;
        double dx;
        double distance;
        LivingEntity target;
        super.m_8119_();
        ++this.lifetime;
        if (this.lifetime > 100) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && (target = this.findNearestTarget()) != null && (distance = Math.sqrt((dx = target.m_20185_() - this.m_20185_()) * dx + (dy = target.m_20186_() + (double)(target.m_20192_() / 2.0f) - this.m_20186_()) * dy + (dz = target.m_20189_() - this.m_20189_()) * dz)) > 0.0) {
            double homingFactor = 0.2;
            this.m_20334_(this.m_20184_().f_82479_ * (1.0 - homingFactor) + dx / distance * (double)0.7f * homingFactor, this.m_20184_().f_82480_ * (1.0 - homingFactor) + dy / distance * (double)0.7f * homingFactor, this.m_20184_().f_82481_ * (1.0 - homingFactor) + dz / distance * (double)0.7f * homingFactor);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    private LivingEntity findNearestTarget() {
        AABB searchBox = this.m_20191_().m_82400_(20.0);
        List entities = this.m_9236_().m_6443_(LivingEntity.class, searchBox, entity -> {
            TamableAnimal tamable;
            return entity != this.m_19749_() && entity.m_6084_() && !(entity instanceof ArmorStand) && (!(entity instanceof TamableAnimal) || !(tamable = (TamableAnimal)entity).m_21824_());
        });
        return entities.stream().min((e1, e2) -> Double.compare(e1.m_20270_((Entity)this), e2.m_20270_((Entity)this))).orElse(null);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity;
        super.m_5790_(result);
        if (!this.m_9236_().m_5776_() && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            DamageSource damageSource = this.m_9236_().m_269111_().m_269418_((AbstractArrow)this, this.m_19749_());
            target.m_6469_(damageSource, 6.0f);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 40, 1));
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12410_, SoundSource.PLAYERS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                double xOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double yOffset = this.f_19796_.m_188500_() * 0.3;
                double zOffset = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_() + xOffset, this.m_20186_() + yOffset, this.m_20189_() + zOffset, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)Items.f_42412_);
    }
}

