/*
 * Decompiled with CFR 0.152.
 */
package net.bandit.many_bows.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class BowLootConfig {
    public static final String MOD_ID = "too_many_bows";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/too_many_bows.json");
    public Boolean easyLootEnabled = true;
    public Float easyLootDropChance = Float.valueOf(0.5f);
    public Boolean mediumLootEnabled = true;
    public Float mediumLootDropChance = Float.valueOf(0.4f);
    public Boolean hardLootEnabled = true;
    public Float hardLootDropChance = Float.valueOf(0.3f);
    public Boolean endgameLootEnabled = true;
    public Float endgameLootDropChance = Float.valueOf(0.2f);
    public Integer emeraldSageXpAmount = 10;
    public List<String> emeraldSageCrimsonNexusBlacklist = List.of("minecraft:armor_stand", "minecraft:wandering_trader", "dummmmmmy:target_dummy");
    public List<String> easyLootTables = List.of("minecraft:chests/simple_dungeon", "minecraft:chests/abandoned_mineshaft");
    public List<String> mediumLootTables = List.of("minecraft:chests/jungle_temple", "minecraft:chests/pillager_outpost", "minecraft:chests/abandoned_mineshaft", "minecraft:chests/simple_dungeon");
    public List<String> hardLootTables = List.of("minecraft:chests/stronghold_corridor", "minecraft:chests/nether_bridge", "minecraft:chests/bastion_treasure");
    public List<String> endgameLootTables = List.of("minecraft:chests/end_city_treasure", "minecraft:chests/nether_bridge", "minecraft:chests/bastion_treasure");
    public List<String> easyLootItems = List.of("too_many_bows:ancient_sage_bow", "too_many_bows:aethers_call", "too_many_bows:burnt_relic", "too_many_bows:power_crystal", "too_many_bows:emerald_sage_bow", "too_many_bows:torchbearer", "too_many_bows:demons_grasp");
    public List<String> mediumLootItems = List.of("too_many_bows:cyroheart_bow", "too_many_bows:power_crystal", "too_many_bows:torchbearer", "too_many_bows:emerald_sage_bow", "too_many_bows:demons_grasp");
    public List<String> hardLootItems = List.of("too_many_bows:sentinels_wrath", "too_many_bows:cursed_stone", "too_many_bows:solar_bow", "too_many_bows:arc_heavens", "too_many_bows:scatter_bow", "too_many_bows:vitality_weaver", "too_many_bows:spectral_whisper", "too_many_bows:webstring");
    public List<String> endgameLootItems = List.of("too_many_bows:flame_bow", "too_many_bows:dark_bow", "too_many_bows:arcane_bow", "too_many_bows:dragons_breath", "too_many_bows:wind_bow", "too_many_bows:cyroheart_bow", "too_many_bows:shulker_blast", "too_many_bows:astral_bound", "too_many_bows:auroras_grace");

    public static BowLootConfig loadConfig() {
        BowLootConfig config;
        if (!CONFIG_FILE.exists()) {
            BowLootConfig config2 = new BowLootConfig();
            config2.saveConfig();
            return config2;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            config = (BowLootConfig)GSON.fromJson((Reader)reader, BowLootConfig.class);
            if (config == null) {
                config = new BowLootConfig();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            config = new BowLootConfig();
        }
        boolean changed = config.validateAndFillDefaults();
        if (changed) {
            config.saveConfig();
        }
        return config;
    }

    public void saveConfig() {
        File parent = CONFIG_FILE.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean validateAndFillDefaults() {
        boolean changed = false;
        BowLootConfig defaults = new BowLootConfig();
        if (this.easyLootEnabled == null) {
            this.easyLootEnabled = defaults.easyLootEnabled;
            changed = true;
        }
        if (this.easyLootDropChance == null) {
            this.easyLootDropChance = defaults.easyLootDropChance;
            changed = true;
        }
        if (this.mediumLootEnabled == null) {
            this.mediumLootEnabled = defaults.mediumLootEnabled;
            changed = true;
        }
        if (this.mediumLootDropChance == null) {
            this.mediumLootDropChance = defaults.mediumLootDropChance;
            changed = true;
        }
        if (this.hardLootEnabled == null) {
            this.hardLootEnabled = defaults.hardLootEnabled;
            changed = true;
        }
        if (this.hardLootDropChance == null) {
            this.hardLootDropChance = defaults.hardLootDropChance;
            changed = true;
        }
        if (this.endgameLootEnabled == null) {
            this.endgameLootEnabled = defaults.endgameLootEnabled;
            changed = true;
        }
        if (this.endgameLootDropChance == null) {
            this.endgameLootDropChance = defaults.endgameLootDropChance;
            changed = true;
        }
        if (this.emeraldSageXpAmount == null) {
            this.emeraldSageXpAmount = defaults.emeraldSageXpAmount;
            changed = true;
        }
        if (this.emeraldSageCrimsonNexusBlacklist == null) {
            this.emeraldSageCrimsonNexusBlacklist = new ArrayList<String>(defaults.emeraldSageCrimsonNexusBlacklist);
            changed = true;
        }
        if (this.easyLootTables == null) {
            this.easyLootTables = new ArrayList<String>(defaults.easyLootTables);
            changed = true;
        }
        if (this.mediumLootTables == null) {
            this.mediumLootTables = new ArrayList<String>(defaults.mediumLootTables);
            changed = true;
        }
        if (this.hardLootTables == null) {
            this.hardLootTables = new ArrayList<String>(defaults.hardLootTables);
            changed = true;
        }
        if (this.endgameLootTables == null) {
            this.endgameLootTables = new ArrayList<String>(defaults.endgameLootTables);
            changed = true;
        }
        if (this.easyLootItems == null) {
            this.easyLootItems = new ArrayList<String>(defaults.easyLootItems);
            changed = true;
        }
        if (this.mediumLootItems == null) {
            this.mediumLootItems = new ArrayList<String>(defaults.mediumLootItems);
            changed = true;
        }
        if (this.hardLootItems == null) {
            this.hardLootItems = new ArrayList<String>(defaults.hardLootItems);
            changed = true;
        }
        if (this.endgameLootItems == null) {
            this.endgameLootItems = new ArrayList<String>(defaults.endgameLootItems);
            changed = true;
        }
        changed |= this.clampChanceField("easy");
        changed |= this.clampChanceField("medium");
        changed |= this.clampChanceField("hard");
        changed |= this.clampChanceField("endgame");
        if (this.emeraldSageXpAmount != null && this.emeraldSageXpAmount < 0) {
            this.emeraldSageXpAmount = 0;
            changed = true;
        }
        return changed;
    }

    private boolean clampChanceField(String tier) {
        Float v;
        switch (tier) {
            case "easy": {
                Float f = this.easyLootDropChance;
                break;
            }
            case "medium": {
                Float f = this.mediumLootDropChance;
                break;
            }
            case "hard": {
                Float f = this.hardLootDropChance;
                break;
            }
            case "endgame": {
                Float f = this.endgameLootDropChance;
                break;
            }
            default: {
                Float f = v = null;
            }
        }
        if (v == null) {
            return false;
        }
        float clamped = Math.max(0.0f, Math.min(1.0f, v.floatValue()));
        if (clamped != v.floatValue()) {
            switch (tier) {
                case "easy": {
                    this.easyLootDropChance = Float.valueOf(clamped);
                    break;
                }
                case "medium": {
                    this.mediumLootDropChance = Float.valueOf(clamped);
                    break;
                }
                case "hard": {
                    this.hardLootDropChance = Float.valueOf(clamped);
                    break;
                }
                case "endgame": {
                    this.endgameLootDropChance = Float.valueOf(clamped);
                }
            }
            return true;
        }
        return false;
    }
}

