/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.items;

import com.legacy.dungeons_plus.client.renderers.CustomHandRenderer;
import com.legacy.dungeons_plus.entities.SoulFireballEntity;
import com.legacy.dungeons_plus.items.CustomHandRendererSupplier;
import com.legacy.dungeons_plus.items.DPItem;
import com.legacy.dungeons_plus.registry.DPDamageSources;
import com.legacy.dungeons_plus.registry.DPSoundEvents;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SoulCannonItem
extends Item
implements DPItem,
Vanishable,
CustomHandRendererSupplier {
    public static final String SHOOT_KEY = "shoot";
    public static final int MAX_USE_TIME = 20;

    public SoulCannonItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        int useTime = this.m_8105_(stack) - timeLeft;
        if (useTime >= 20 && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack heldStack = player.m_21120_(player.m_7655_());
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean hasFlame = enchants.containsKey(Enchantments.f_44990_);
            boolean isMultishot = enchants.containsKey(Enchantments.f_44959_);
            int knockback = enchants.getOrDefault(Enchantments.f_44980_, 0);
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)DPSoundEvents.SOUL_CANNON_SHOOT.get(), SoundSource.PLAYERS, 0.4f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f + 1.5f);
            level.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12404_, SoundSource.PLAYERS, 10.0f, (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f + 1.5f);
            if (!level.f_46443_) {
                float[] angles;
                heldStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                float multiAngle = 15.0f;
                int multishotLevel = enchants.getOrDefault(Enchantments.f_44959_, 0);
                if (multishotLevel < 1) {
                    angles = new float[]{0.0f};
                } else {
                    angles = new float[multishotLevel * 2 + 1];
                    float separation = multiAngle / (float)multishotLevel;
                    for (int i = 0; i < angles.length; ++i) {
                        angles[i] = separation * (float)i - multiAngle;
                    }
                }
                for (float r : angles) {
                    Vec3 upVec = entity.m_20289_(1.0f);
                    Quaternionf quat = new Quaternionf().setAngleAxis((double)(r * ((float)Math.PI / 180)), upVec.f_82479_, upVec.f_82480_, upVec.f_82481_);
                    Vec3 viewVec = entity.m_20252_(1.0f);
                    Vector3f shootAngle = viewVec.m_252839_().rotate((Quaternionfc)quat);
                    SoulFireballEntity fireball = new SoulFireballEntity(level, (LivingEntity)player, 0.0, 0.0, 0.0, 2.5f);
                    fireball.setKnockback(knockback);
                    fireball.setHasFlame(hasFlame);
                    fireball.setIsMultishot(isMultishot);
                    fireball.m_6686_(shootAngle.x(), shootAngle.y(), shootAngle.z(), 2.5f, 1.0f);
                    fireball.m_146884_(player.m_146892_());
                    level.m_7967_((Entity)fireball);
                }
            }
            player.m_36399_(hasFlame || isMultishot ? 2.5f : 2.0f);
            if (player.m_36324_().m_38702_() <= 6) {
                player.m_6469_(DPDamageSources.instance.consumeSoul(), 2.0f);
            }
            player.m_36335_().m_41524_((Item)this, player.m_7500_() ? 10 : 40);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return super.canApplyAtEnchantingTable(stack, enchant) || enchant == Enchantments.f_44990_ || enchant == Enchantments.f_44959_ || enchant == Enchantments.f_44980_;
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairIngredient) {
        return repairIngredient.m_150930_(Items.f_42586_) || super.m_6832_(stack, repairIngredient);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag showAdvanced) {
        super.m_7373_(stack, level, tooltip, showAdvanced);
        tooltip.addAll(this.getDescription(stack, new String[]{SHOOT_KEY}));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CustomHandRenderer getHandRenderer() {
        return CustomHandRenderer.SOUL_BLASTER;
    }
}

