/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.entities;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.data.DPTags;
import com.legacy.dungeons_plus.data.advancement.ThrownItemHitBlockTrigger;
import com.legacy.dungeons_plus.registry.DPDamageSources;
import com.legacy.dungeons_plus.registry.DPEntityTypes;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPSoundEvents;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class WarpedAxeEntity
extends AbstractArrow {
    private static final EntityDataAccessor<ItemStack> ID_AXE_STACK = SynchedEntityData.m_135353_(WarpedAxeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> ID_ROTATION = SynchedEntityData.m_135353_(WarpedAxeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> ID_IN_BLOCK = SynchedEntityData.m_135353_(WarpedAxeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ID_TELEPORT_PLAYER = SynchedEntityData.m_135353_(WarpedAxeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean dealtDamage;
    public int clientSideReturnAxeTickCount;
    public int spinRot = 0;
    public int oldSpinRot = 0;
    @Nullable
    private Vec3 oldPos = null;
    private static final String DEALT_DAMAGE_KEY = "dealt_damage";
    private static final String STACK_KEY = "stack";
    private static final String SHOULD_TELEPORT = "can_teleport";

    public WarpedAxeEntity(EntityType<? extends WarpedAxeEntity> type, Level level) {
        super(type, level);
    }

    public WarpedAxeEntity(Level level, LivingEntity owner, ItemStack stack) {
        super((EntityType)DPEntityTypes.WARPED_AXE.get(), owner, level);
        this.f_19804_.m_135381_(ID_AXE_STACK, (Object)stack.m_41777_());
        this.f_19804_.m_135381_(ID_ROTATION, (Object)Float.valueOf(owner.m_6080_()));
    }

    public WarpedAxeEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends WarpedAxeEntity>)((EntityType)DPEntityTypes.WARPED_AXE.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_AXE_STACK, (Object)((Item)DPItems.WARPED_AXE.get()).m_7968_());
        this.f_19804_.m_135372_(ID_ROTATION, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_IN_BLOCK, (Object)false);
        this.f_19804_.m_135372_(ID_TELEPORT_PLAYER, (Object)true);
    }

    public ItemStack getAxe() {
        return (ItemStack)this.f_19804_.m_135370_(ID_AXE_STACK);
    }

    public void setAxe(ItemStack stack) {
        this.f_19804_.m_135381_(ID_AXE_STACK, (Object)stack.m_41777_());
    }

    public float getRenderRotation() {
        return ((Float)this.f_19804_.m_135370_(ID_ROTATION)).floatValue();
    }

    public boolean isInBlock() {
        return (Boolean)this.f_19804_.m_135370_(ID_IN_BLOCK);
    }

    public boolean shouldTeleportOwner() {
        return (Boolean)this.f_19804_.m_135370_(ID_TELEPORT_PLAYER);
    }

    public void setTeleportsOwner(boolean shouldTeleportOwner) {
        this.f_19804_.m_135381_(ID_TELEPORT_PLAYER, (Object)shouldTeleportOwner);
    }

    public void m_8119_() {
        boolean voidReturn;
        if (this.f_36703_ != this.isInBlock()) {
            this.f_19804_.m_135381_(ID_IN_BLOCK, (Object)this.f_36703_);
        }
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        this.oldSpinRot = this.spinRot;
        if (!this.f_36703_) {
            this.spinRot += 45;
            if (this.oldPos != null && this.shouldTeleportOwner()) {
                Vec3 pos = this.m_20182_();
                double distScale = 1.0;
                Vec3 motionVec = this.m_20182_().m_82546_(this.oldPos).m_82541_().m_82490_(3.0);
                int amount = this.f_19796_.m_188503_(3) + 2;
                for (int i = 0; i < amount; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123789_, pos.f_82479_ + (this.f_19796_.m_188500_() - 0.5) * distScale, pos.f_82480_ + (this.f_19796_.m_188500_() - 0.5) * distScale, pos.f_82481_ + (this.f_19796_.m_188500_() - 0.5) * distScale, motionVec.f_82479_, motionVec.f_82480_, motionVec.f_82481_);
                }
            }
        }
        this.oldPos = this.m_20182_();
        Entity owner = this.m_19749_();
        int loyaltyLevel = EnchantmentHelper.m_44928_((ItemStack)this.getAxe());
        boolean bl = voidReturn = this.m_20182_().f_82480_ < (double)this.m_9236_().m_6042_().f_156647_() && (Boolean)DPConfig.COMMON.loyaltyReturnsFromVoid.get() != false;
        if (loyaltyLevel > 0 && (this.dealtDamage || this.m_36797_() || voidReturn) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double returnSpeed = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(returnSpeed)));
                if (this.clientSideReturnAxeTickCount == 0) {
                    this.m_5496_((SoundEvent)DPSoundEvents.WARPED_AXE_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnAxeTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.getAxe().m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec1, Vec3 vec2) {
        return this.dealtDamage ? null : super.m_6351_(vec1, vec2);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        BlockState state = this.m_9236_().m_8055_(hitResult.m_82425_());
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ThrownItemHitBlockTrigger.TRIGGER.trigger(player, this.getAxe(), state);
        }
        super.m_8060_(hitResult);
        if (state.m_204336_(DPTags.Blocks.WARPED_AXE_TELEPORTS_TO)) {
            this.teleportOwner(this.m_19749_());
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        float damage;
        Entity hitEntity = hitResult.m_82443_();
        ItemStack stack = this.getAxe();
        Item item = stack.m_41720_();
        if (item == DPItems.WARPED_AXE.get()) {
            damage = 8.0f;
        } else if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            damage = sword.m_43299_();
        } else if (item instanceof DiggerItem) {
            DiggerItem digger = (DiggerItem)item;
            damage = digger.m_41008_();
        } else {
            damage = 6.0f;
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.getAxe(), (MobType)livingEntity.m_6336_()) / 2.0f;
        }
        if (!this.shouldTeleportOwner()) {
            damage /= 2.0f;
        }
        Entity owner = this.m_19749_();
        this.dealtDamage = true;
        if (hitEntity.m_6469_(DPDamageSources.instance.thrownItem((Entity)this, owner, stack), damage)) {
            if (hitEntity.m_6095_().m_204039_(DPTags.EntityTypes.WARPED_AXE_IMMUNE)) {
                return;
            }
            this.teleportOwner(owner);
            if (hitEntity instanceof LivingEntity) {
                LivingEntity livingHit = (LivingEntity)hitEntity;
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                int fireAspect = enchantments.getOrDefault(Enchantments.f_44981_, 0);
                if (fireAspect > 0) {
                    livingHit.m_20254_(fireAspect * 4);
                }
                EnchantmentHelper.m_44823_((LivingEntity)livingHit, (Entity)owner);
                if (owner instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)owner;
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingHit);
                }
                this.m_7761_(livingHit);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_((SoundEvent)DPSoundEvents.WARPED_AXE_HIT.get(), 1.0f, 1.0f);
    }

    private void teleportOwner(@Nullable Entity owner) {
        if (owner == null || !this.shouldTeleportOwner()) {
            return;
        }
        Vec3 pos = this.m_20182_();
        owner.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        owner.m_183634_();
        owner.m_6469_(owner.m_9236_().m_269111_().m_268989_(), 5.0f);
        this.m_9236_().m_7605_((Entity)this, (byte)46);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            player.m_36335_().m_41524_(this.getAxe().m_41720_(), 60);
        }
        owner.m_146850_(GameEvent.f_238175_);
        this.m_5496_((SoundEvent)DPSoundEvents.WARPED_AXE_TELEPORT.get(), 1.0f, 1.0f);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)DPSoundEvents.WARPED_AXE_LAND.get();
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.dealtDamage = tag.m_128471_(DEALT_DAMAGE_KEY);
        ItemStack stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(STACK_KEY));
        if (!stack.m_41619_()) {
            this.setAxe(stack);
        }
        this.setTeleportsOwner(tag.m_128471_(SHOULD_TELEPORT));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(DEALT_DAMAGE_KEY, this.dealtDamage);
        ItemStack stack = this.getAxe();
        if (!stack.m_41619_()) {
            tag.m_128365_(STACK_KEY, (Tag)stack.m_41739_(new CompoundTag()));
        }
        tag.m_128379_(SHOULD_TELEPORT, this.shouldTeleportOwner());
    }

    public void m_6901_() {
        int loyalty = EnchantmentHelper.m_44928_((ItemStack)this.getAxe());
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || loyalty <= 0) {
            super.m_6901_();
        }
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    protected float m_6882_() {
        return 0.9f;
    }

    public boolean m_6072_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

