/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.registry.DPBlocks;
import com.legacy.dungeons_plus.registry.DPItems;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DPModelProv {
    private static final String GENERATED = "item/generated";
    private static final String HANDHELD = "item/handheld";

    protected static List<Block> getAllBlocks() {
        return BuiltInRegistries.f_256975_.m_123024_().filter(block -> BuiltInRegistries.f_256975_.m_7981_(block).m_135827_().equals("dungeons_plus")).toList();
    }

    protected static List<Item> getAllItems(Function<Item, Boolean> condition) {
        return BuiltInRegistries.f_257033_.m_123024_().filter(item -> BuiltInRegistries.f_257033_.m_7981_(item).m_135827_().equals("dungeons_plus") && (Boolean)condition.apply((Item)item) != false).toList();
    }

    protected static List<Item> getAllItems() {
        return DPModelProv.getAllItems(i -> true);
    }

    public static class States
    extends BlockStateProvider {
        public States(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "dungeons_plus", existingFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)DPBlocks.GRANITE_IRON_ORE.get());
            this.simpleBlock((Block)DPBlocks.GRANITE_GOLD_ORE.get());
            for (Block block : this.registeredBlocks.keySet()) {
                boolean contained;
                boolean bl = contained = !this.itemModels().generatedModels.containsKey(this.modLoc("block/" + this.name(block))) && !this.itemModels().generatedModels.containsKey(this.modLoc("item/" + this.name(block)));
                Item possibleItem = (Item)BuiltInRegistries.f_257033_.m_7745_(this.key(block));
                if (possibleItem == null || possibleItem == Blocks.f_50016_.m_5456_() || !contained) continue;
                try {
                    this.itemModels().withExistingParent(this.name(block), this.modLoc("block/" + this.name(block)));
                }
                catch (Exception exception) {}
            }
        }

        public void pillarBlock(Block block, Block topTextureParent) {
            this.pillarBlock(block, topTextureParent, null);
        }

        public void pillarBlock(Block block, Block textureParent, @Nullable String renderType) {
            ResourceLocation baseName = this.blockTexture(textureParent != null ? textureParent : block);
            if (block instanceof RotatedPillarBlock) {
                RotatedPillarBlock pillar = (RotatedPillarBlock)block;
                ResourceLocation side = this.extend(baseName, "_side");
                this.axisBlockWithRenderType(pillar, side, textureParent != null ? side : this.extend(baseName, "_top"), renderType != null ? renderType : "solid");
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non pillar block: {}", new Object[]{baseName});
            }
        }

        public void door(Block block, Item item, @Nullable String renderType) {
            if (block instanceof DoorBlock) {
                DoorBlock door = (DoorBlock)block;
                this.doorBlockWithRenderType(door, this.extend(this.blockTexture((Block)door), "_lower"), this.extend(this.blockTexture((Block)door), "_upper"), renderType != null ? renderType : "cutout");
                this.itemModels().basicItem(item);
            }
        }

        public void trapDoor(Block block, boolean orientable) {
            if (block instanceof TrapDoorBlock) {
                TrapDoorBlock door = (TrapDoorBlock)block;
                this.trapdoorBlockWithRenderType(door, this.blockTexture((Block)door), orientable, "cutout");
                this.itemModels().withExistingParent(this.name((Block)door), this.extend(this.blockTexture((Block)door), "_bottom"));
            }
        }

        public void trapDoor(Block block, boolean orientable, @Nullable String renderType) {
            if (block instanceof TrapDoorBlock) {
                TrapDoorBlock door = (TrapDoorBlock)block;
                this.trapdoorBlockWithRenderType(door, this.blockTexture((Block)door), orientable, renderType != null ? renderType : "cutout");
                this.itemModels().withExistingParent(this.name((Block)door), this.extend(this.blockTexture((Block)door), "_bottom"));
            }
        }

        public void vine(Block b) {
            BlockModelBuilder vineModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(b), "block/vine")).texture("vine", this.blockTexture(b))).texture("particle", "#vine")).renderType("cutout");
            MultiPartBlockStateBuilder vineStateBuilder = this.getMultipartBuilder(b);
            for (Direction dir : VineBlock.f_57838_.keySet().stream().sorted().toList()) {
                int y = dir.m_122424_().m_122416_() * 90;
                ((MultiPartBlockStateBuilder.PartBuilder)vineStateBuilder.part().modelFile((ModelFile)vineModel).uvLock(true).rotationX(dir == Direction.UP ? 270 : 0).rotationY(y % 360).addModel()).condition((Property)VineBlock.f_57838_.get(dir), (Comparable[])new Boolean[]{true}).end();
            }
            this.item((ItemLike)b.m_5456_(), true);
        }

        public void cross(Block block) {
            this.cross(block, this.name(block), true);
        }

        public void cross(Block block, String name, boolean item) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcBlockFolder("cross"))).texture("cross", this.blockFolder(name))).renderType("cutout"));
            if (item) {
                this.item((ItemLike)block.m_5456_(), true);
            }
        }

        public void pottedCross(Block block, ResourceLocation texture) {
            if (texture == null) {
                texture = this.blockTexture(block);
                texture = texture.m_247449_(texture.m_135815_().replace("potted_", ""));
            }
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcBlockFolder("flower_pot_cross"))).texture("plant", texture)).renderType("cutout");
            this.simpleBlock(block, (ModelFile)model);
        }

        public void tallCross(Block block) {
            BlockModelBuilder top = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block).concat("_top"), this.mcBlockFolder("cross"))).renderType("cutout");
            BlockModelBuilder bottom = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block).concat("_bottom"), this.mcBlockFolder("cross"))).renderType("cutout");
            ResourceLocation topTex = this.extend(this.blockTexture(block), "_top");
            ResourceLocation bottomTex = this.extend(this.blockTexture(block), "_bottom");
            top = (BlockModelBuilder)top.texture("cross", topTex);
            bottom = (BlockModelBuilder)bottom.texture("cross", bottomTex);
            BlockModelBuilder topFinal = top;
            BlockModelBuilder bottomFinal = bottom;
            this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)(state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? topFinal : bottomFinal)).build(), new Property[0]);
            this.item((ItemLike)block.m_5456_(), this.extend(BuiltInRegistries.f_257033_.m_7981_((Object)block.m_5456_()), "_top"), true);
        }

        public void stairs(Block block, Block parent) {
            if (block instanceof StairBlock) {
                StairBlock stairs = (StairBlock)block;
                ResourceLocation tex = this.blockTexture(parent);
                this.stairsBlock(stairs, tex);
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non stairs block: {}", new Object[]{this.key(block)});
            }
        }

        public void slab(Block block, Block parent) {
            if (block instanceof SlabBlock) {
                SlabBlock slab = (SlabBlock)block;
                super.slabBlock(slab, this.blockTexture(parent), this.blockTexture(parent));
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non slab block: {}", new Object[]{this.key(block)});
            }
        }

        public void fences(Block block, Block gate, Block parent) {
            FenceBlock fence;
            ResourceLocation tex = this.blockTexture(parent);
            if (block instanceof FenceBlock) {
                fence = (FenceBlock)block;
                this.fenceBlock(fence, tex);
                this.itemModels().fenceInventory(this.name((Block)fence), tex);
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non fence block: {}", new Object[]{this.key(block)});
            }
            if (gate instanceof FenceGateBlock) {
                fence = (FenceGateBlock)gate;
                this.fenceGateBlock((FenceGateBlock)fence, tex);
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non gate block: {}", new Object[]{this.key(gate)});
            }
        }

        public void wall(Block block, Block parent) {
            this.wall(block, this.blockTexture(parent), null);
        }

        public void wall(Block block, ResourceLocation tex, @Nullable String renderType) {
            if (block instanceof WallBlock) {
                WallBlock wall = (WallBlock)block;
                if (renderType != null) {
                    this.wallBlockWithRenderType(wall, tex, renderType);
                } else {
                    this.wallBlock(wall, tex);
                }
                this.itemModels().wallInventory(this.name((Block)wall), tex);
            } else {
                DungeonsPlus.LOGGER.error((Object)"Tried to datagen model for non wall block: {}", new Object[]{this.key(block)});
            }
        }

        public void button(ButtonBlock block, ResourceLocation texture, @Nullable String renderType) {
            this.buttonBlock(block, texture);
            this.itemModels().buttonInventory(this.name((Block)block), texture);
        }

        public void sign(StandingSignBlock signBlock, WallSignBlock wallSignBlock, ResourceLocation texture) {
            this.signBlock(signBlock, wallSignBlock, texture);
            this.item((ItemLike)signBlock.m_5456_(), false);
        }

        public void craftingTable(Block block, Block bottom) {
            ResourceLocation texture = this.blockTexture(block);
            this.simpleBlock(block, (ModelFile)this.models().orientableWithBottom(this.name(block), this.extend(texture, "_side"), this.extend(texture, "_front"), this.blockTexture(bottom), this.extend(texture, "_top")));
        }

        public void ladder(Block block) {
            ResourceLocation texture = this.blockTexture(block);
            BlockModelBuilder vineModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), "block/ladder")).texture("texture", texture)).texture("particle", "#texture")).renderType("cutout");
            MultiPartBlockStateBuilder ladderStateBuilder = this.getMultipartBuilder(block);
            for (Direction dir : (Direction[])Arrays.stream(Direction.values()).filter(d -> d.m_122434_() != Direction.Axis.Y).toArray(Direction[]::new)) {
                int y = dir.m_122424_().m_122416_() * 90;
                ((MultiPartBlockStateBuilder.PartBuilder)ladderStateBuilder.part().modelFile((ModelFile)vineModel).uvLock(true).rotationX(0).rotationY(y % 360).addModel()).condition((Property)LadderBlock.f_54337_, (Comparable[])new Direction[]{dir}).end();
            }
            this.item((ItemLike)block.m_5456_(), true);
        }

        public void pressurePlate(PressurePlateBlock block, ResourceLocation texture, @Nullable String renderType) {
            BlockModelBuilder pressurePlate = (BlockModelBuilder)this.models().pressurePlate(this.name((Block)block), texture);
            BlockModelBuilder pressurePlateDown = (BlockModelBuilder)this.models().pressurePlateDown(this.name((Block)block) + "_down", texture);
            if (renderType != null) {
                pressurePlate.renderType(renderType);
                pressurePlateDown.renderType(renderType);
            }
            this.pressurePlate(block, (ModelFile)pressurePlate, (ModelFile)pressurePlateDown);
        }

        public void pressurePlate(PressurePlateBlock block, ModelFile pressurePlate, ModelFile pressurePlateDown) {
            this.getVariantBuilder((Block)block).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlateDown)}).partialState().with((Property)PressurePlateBlock.f_55249_, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel(pressurePlate)});
        }

        public void blockEntity(Block block, Block parent) {
            this.simpleBlock(block, (ModelFile)this.models().withExistingParent(this.name(block), this.key(parent)));
            this.itemModels().withExistingParent(this.name(block), this.key(Blocks.f_50087_));
        }

        public void leaves(LeavesBlock block, String renderType) {
            ResourceLocation texture = this.blockTexture((Block)block);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name((Block)block), this.mcBlockFolder("leaves"))).texture("all", texture);
            if (renderType != null) {
                model.renderType(renderType);
            }
            this.simpleBlock((Block)block, (ModelFile)model);
        }

        public void carpet(Block block, Block parent) {
            ResourceLocation texture = this.blockTexture(parent);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcBlockFolder("carpet"))).texture("wool", texture)).texture("particle", texture);
            this.simpleBlock(block, (ModelFile)model);
        }

        public BlockModelBuilder cube(Block block) {
            return this.cube(block, this.blockTexture(block));
        }

        public BlockModelBuilder cube(Block block, ResourceLocation tex) {
            return (BlockModelBuilder)this.models().cubeAll(this.name(block), tex);
        }

        public void bookshelf(Block block, Block plank) {
            ResourceLocation plankTex = this.blockTexture(plank);
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(this.name(block), this.blockTexture(block), plankTex, plankTex);
            this.simpleBlock(block, (ModelFile)model);
        }

        public void simpleBlock(Block block) {
            this.simpleBlock(block, null);
        }

        public void simpleBlock(Block block, @Nullable String renderType) {
            ModelFile model = this.cubeAll(block);
            if (renderType != null && model instanceof BlockModelBuilder) {
                BlockModelBuilder b = (BlockModelBuilder)model;
                b.renderType(renderType);
            }
            super.simpleBlock(block, model);
        }

        private ResourceLocation key(Block block) {
            return BuiltInRegistries.f_256975_.m_7981_((Object)block);
        }

        private String name(Block block) {
            return this.key(block).m_135815_();
        }

        private ResourceLocation extend(ResourceLocation rl, String suffix) {
            return new ResourceLocation(rl.m_135827_(), rl.m_135815_() + suffix);
        }

        public ResourceLocation blockFolder(String key) {
            return this.modLoc("block/" + key);
        }

        public ResourceLocation mcBlockFolder(String key) {
            return this.mcLoc("block/" + key);
        }

        public ItemModelBuilder item(ItemLike item, boolean blockFolder) {
            if (item == null || item == Blocks.f_50016_.m_5456_() || item.m_5456_() == null) {
                return null;
            }
            return this.item(item, BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()), blockFolder);
        }

        public ItemModelBuilder item(ItemLike item, ResourceLocation texture, boolean blockFolder) {
            if (item == null || item == Blocks.f_50016_.m_5456_()) {
                return null;
            }
            String dir = blockFolder ? "block" : "item";
            ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(key.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(DPModelProv.GENERATED))).texture("layer0", new ResourceLocation(texture.m_135827_(), dir + "/" + texture.m_135815_()));
        }
    }

    public static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "dungeons_plus", existingFileHelper);
        }

        protected void registerModels() {
            this.handheldItem((Item)DPItems.WARPED_AXE.get());
            this.tintedOverlay((Item)DPItems.FROSTED_COWL.get());
            this.scaledHandheld((Item)DPItems.LEVIATHAN_BLADE.get(), 1.105f, 0.68f, 6.0f);
            this.soulCannon((Item)DPItems.SOUL_CANNON.get());
            DPModelProv.getAllItems(i -> i instanceof SpawnEggItem).forEach(item -> this.withExistingParent(BuiltInRegistries.f_257033_.m_7981_(item).m_135815_(), new ResourceLocation("item/template_spawn_egg")));
        }

        public ItemModelBuilder scaledHandheld(Item item, float thirdPersonScale, float firstPersonScale, float thirdPersonTranslation) {
            ItemModelBuilder model = this.handheldItem(item);
            ModelBuilder.TransformsBuilder transforms = model.transforms();
            transforms.transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 55.0f).translation(0.0f, thirdPersonTranslation, 0.5f).scale(thirdPersonScale);
            transforms.transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -55.0f).translation(0.0f, thirdPersonTranslation, 0.5f).scale(thirdPersonScale);
            transforms.transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, -90.0f, 25.0f).translation(1.13f, 3.2f, 1.13f).scale(firstPersonScale);
            transforms.transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 90.0f, -25.0f).translation(1.13f, 3.2f, 1.13f).scale(firstPersonScale);
            return (ItemModelBuilder)transforms.end();
        }

        public ItemModelBuilder soulCannon(Item item) {
            String tex = "tex";
            String texKey = "#" + tex;
            String particle = "particle";
            String name = this.name(item);
            ResourceLocation invTexture = this.texLoc(name).m_266382_("_inventory");
            ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("forge", "item/default"))).texture(particle, invTexture);
            ItemModelBuilder inventory = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_inventory")).parent((ModelFile)new ModelFile.UncheckedModelFile(DPModelProv.GENERATED))).texture("layer0", invTexture);
            ItemModelBuilder thirdPerson = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_held")).texture(tex, this.texLoc(name))).texture(particle, invTexture)).element().from(5.5f, 0.0f, 5.5f).to(10.5f, 9.0f, 10.5f).face(Direction.NORTH).uvs(0.0f, 5.0f, 5.0f, 14.0f).texture(texKey).end().face(Direction.EAST).uvs(10.0f, 5.0f, 5.0f, 14.0f).texture(texKey).end().face(Direction.SOUTH).uvs(10.0f, 5.0f, 15.0f, 14.0f).texture(texKey).end().face(Direction.WEST).uvs(5.0f, 5.0f, 10.0f, 14.0f).texture(texKey).end().face(Direction.UP).uvs(10.0f, 0.0f, 15.0f, 5.0f).texture(texKey).end().face(Direction.DOWN).uvs(0.0f, 0.0f, 5.0f, 5.0f).texture(texKey).end().end()).transforms().transform(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND).rotation(-90.0f, -180.0f, 0.0f).translation(0.0f, -2.0f, -1.75f).end().transform(ItemDisplayContext.THIRD_PERSON_LEFT_HAND).rotation(-90.0f, -180.0f, 0.0f).translation(0.0f, -2.0f, -1.75f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-69.0f, -171.0f, 14.0f).translation(0.75f, 2.5f, -2.0f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(-69.0f, -171.0f, 14.0f).translation(0.75f, 2.5f, -2.0f).end().transform(ItemDisplayContext.GROUND).rotation(0.0f, 0.0f, -90.0f).translation(2.5f, 0.0f, 0.0f).scale(0.75f, 0.75f, 0.75f).end().transform(ItemDisplayContext.GUI).rotation(-61.0f, -180.0f, 152.0f).translation(2.0f, -1.75f, 0.0f).scale(1.3f, 1.3f, 1.3f).end().transform(ItemDisplayContext.HEAD).rotation(90.0f, 0.0f, -180.0f).translation(0.0f, -3.75f, -8.75f).end().transform(ItemDisplayContext.FIXED).rotation(90.0f, 0.0f, -180.0f).translation(0.0f, 0.0f, -6.0f).end().end();
            String fp = "_first_person";
            ItemModelBuilder firstPerson = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + fp, thirdPerson.getLocation())).texture(tex, this.texLoc(name + fp))).texture(particle, invTexture);
            SeparateTransformsModelBuilder loader = (SeparateTransformsModelBuilder)model.customLoader(SeparateTransformsModelBuilder::begin);
            loader.base((ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(inventory.getLocation(), this.existingFileHelper).parent((ModelFile)inventory)));
            loader.perspective(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(thirdPerson.getLocation(), this.existingFileHelper).parent((ModelFile)thirdPerson)));
            loader.perspective(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(thirdPerson.getLocation(), this.existingFileHelper).parent((ModelFile)thirdPerson)));
            loader.perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(firstPerson.getLocation(), this.existingFileHelper).parent((ModelFile)firstPerson)));
            loader.perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(firstPerson.getLocation(), this.existingFileHelper).parent((ModelFile)firstPerson)));
            loader.perspective(ItemDisplayContext.HEAD, (ModelBuilder)((ItemModelBuilder)new ItemModelBuilder(thirdPerson.getLocation(), this.existingFileHelper).parent((ModelFile)thirdPerson)));
            return model;
        }

        public ItemModelBuilder tintedOverlay(Item item) {
            return this.tintedOverlay(BuiltInRegistries.f_257033_.m_7981_((Object)item));
        }

        public ItemModelBuilder tintedOverlay(ResourceLocation id) {
            ResourceLocation texture = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(id.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(DPModelProv.GENERATED))).texture("layer0", texture)).texture("layer1", texture.m_266382_("_overlay"));
        }

        public ItemModelBuilder handheldItem(Item item) {
            return this.handheldItem(Objects.requireNonNull(BuiltInRegistries.f_257033_.m_7981_((Object)item)));
        }

        public ItemModelBuilder handheldItem(ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(DPModelProv.HANDHELD))).texture("layer0", item.m_246208_("item/"));
        }

        public ItemModelBuilder basicItemInLoc(String name, ResourceLocation item) {
            return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name.replace("block/", "item/"))).parent((ModelFile)new ModelFile.UncheckedModelFile(DPModelProv.GENERATED))).texture("layer0", item);
        }

        public ItemModelBuilder basicItemInLoc(ResourceLocation item) {
            return this.basicItemInLoc(item.toString(), item);
        }

        public ResourceLocation texLoc(String key) {
            return this.modLoc("item/" + key);
        }

        public ResourceLocation mcTexLoc(String key) {
            return this.mcLoc("item/" + key);
        }

        private ResourceLocation key(Item item) {
            return BuiltInRegistries.f_257033_.m_7981_((Object)item);
        }

        private String name(Item item) {
            return this.key(item).m_135815_();
        }
    }
}

