/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.data.providers;

import com.legacy.dungeons_plus.data.providers.DPAdvancementProv;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPSoundEvents;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.data.LanguageProvider;

public class DPLangProvider
extends LanguageProvider {
    private final CompletableFuture<HolderLookup.Provider> lookup;

    public DPLangProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup) {
        super(packOutput, "dungeons_plus", "en_us");
        this.lookup = lookup;
    }

    protected void addTranslations() {
        this.addAll(Registries.f_256747_, Map.of());
        this.addAll(Registries.f_256944_, Map.of());
        this.addAll(Registries.f_256913_, Map.of());
        this.addAll(Registries.f_256939_, Map.of());
        this.add(DPLangProvider.mapName(DPStructures.REANIMATED_RUINS), "Reanimated Ruins Map");
        this.add(DPLangProvider.mapName(DPStructures.LEVIATHAN), "Leviathan Map");
        this.add(DPLangProvider.mapName(DPStructures.SNOWY_TEMPLE), "Snowy Temple Map");
        this.add(DPLangProvider.mapName(DPStructures.WARPED_GARDEN), "Warped Garden Map");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findTower, "Battle Towers?", "Find a Tower");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findReanimatedRuins, "Now this is a Dungeon", "Find the Reanimated Ruins");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findLeviathan, "Ancient Remains", "Find a Leviathan");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findSnowyTemple, "Snowed In", "Find a Snowy Temple");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findWarpedGarden, "Something Unnatural", "Find a Warped Garden");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findEndRuins, "A Ruined End", "Find End Ruins");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.findSoulPrison, "Caged Tears", "Find the Soul Prison");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.killGhast, "Special Delivery", "Kill a ghast with a soul fireball");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.zombieVillagerWeakness, "Hurtful Healing", "Give a zombie villager weakness with the Leviathan Blade");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.hideInSnow, "Cold Campout", "Hide in powder snow with a Frosted Cowl");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.axeTarget, "Here I am", "Throw a Warped Axe at a target block to teleport to it");
        this.addAdvancement(DPAdvancementProv.DungeonsPlusAdvancements.axePhantom, "What could go wrong?", "Throw a Warped Axe at a phantom from at least 25 meters away");
        this.add((Supplier<SoundEvent>)DPSoundEvents.SOUL_CANNON_SHOOT, "Soul Blaster shoots");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_THROW, "Warped Axe thrown");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_LAND, "Warped Axe lands");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_HIT, "Warped Axe hits");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_RETURN, "Warped Axe returns");
        this.add((Supplier<SoundEvent>)DPSoundEvents.WARPED_AXE_TELEPORT, "Player teleports");
        this.add("death.attack.dungeons_plus.consume_soul", "%1$s consumed their own soul");
        this.add("death.attack.dungeons_plus.consume_soul.player", "%1$s consumed their soul whilst fighting %2$s");
        this.add("death.attack.dungeons_plus.warped_axe", "%1$s was cleaved by %2$s");
        this.add("death.attack.dungeons_plus.warped_axe.item", "%1$s was cleaved by %2$s with %3$s");
        this.add("item.dungeons_plus.info.hold_shift", "Hold [Shift] for info");
        this.addItemInfo((Supplier<Item>)DPItems.LEVIATHAN_BLADE, "weakness", "Afflicts targets with weakness.");
        this.addItemInfo((Supplier<Item>)DPItems.FROSTED_COWL, "freeze_immune", "Grants immunity to freezing.");
        this.addItemInfo((Supplier<Item>)DPItems.FROSTED_COWL, "slowness_immune", "Prevents the slowness potions from taking effect.");
        this.addItemInfo((Supplier<Item>)DPItems.FROSTED_COWL, "snow_vision", "Improves vision when snowing.");
        this.addItemInfo((Supplier<Item>)DPItems.WARPED_AXE, "teleport", "Teleports the user to who the axe was thrown at.");
        this.addItemInfo((Supplier<Item>)DPItems.WARPED_AXE, "crouch", "Crouch to prevent teleporting.");
        this.addItemInfo((Supplier<Item>)DPItems.SOUL_CANNON, "shoot", "Launches a fireball in the direction the user is facing.");
    }

    public static String mapName(StructureRegistrar<?> structure) {
        return "filled_map." + structure.getRegistryName();
    }

    private void addAdvancement(Advancement advancement, String title, String desc) {
        DisplayInfo display = advancement.m_138320_();
        this.add(display.m_14977_().getString(), title);
        this.add(display.m_14985_().getString(), desc);
    }

    private <T> void addAll(ResourceKey<Registry<T>> registry, Map<ResourceKey<T>, String> overrides) {
        try {
            this.lookup.get().m_255025_(registry).m_255209_().distinct().filter(key -> "dungeons_plus".equals(key.m_135782_().m_135827_())).filter(key -> !overrides.containsKey(key)).forEach(this::add);
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        overrides.forEach(this::add);
    }

    private void add(ResourceKey<?> key) {
        this.add(key, this.toName(key.m_135782_()));
    }

    private void add(ResourceKey<?> key, String translation) {
        this.add(this.makeDescriptionID(key), translation);
    }

    private void add(Supplier<SoundEvent> sound, String translation) {
        this.add("subtitles.dungeons_plus." + sound.get().m_11660_().m_135815_(), translation);
    }

    private void addItemInfo(Supplier<Item> item, String key, String translation) {
        ResourceKey resourceKey = (ResourceKey)BuiltInRegistries.f_257033_.m_7854_((Object)item.get()).get();
        ResourceLocation location = resourceKey.m_135782_();
        this.add(Util.m_137492_((String)resourceKey.m_211136_().m_135815_().replace('/', '.'), (ResourceLocation)new ResourceLocation(location.m_135827_(), location.m_135815_() + "." + key)), translation);
    }

    private String toName(ResourceLocation location) {
        String path = location.m_135815_();
        CharSequence[] words = path.split("_");
        for (int i = words.length - 1; i > -1; --i) {
            words[i] = ((String)words[i]).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)words[i]).substring(1).toLowerCase(Locale.ENGLISH);
        }
        return String.join((CharSequence)" ", words);
    }

    private String makeDescriptionID(ResourceKey<?> resourceKey) {
        return Util.m_137492_((String)resourceKey.m_211136_().m_135815_().replace('/', '.'), (ResourceLocation)resourceKey.m_135782_());
    }
}

