/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.util;

import com.mactso.spawnbalanceutility.config.MyConfig;
import com.mactso.spawnbalanceutility.manager.StructureCreatureManager;
import com.mactso.spawnbalanceutility.util.Summary;
import com.mactso.spawnbalanceutility.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.Weight;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureSettingsBuilder;
import net.minecraftforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SpawnStructureData {
    private static final Logger LOGGER = LogManager.getLogger();
    static int structureEventNumber = 0;
    static Set<String> structuresProcessed = new HashSet<String>();
    static int reportlinenumber = 0;

    public static void initReports() {
        File fs;
        File fd = new File("config/spawnbalanceutility");
        if (!fd.exists()) {
            fd.mkdir();
        }
        if ((fs = new File("config/spawnbalanceutility/StructMobWeight.rpt")).exists()) {
            fs.delete();
        }
    }

    public static void onStructure(Holder<Structure> struct, ModifiableStructureInfo.StructureInfo.Builder builder) {
        String threadname = Thread.currentThread().getName();
        if (MyConfig.isBalanceStructureSpawnValues()) {
            SpawnStructureData.balanceStructureSpawnValues(struct, builder);
        }
        if (MyConfig.isFixSpawnValues()) {
            SpawnStructureData.fixStructureSpawnValues(struct, builder);
        }
    }

    private static void fixStructureSpawnValues(Holder<Structure> struct, ModifiableStructureInfo.StructureInfo.Builder builder) {
        ++structureEventNumber;
        ArrayList<MobSpawnSettings.SpawnerData> newSpawnersList = new ArrayList<MobSpawnSettings.SpawnerData>();
        ArrayList theirSpawnersList = new ArrayList();
        int fixCount = 0;
        for (MobCategory ec : MobCategory.values()) {
            // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable StructureSettingsBuilder.StructureSpawnOverrideBuilder spob = builder.getStructureSettings().getSpawnOverrides(ec);
            if (spob == null) continue;
            newSpawnersList.clear();
            theirSpawnersList.clear();
            for (MobSpawnSettings.SpawnerData s : spob.getSpawns()) {
                int oldSpawnWeight = s.m_142631_().m_146281_();
                int newSpawnWeight = Math.max(MyConfig.getMinSpawnWeight(), oldSpawnWeight);
                if (newSpawnWeight > 0) {
                    newSpawnWeight = Math.min(MyConfig.getMaxSpawnWeight(), newSpawnWeight);
                }
                if (newSpawnWeight != oldSpawnWeight) {
                    ++fixCount;
                }
                MobSpawnSettings.SpawnerData newSpawner = new MobSpawnSettings.SpawnerData(s.f_48404_, Weight.m_146282_((int)newSpawnWeight), s.f_48405_, s.f_48406_);
                newSpawnersList.add(newSpawner);
            }
            builder.getStructureSettings().removeSpawnOverrides(ec);
            StructureSettingsBuilder.StructureSpawnOverrideBuilder so = builder.getStructureSettings().getOrAddSpawnOverrides(ec);
            for (MobSpawnSettings.SpawnerData s : newSpawnersList) {
                so.addSpawn(s);
            }
        }
        Summary.setStructureFix(fixCount);
    }

    public static void generateStructureSpawnValuesReport(ServerStartingEvent event) {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/StructMobWeight.rpt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is the StructMobWeight report file that is output every time the server starts.");
        p.println("* ");
        p.println("* Spawn Balance Utility (SBU) will use this file ONLY if it is renamed to StructMobWeight.csv.");
        p.println("* Lines starting with '*' are comments and ignored");
        p.println("* It allows you to add and remove mobs and adjust their spawnweights for Structures");
        p.println("* like shipwrecks, nether fortresses, water monuments, etc.");
        p.println("* ");
        int structlinenumber = 0;
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen dynreg = server.m_206579_();
        Registry structRegistry = dynreg.m_175515_(Registries.f_256944_);
        for (Structure struct : structRegistry) {
            String sn = structRegistry.m_7981_((Object)struct).toString();
            p.println(++structlinenumber + ", " + sn + ", HEADING, header:ignore, 0, 0, 0");
            Map msi = struct.getModifiedStructureSettings().f_226690_();
            for (MobCategory mc : MobCategory.values()) {
                if (msi.get(mc) == null) continue;
                for (MobSpawnSettings.SpawnerData s : ((StructureSpawnOverride)msi.get(mc)).f_210044_().m_146338_()) {
                    String modname;
                    if (MyConfig.isSuppressMinecraftMobReporting() && EntityType.m_20613_((EntityType)s.f_48404_).m_135827_().equals("minecraft") || !MyConfig.isIncludedMod(modname = EntityType.m_20613_((EntityType)s.f_48404_).m_135827_())) continue;
                    p.println(++structlinenumber + ", " + sn + ", " + mc + ", " + EntityType.m_20613_((EntityType)s.f_48404_).toString() + ", " + s.m_142631_() + ", " + s.f_48405_ + ", " + s.f_48406_);
                }
            }
        }
        if (p != System.out) {
            p.close();
        }
    }

    private static void balanceStructureSpawnValues(Holder<Structure> struct, ModifiableStructureInfo.StructureInfo.Builder builder) {
        String vCl = "";
        String key = null;
        ++structureEventNumber;
        Optional opKey = struct.m_203543_();
        if (opKey.isPresent()) {
            key = ((ResourceKey)opKey.get()).m_135782_().toString();
        }
        List<StructureCreatureManager.StructureCreatureItem> structureMobList = StructureCreatureManager.structureCreaturesMap.get(key);
        ArrayList<MobSpawnSettings.SpawnerData> newSpawnersList = new ArrayList<MobSpawnSettings.SpawnerData>();
        ArrayList theirSpawnersList = new ArrayList();
        int used = 0;
        if (structureMobList != null) {
            for (MobCategory v : MobCategory.values()) {
                vCl = v.m_7912_();
                newSpawnersList.clear();
                theirSpawnersList.clear();
                for (int i = 0; i < structureMobList.size(); ++i) {
                    StructureCreatureManager.StructureCreatureItem sci = structureMobList.get(i);
                    if (!sci.getClassification().toLowerCase().equals(vCl)) continue;
                    Optional opt = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(sci.getModAndMob()));
                    if (opt.isPresent()) {
                        if (((EntityType)opt.get()).m_20674_() == MobCategory.MISC) {
                            Utility.debugMsg(0, "spawnbalanceutility : " + sci.getModAndMob() + " is MISC, minecraft is hard coded to change it to minecraft:pig in spawning data.");
                        } else if (((EntityType)opt.get()).m_20674_() != v && !sci.getModAndMob().equals("minecraft:ocelot")) {
                            Utility.debugMsg(0, "spawnbalanceutility : " + sci.getModAndMob() + " Error, mob type " + v + " different than defined for the type of mob " + ((EntityType)opt.get()).m_20674_());
                        }
                        MobSpawnSettings.SpawnerData newSpawner = new MobSpawnSettings.SpawnerData((EntityType)opt.get(), Weight.m_146282_((int)sci.getSpawnWeight()), sci.getMinCount(), sci.getMaxCount());
                        newSpawnersList.add(newSpawner);
                        continue;
                    }
                    LOGGER.error(reportlinenumber + "SpawnBalanceUtility ERROR: Mob " + sci.getModAndMob() + " not in Entity Type Registry");
                }
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable StructureSettingsBuilder.StructureSpawnOverrideBuilder spob = builder.getStructureSettings().getSpawnOverrides(v);
                if (spob != null) {
                    builder.getStructureSettings().removeSpawnOverrides(v);
                }
                if (newSpawnersList.isEmpty()) continue;
                StructureSettingsBuilder.StructureSpawnOverrideBuilder so = builder.getStructureSettings().getOrAddSpawnOverrides(v);
                for (MobSpawnSettings.SpawnerData s : newSpawnersList) {
                    so.addSpawn(s);
                }
                used += newSpawnersList.size();
            }
        }
        Summary.setStructureUsed(used);
    }

    static {
        Summary.clearStructure();
    }
}

