/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.util;

import com.mactso.spawnbalanceutility.config.MyConfig;
import com.mactso.spawnbalanceutility.manager.BiomeCreatureManager;
import com.mactso.spawnbalanceutility.manager.MobMassAdditionManager;
import com.mactso.spawnbalanceutility.util.Summary;
import com.mactso.spawnbalanceutility.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnBiomeData {
    private static final Logger LOGGER = LogManager.getLogger();
    static int reportlinenumber = 0;
    static int biomeEventNumber = 0;
    static Set<String> biomesProcessed = new HashSet<String>();

    public static void initReports() {
        File fpm;
        File fma;
        File fb;
        File fd = new File("config/spawnbalanceutility");
        if (!fd.exists()) {
            fd.mkdir();
        }
        if ((fb = new File("config/spawnbalanceutility/BiomeMobWeight.rpt")).exists()) {
            fb.delete();
        }
        if (!(fma = new File("config/spawnbalanceutility/MassAdditionMobs.rpt")).exists()) {
            SpawnBiomeData.generateMassAdditionMobsStubReport();
        }
        if (!(fpm = new File("config/spawnbalanceutility/PsuedoMobs.rpt")).exists()) {
            SpawnBiomeData.generatePsuedoMobStubReport();
        }
    }

    public static void balanceBiomeSpawnValues(MinecraftServer server) {
        RegistryAccess.Frozen dynreg = server.m_206579_();
        Registry biomeRegistry = dynreg.m_175515_(Registries.f_256952_);
        Field field = null;
        try {
            String name = ASMAPI.mapField((String)"f_48329_");
            field = MobSpawnSettings.class.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error("XXX Unexpected Reflection Failure balanceBiomeSpawnValues");
            return;
        }
        int usedTotal = 0;
        String vCl = "";
        for (Biome b : biomeRegistry) {
            String bn = biomeRegistry.m_7981_((Object)b).toString();
            Optional oBH = biomeRegistry.m_203300_(biomeRegistry.m_7447_((Object)b));
            if (!oBH.isPresent()) continue;
            String bcName = Utility.getMyBC((Holder<Biome>)((Holder)oBH.get()));
            List<BiomeCreatureManager.BiomeCreatureItem> modBiomeMobSpawners = BiomeCreatureManager.biomeCreaturesMap.get(bn);
            if (modBiomeMobSpawners == null) {
                LOGGER.warn("XXX Biome (" + bn + ") has no valid mobs.");
                modBiomeMobSpawners = new ArrayList<BiomeCreatureManager.BiomeCreatureItem>();
                continue;
            }
            MobSpawnSettings msi = b.m_47518_();
            HashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>> newMap = new HashMap<MobCategory, WeightedRandomList<MobSpawnSettings.SpawnerData>>();
            int used = 0;
            for (MobCategory v : MobCategory.values()) {
                ArrayList<MobSpawnSettings.SpawnerData> newFixedList = new ArrayList<MobSpawnSettings.SpawnerData>();
                vCl = v.toString();
                for (BiomeCreatureManager.BiomeCreatureItem biomeCreatureItem : modBiomeMobSpawners) {
                    if (!biomeCreatureItem.getClassification().equalsIgnoreCase(vCl)) continue;
                    Optional opt = BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(biomeCreatureItem.getModAndMob()));
                    int i = 3;
                    if (opt.isPresent()) {
                        if (((EntityType)opt.get()).m_20674_() == MobCategory.MISC) {
                            Utility.debugMsg(0, "spawnbalanceutility : " + biomeCreatureItem.getModAndMob() + " is MISC, minecraft is hard coded to change it to minecraft:pig in spawning data.");
                        } else if (((EntityType)opt.get()).m_20674_() != v && !biomeCreatureItem.getModAndMob().equals("minecraft:ocelot")) {
                            Utility.debugMsg(0, "spawnbalanceutility : " + biomeCreatureItem.getModAndMob() + " Error, mob type " + v + " different than defined for the type of mob " + ((EntityType)opt.get()).m_20674_());
                        }
                        MobSpawnSettings.SpawnerData newSpawner = new MobSpawnSettings.SpawnerData((EntityType)opt.get(), Weight.m_146282_((int)biomeCreatureItem.getSpawnWeight()), biomeCreatureItem.getMinCount(), biomeCreatureItem.getMaxCount());
                        newFixedList.add(newSpawner);
                        continue;
                    }
                    Utility.debugMsg(0, reportlinenumber + "SpawnBalanceUtility ERROR: Mob " + biomeCreatureItem.getModAndMob() + " not in Entity Type Registry");
                }
                newMap.put(v, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146328_(newFixedList));
                used += newFixedList.size();
            }
            try {
                Map oldMap = (Map)field.get(msi);
                field.set(msi, newMap);
                usedTotal += used;
                Summary.biomeUpdate(oldMap, newMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Summary.setBiomeUsed(usedTotal);
    }

    public static void fixBiomeSpawnValues(MinecraftServer server) {
        LOGGER.warn(" SpawnBalanceUtility: Fixing biome extreme spawn values. ");
        RegistryAccess.Frozen dynreg = server.m_206579_();
        Registry biomeRegistry = dynreg.m_175515_(Registries.f_256952_);
        Field field = null;
        try {
            String name = ASMAPI.mapField((String)"f_48329_");
            field = MobSpawnSettings.class.getDeclaredField(name);
            field.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error("XXX Unexpected Reflection Failure lateBalanceBiomeSpawnValues");
            return;
        }
        int fixCount = 0;
        int netherCount = 0;
        int biomeTotal = 0;
        HashSet usedTotalSet = new HashSet();
        for (Biome b : biomeRegistry) {
            String bn = biomeRegistry.m_7981_((Object)b).toString();
            LOGGER.warn("SBU Biomes: " + bn);
            Optional oBH = biomeRegistry.m_203300_(biomeRegistry.m_7447_((Object)b));
            if (!oBH.isPresent()) continue;
            String bcName = Utility.getMyBC((Holder<Biome>)((Holder)oBH.get()));
            MobSpawnSettings msi = b.m_47518_();
            Map map = null;
            try {
                map = (Map)field.get(msi);
            }
            catch (Exception e) {
                Utility.debugMsg(0, "spawnbalanceutility XXX Unexpected Reflection Failure getting map");
                return;
            }
            HashMap<MobCategory, WeightedRandomList> newMap = new HashMap<MobCategory, WeightedRandomList>();
            boolean zombifiedPiglinSpawner = false;
            boolean ghastSpawner = false;
            ArrayList<EntityType> usedList = new ArrayList<EntityType>();
            for (MobCategory mc : MobCategory.values()) {
                MobSpawnSettings.SpawnerData newS;
                WeightedRandomList originalSpawnerList = (WeightedRandomList)map.get(mc);
                ArrayList<MobSpawnSettings.SpawnerData> newFixedList = new ArrayList<MobSpawnSettings.SpawnerData>();
                for (MobSpawnSettings.SpawnerData s : originalSpawnerList.m_146338_()) {
                    int oldSpawnWeight = s.m_142631_().m_146281_();
                    int newSpawnWeight = oldSpawnWeight;
                    if (newSpawnWeight > 0) {
                        newSpawnWeight = Math.max(MyConfig.getMinSpawnWeight(), newSpawnWeight);
                        newSpawnWeight = Math.min(MyConfig.getMaxSpawnWeight(), newSpawnWeight);
                    }
                    Utility.debugMsg(2, "spawnbalanceutility:" + s.f_48404_.m_20675_() + " minspawn change from " + s.m_142631_().m_146281_() + " to " + newSpawnWeight);
                    String key = EntityType.m_20613_((EntityType)s.f_48404_).toString();
                    int dSW = MyConfig.getDefaultSpawnWeight(key);
                    if (dSW != -999) {
                        if (newSpawnWeight == 0) {
                            LOGGER.warn("WARN Setting " + key + " to non-zero spawnweight value may cause runaway spawning.");
                        }
                        newSpawnWeight = dSW;
                    }
                    if (newSpawnWeight != oldSpawnWeight) {
                        ++fixCount;
                    }
                    newS = new MobSpawnSettings.SpawnerData(s.f_48404_, Weight.m_146282_((int)newSpawnWeight), s.f_48405_, s.f_48406_);
                    newFixedList.add(newS);
                    if (Utility.getMyBC((Holder<Biome>)((Holder)oBH.get())) != Utility.NETHER) continue;
                    if (s.f_48404_ == EntityType.f_20531_) {
                        zombifiedPiglinSpawner = true;
                    }
                    if (s.f_48404_ != EntityType.f_20453_) continue;
                    ghastSpawner = true;
                }
                List<MobMassAdditionManager.MassAdditionMobItem> massAddMobs = MobMassAdditionManager.getFilteredList(mc, bcName);
                for (MobMassAdditionManager.MassAdditionMobItem ma : massAddMobs) {
                    Optional oe = EntityType.m_20632_((String)ma.getModAndMob());
                    if (!oe.isPresent()) continue;
                    EntityType et = (EntityType)oe.get();
                    boolean mobFound = false;
                    for (MobSpawnSettings.SpawnerData s : newFixedList) {
                        if (s.f_48404_ != et) continue;
                        mobFound = true;
                        break;
                    }
                    if (mobFound) continue;
                    newS = new MobSpawnSettings.SpawnerData(et, Weight.m_146282_((int)ma.getSpawnWeight()), ma.getMinCount(), ma.getMaxCount());
                    newFixedList.add(newS);
                    usedList.add(et);
                }
                if (Utility.getMyBC((Holder<Biome>)((Holder)oBH.get())) == Utility.NETHER && mc == MobCategory.MONSTER) {
                    MobSpawnSettings.SpawnerData newS2;
                    if (!zombifiedPiglinSpawner && MyConfig.isFixEmptyNether()) {
                        newS2 = new MobSpawnSettings.SpawnerData(EntityType.f_20531_, Weight.m_146282_((int)MyConfig.getMinSpawnWeight()), 1, 4);
                        newFixedList.add(newS2);
                        ++netherCount;
                    }
                    if (!ghastSpawner && MyConfig.isFixEmptyNether()) {
                        newS2 = new MobSpawnSettings.SpawnerData(EntityType.f_20453_, Weight.m_146282_((int)((int)((float)MyConfig.getMinSpawnWeight() * 0.75f))), 4, 4);
                        newFixedList.add(newS2);
                        ++netherCount;
                    }
                }
                newMap.put(mc, WeightedRandomList.m_146328_(newFixedList));
            }
            try {
                field.set(msi, newMap);
                usedTotalSet.addAll(usedList);
                biomeTotal += usedList.size();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Summary.setMassAddUsed(usedTotalSet.size(), biomeTotal);
        Summary.setBiomeFix(fixCount, netherCount);
    }

    private static void generateMassAdditionMobsStubReport() {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/MassAdditionMobs.rpt", true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is an example Mass Addition File that lets you add mobs to every biome.");
        p.println("* Lines that start with a '*' are comments and are not used.");
        p.println("* If you rename this file to MassAdditionMobs.csv, Spawn Balance Utility will use it.");
        p.println("*");
        p.println("* Parameter explainations and values.");
        p.println("* Parm Dimension  : A, O, N, E for All, Overworld, Nether, The End");
        p.println("* Parm Class      : MONSTER, CREATURE, AMBIENT, UNDERWATER, etc.");
        p.println("* Parm Resource   : modname:mobname");
        p.println("* Parm Weight     : a number 1 or higher.  1 is superrare, 5 is rare, 20 is uncommon, 80 is common.");
        p.println("* Parm MinGroup   : a number 1 and less than MaxGroup");
        p.println("* Parm MaxGroup   : a number higher than MinGroup and usually 5 or less.");
        p.println("* Format is. Line, Dim,   Class, mod:mob,           spawnWeight, Mingroup, MaxGroup");
        p.println("*");
        p.println("* 1,   A, MONSTER, minecraft:phantom, 10           ,1         ,4");
        p.println("* will add phantoms too all biomes with a spawnweight of 10 and 1-4 group size.");
        p.println("*");
        if (p != System.out) {
            p.close();
        }
    }

    private static void generatePsuedoMobStubReport() {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/PsuedoMobs.rpt", true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* Example PsuedoMob file.  Add mobs with the pattern below and rename file to MassAdditionMobs.csv");
        p.println("* Mobs in this file will generate in any specified biome despite their own spawning rules.");
        p.println("* For now, Psuedo Mobs of one type, won't respawn until the prior one dies or despawns.");
        p.println("* SBU will read this file ONLY if it is renamed PsuedoMobs.csv.");
        p.println("*");
        p.println("* NOTICE: This file has a unique format differs from BiomeMobWeight file");
        p.println("* Line starting with '*' are comments and ignored. ");
        p.println("*");
        p.println("* Line, biome, mod:mob, psuedoWeight, mingroup , maxgroup");
        p.println("* 1, minecraft:plains, minecraft:husk, 80, 4, 4");
        p.println("* 2, minecraft:plains, minecraft:blaze, 80, 1, 1");
        p.println("* 4, minecraft:desert, minecraft:iron_golem, 80, 1, 1");
        p.println("* 5, minecraft:snowyplains, minecraft:snow_golem, 80, 1, 1");
        p.println("");
        if (p != System.out) {
            p.close();
        }
    }

    public static void generateBiomeReport(ServerStartingEvent event) {
        PrintStream p = null;
        try {
            p = new PrintStream(new FileOutputStream("config/spawnbalanceutility/BiomeMobWeight.rpt", false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (p == null) {
            p = System.out;
        }
        p.println("* This is the BiomeMobWeight report file that is output every time the server starts.");
        p.println("* ");
        p.println("* Spawn Balance Utility (SBU) will use this file ONLY if it is renamed to BiomeMobWeight.csv.");
        p.println("* Lines starting with '*' are comments and ignored");
        p.println("* When this file is read, SBU writes summary information to the log file.");
        p.println("* ");
        int biomelineNumber = 0;
        MinecraftServer server = event.getServer();
        RegistryAccess.Frozen dynreg = server.m_206579_();
        Registry biomeRegistry = dynreg.m_175515_(Registries.f_256952_);
        for (Biome b : biomeRegistry) {
            String bn = biomeRegistry.m_7981_((Object)b).toString();
            Optional oBH = biomeRegistry.m_203300_(biomeRegistry.m_7447_((Object)b));
            String cn = Utility.getMyBC((Holder<Biome>)((Holder)oBH.get()));
            MobSpawnSettings msi = b.m_47518_();
            for (MobCategory v : MobCategory.values()) {
                for (MobSpawnSettings.SpawnerData s : msi.m_151798_(v).m_146338_()) {
                    String modname;
                    if (MyConfig.isSuppressMinecraftMobReporting() && EntityType.m_20613_((EntityType)s.f_48404_).m_135827_().equals("minecraft") || !MyConfig.isIncludedMod(modname = EntityType.m_20613_((EntityType)s.f_48404_).m_135827_())) continue;
                    p.println(++biomelineNumber + ", " + cn + ", " + bn + ", " + v + ", " + EntityType.m_20613_((EntityType)s.f_48404_).toString() + ", " + s.m_142631_() + ", " + s.f_48405_ + ", " + s.f_48406_);
                }
            }
        }
        if (p != System.out) {
            p.close();
        }
    }

    static {
        SpawnBiomeData.initReports();
    }
}

