/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.spawnbalanceutility.config;

import com.mactso.spawnbalanceutility.manager.BiomeCreatureManager;
import com.mactso.spawnbalanceutility.manager.MobMassAdditionManager;
import com.mactso.spawnbalanceutility.manager.PsuedoMobManager;
import com.mactso.spawnbalanceutility.manager.StructureCreatureManager;
import com.mactso.spawnbalanceutility.util.Utility;
import java.util.HashSet;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="spawnbalanceutility", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final int NO_DEFAULT_SPAWN_WEIGHT_FOUND = -999;
    public static int debugLevel;
    private static boolean generateReport;
    private static boolean suppressMinecraftMobReporting;
    private static boolean fixEmptyNether;
    private static boolean balanceBiomeSpawnValues;
    private static boolean fixSpawnValues;
    private static boolean balanceStructureSpawnValues;
    public static int minSpawnWeight;
    public static int maxSpawnWeight;
    public static HashSet<String> includedReportModsSet;
    public static HashSet<String> defaultSpawnWeightList;
    public static HashSet<String> fixSpawnPlacementMobsSet;

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debugLevel) {
        MyConfig.debugLevel = debugLevel;
    }

    public static boolean isGenerateReport() {
        return generateReport;
    }

    public static boolean isSuppressMinecraftMobReporting() {
        return suppressMinecraftMobReporting;
    }

    public static boolean isFixEmptyNether() {
        return fixEmptyNether;
    }

    public static boolean isBalanceBiomeSpawnValues() {
        return balanceBiomeSpawnValues;
    }

    public static boolean isFixSpawnValues() {
        return fixSpawnValues;
    }

    public static boolean isBalanceStructureSpawnValues() {
        return balanceStructureSpawnValues;
    }

    public static int getMinSpawnWeight() {
        return minSpawnWeight;
    }

    public static int getMaxSpawnWeight() {
        return maxSpawnWeight;
    }

    public static boolean isIncludedMod(String modName) {
        if (includedReportModsSet.contains("*")) {
            return true;
        }
        if (includedReportModsSet.isEmpty()) {
            return true;
        }
        return includedReportModsSet.contains(modName);
    }

    public static int getDefaultSpawnWeight(String key) {
        if (defaultSpawnWeightList.isEmpty()) {
            return -999;
        }
        String[] arrayItem = defaultSpawnWeightList.toArray(new String[0]);
        Utility.debugMsg(1, "Considering Default Spawn Weight 'key' : " + key);
        for (int i = 0; i < defaultSpawnWeightList.size(); ++i) {
            String s = arrayItem[i];
            String[] ret = s.split(",");
            Utility.debugMsg(1, "ret ='" + ret[0] + "', default spawn weight: " + ret[1]);
            if (!ret[0].equals(key)) continue;
            int dSW = Integer.parseInt(ret[1]);
            return dSW;
        }
        return -999;
    }

    public static HashSet<String> getFixSpawnPlacementMobsSet() {
        return fixSpawnPlacementMobsSet;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        Utility.debugMsg(0, "spawnbalanceutility Reload Configuration");
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void pushDebugValue() {
        Utility.debugMsg(0, " Change DebugLevel:" + debugLevel);
        MyConfig.COMMON.debugLevel.set((Object)debugLevel);
    }

    public static void bakeConfig() {
        debugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        generateReport = (Boolean)MyConfig.COMMON.generateReport.get();
        suppressMinecraftMobReporting = (Boolean)MyConfig.COMMON.suppressMinecraftMobReporting.get();
        fixEmptyNether = (Boolean)MyConfig.COMMON.fixEmptyNether.get();
        balanceBiomeSpawnValues = (Boolean)MyConfig.COMMON.balanceBiomeSpawnValues.get();
        fixSpawnValues = (Boolean)MyConfig.COMMON.fixSpawnValues.get();
        balanceStructureSpawnValues = (Boolean)MyConfig.COMMON.balanceStructureSpawnValues.get();
        includedReportModsSet = MyConfig.getModStringSet(MyConfig.extract((String)MyConfig.COMMON.includedReportModsSet.get()));
        fixSpawnPlacementMobsSet = MyConfig.getFixSpawnPlacementMobs(MyConfig.extract((String)MyConfig.COMMON.fixSpawnPlacementMobs.get()));
        minSpawnWeight = (Integer)MyConfig.COMMON.minSpawnWeight.get();
        maxSpawnWeight = (Integer)MyConfig.COMMON.maxSpawnWeight.get();
        defaultSpawnWeightList = MyConfig.getSpawnWeightStringSet(MyConfig.extract((String)MyConfig.COMMON.defaultSpawnWeightList.get()));
        PsuedoMobManager.psuedoMobInit();
        BiomeCreatureManager.biomeCreatureInit();
        StructureCreatureManager.structureCreatureInit();
        MobMassAdditionManager.massAdditionMobsInit();
    }

    public static String[] extract(String s) {
        String[] ret = s.split(";");
        return ret;
    }

    private static HashSet<String> getFixSpawnPlacementMobs(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (String s : values) {
            String s2 = s.trim().toLowerCase();
            if (s2.isEmpty()) continue;
            set.add(s2);
        }
        return set;
    }

    public static HashSet<String> getModStringSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        ModList modlist = ModList.get();
        for (String s : values) {
            String s2 = s.trim().toLowerCase();
            if (s2.isEmpty()) continue;
            if (modlist.isLoaded(s2)) {
                set.add(s2);
                continue;
            }
            LOGGER.warn("spawnbalanceutility includedReportModsSet entry : " + s2 + " is not a valid current loaded forge mod.");
        }
        return set;
    }

    public static HashSet<String> getSpawnWeightStringSet(String[] values) {
        HashSet<String> set = new HashSet<String>();
        for (String s : values) {
            String s2 = s.trim().toLowerCase();
            if (s2.isEmpty()) continue;
            set.add(s2);
        }
        return set;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue generateReport;
        public final ForgeConfigSpec.BooleanValue suppressMinecraftMobReporting;
        public final ForgeConfigSpec.BooleanValue fixEmptyNether;
        public final ForgeConfigSpec.BooleanValue balanceBiomeSpawnValues;
        public final ForgeConfigSpec.BooleanValue fixSpawnValues;
        public final ForgeConfigSpec.BooleanValue balanceStructureSpawnValues;
        public final ForgeConfigSpec.ConfigValue<String> includedReportModsSet;
        public final ForgeConfigSpec.IntValue minSpawnWeight;
        public final ForgeConfigSpec.IntValue maxSpawnWeight;
        public final ForgeConfigSpec.ConfigValue<String> defaultSpawnWeightList;
        public final ForgeConfigSpec.ConfigValue<String> fixSpawnPlacementMobs;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Spawn Biome Utility Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("spawnbalanceutility.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.generateReport = builder.comment("generateReport").translation("spawnbalanceutility.config.generateReport").define("generateReport", true);
            this.suppressMinecraftMobReporting = builder.comment("suppressMinecraftMobReporting").translation("spawnbalanceutility.config.suppressMinecraftMobReporting").define("suppressMinecraftMobReporting", false);
            this.fixEmptyNether = builder.comment("fixEmptyNether").translation("spawnbalanceutility.config.fixEmptyNether").define("fixEmptyNether", true);
            this.balanceBiomeSpawnValues = builder.comment("Use the 'BiomeMobWeight.csv' file to balance Biome spawn values").translation("spawnbalanceutility.config.balanceBiomeSpawnValues").define("balanceBiomeSpawnValues", true);
            this.fixSpawnValues = builder.comment("Fix min, max values and add nether creatures").translation("spawnbalanceutility.config.fixSpawnValues").define("fixSpawnValues", true);
            this.balanceStructureSpawnValues = builder.comment("Use the 'StructMobWeight.csv' file to balance structure spawn values").translation("spawnbalanceutility.config.balanceStructureSpawnValues").define("balanceStructureSpawnValues", true);
            this.includedReportModsSet = builder.comment("Mod Name set separated by SemiColons of mods to report.").translation("spawnbalanceutility.configincludeReportModsSet").define("includedReportModsSet", (Object)"exampleModName;");
            builder.pop();
            builder.push("Spawn Placement Fixes");
            this.fixSpawnPlacementMobs = builder.comment("Add mobs spawning in the air and falling to this list .").translation("spawnbalanceutility.configfixSpawnPlacementMobs").define("defaultSpawnWeightList", (Object)"minecraft:piglin_brute;goblinanddungeon:gob;goblinanddungeon:hobgob;");
            builder.pop();
            builder.push("Spawn Weight Values");
            this.minSpawnWeight = builder.comment("minimum Spawn Weight").translation("spawnbalanceutility.config.minSpawnWeight").defineInRange("minSpawnWeight", () -> 10, 1, 1000);
            this.maxSpawnWeight = builder.comment("maximum Spawn Weight").translation("spawnbalanceutility.config.maxSpawnWeight").defineInRange("maxSpawnWeight", () -> 80, 1, 1000);
            this.defaultSpawnWeightList = builder.comment("list of Mod:MobName,DefaultSpawnweight;").translation("spawnbalanceutility.configdefaultSpawnWeightList").define("defaultSpawnWeightList", (Object)"minecraft:enderman,5;minecraft:witch,5;");
            builder.pop();
        }
    }
}

