/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.screen.element;

import io.github.mortuusars.exposure.util.PagingDirection;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class Pager {
    public long lastChangedAt;
    public int changeCooldownMS = 50;
    public boolean playSound = true;
    public SoundEvent changeSoundEvent;
    protected ResourceLocation texture;
    protected int pages;
    protected boolean cycled;
    protected int currentPage;
    protected AbstractButton previousButton;
    protected AbstractButton nextButton;

    public Pager(SoundEvent changeSoundEvent) {
        this.changeSoundEvent = changeSoundEvent;
    }

    public void init(int pages, boolean cycled, AbstractButton previousPageButton, AbstractButton nextPageButton) {
        this.pages = pages;
        this.cycled = cycled;
        this.setPage(this.getCurrentPage());
        this.previousButton = previousPageButton;
        this.nextButton = nextPageButton;
        this.update();
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setPage(int value) {
        this.currentPage = Mth.m_14045_((int)value, (int)0, (int)this.pages);
    }

    public void update() {
        this.previousButton.f_93624_ = this.canChangePage(PagingDirection.PREVIOUS);
        this.nextButton.f_93624_ = this.canChangePage(PagingDirection.NEXT);
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            if (!this.isOnCooldown()) {
                this.changePage(PagingDirection.PREVIOUS);
            }
            return true;
        }
        if (Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262) {
            if (!this.isOnCooldown()) {
                this.changePage(PagingDirection.NEXT);
            }
            return true;
        }
        return false;
    }

    public boolean handleKeyReleased(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.m_91087_().f_91066_.f_92088_.m_90832_(keyCode, scanCode) || keyCode == 262 || Minecraft.m_91087_().f_91066_.f_92086_.m_90832_(keyCode, scanCode) || keyCode == 263) {
            this.lastChangedAt = 0L;
            return true;
        }
        return false;
    }

    private boolean isOnCooldown() {
        return Util.m_137550_() - this.lastChangedAt < (long)this.changeCooldownMS;
    }

    public boolean canChangePage(PagingDirection direction) {
        int newIndex = this.getCurrentPage() + direction.getValue();
        return this.pages > 1 && (this.cycled || 0 <= newIndex && newIndex < this.pages);
    }

    public boolean changePage(PagingDirection direction) {
        if (!this.canChangePage(direction)) {
            return false;
        }
        int oldPage = this.currentPage;
        int newPage = this.getCurrentPage() + direction.getValue();
        if (this.cycled && newPage >= this.pages) {
            newPage = 0;
        } else if (this.cycled && newPage < 0) {
            newPage = this.pages - 1;
        }
        if (oldPage == newPage) {
            return false;
        }
        this.setPage(newPage);
        this.onPageChanged(direction, oldPage, this.currentPage);
        return true;
    }

    public void onPageChanged(PagingDirection pagingDirection, int prevPage, int currentPage) {
        this.lastChangedAt = Util.m_137550_();
        if (this.playSound) {
            this.playChangeSound();
        }
    }

    protected void playChangeSound() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)this.getChangeSound(), (float)0.8f, (float)1.0f));
    }

    protected SoundEvent getChangeSound() {
        return this.changeSoundEvent;
    }
}

