/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.component;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PhotographTooltip
implements ClientTooltipComponent,
TooltipComponent {
    public static final int SIZE = 72;
    private final List<ItemAndStack<PhotographItem>> photographs;

    public PhotographTooltip(ItemStack photographStack) {
        Preconditions.checkArgument((boolean)(photographStack.m_41720_() instanceof PhotographItem), (Object)(String.valueOf(photographStack) + " is not a PhotographItem."));
        this.photographs = List.of(new ItemAndStack(photographStack));
    }

    public PhotographTooltip(ItemAndStack<StackedPhotographsItem> stackedPhotographs) {
        this.photographs = stackedPhotographs.getItem().getPhotographs(stackedPhotographs.getStack());
    }

    public int m_142069_(@NotNull Font font) {
        return 72;
    }

    public int m_142103_() {
        return 74;
    }

    public void m_183452_(@NotNull Font font, int mouseX, int mouseY, GuiGraphics guiGraphics) {
        int photographsCount = this.photographs.size();
        int additionalPhotographs = Math.min(2, photographsCount - 1);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)mouseX, (float)mouseY, 5.0f);
        float scale = 72.0f / (float)ExposureClient.getExposureRenderer().getSize();
        float nextPhotographOffset = PhotographRenderer.getStackedPhotographOffset() / (float)ExposureClient.getExposureRenderer().getSize();
        guiGraphics.m_280168_().m_85841_(scale *= 1.0f - (float)additionalPhotographs * nextPhotographOffset, scale, 1.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PhotographRenderer.renderStackedPhotographs(this.photographs, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.m_109911_();
        guiGraphics.m_280168_().m_85849_();
        if (photographsCount > 1) {
            guiGraphics.m_280168_().m_85836_();
            String count = Integer.toString(photographsCount);
            int fontWidth = Minecraft.m_91087_().f_91062_.m_92895_(count);
            float fontScale = 1.6f;
            guiGraphics.m_280168_().m_252880_((float)mouseX + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - (float)fontWidth * fontScale, (float)mouseY + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - 8.0f * fontScale, 10.0f);
            guiGraphics.m_280168_().m_85841_(fontScale, fontScale, fontScale);
            guiGraphics.m_280488_(font, count, 0, 0, -1);
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

