/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.items;

import com.pepper.faunify.registry.FaunifyItems;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class BugNetItem
extends Item {
    public static final TagKey<EntityType<?>> CATCHABLE_ENTITIES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("faunify", "bug_net_catchable"));

    public BugNetItem(Item.Properties properties) {
        super(properties);
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)((Item)FaunifyItems.BUG_NET.get()), (ResourceLocation)new ResourceLocation("faunify", "has_entity"), (stack, level, entity, seed) -> BugNetItem.hasStoredEntity(stack) ? 1.0f : 0.0f);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (BugNetItem.hasStoredEntity(stack)) {
            return InteractionResult.PASS;
        }
        if (!this.canCatchEntity(target)) {
            return InteractionResult.PASS;
        }
        if (!player.m_9236_().f_46443_) {
            ItemStack filledNet = this.getFilledNet(stack, target);
            filledNet.m_41721_(stack.m_41773_());
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12013_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_21008_(hand, filledNet);
            target.m_146870_();
            player.m_9236_().m_220400_((Entity)player, GameEvent.f_223708_, target.m_20182_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        EntityType entityType;
        Entity entity;
        CompoundTag entityTag;
        Optional entityTypeOpt;
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (!BugNetItem.hasStoredEntity(stack) || player == null) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos spawnPos = clickedPos.m_121945_(context.m_43719_());
        CompoundTag stackTag = stack.m_41783_();
        if (stackTag != null && stackTag.m_128441_("StoredEntity") && (entityTypeOpt = EntityType.m_20637_((CompoundTag)(entityTag = stackTag.m_128469_("StoredEntity")))).isPresent() && (entity = (entityType = (EntityType)entityTypeOpt.get()).m_20615_((Level)((ServerLevel)level))) != null) {
            entity.m_20258_(entityTag);
            if (player.m_150110_().f_35937_) {
                entity.m_20084_(UUID.randomUUID());
            }
            entity.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
            boolean spawned = level.m_7967_(entity);
            if (spawned) {
                level.m_5594_(null, spawnPos, SoundEvents.f_12016_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                level.m_142346_((Entity)player, GameEvent.f_157810_, spawnPos);
                if (!player.m_150110_().f_35937_) {
                    ItemStack emptyNet = new ItemStack((ItemLike)this);
                    emptyNet.m_41721_(stack.m_41773_());
                    emptyNet.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                    player.m_21008_(context.m_43724_(), emptyNet);
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    private boolean canCatchEntity(LivingEntity entity) {
        return entity.m_6095_().m_204039_(CATCHABLE_ENTITIES);
    }

    private ItemStack getFilledNet(ItemStack emptyNet, LivingEntity entity) {
        ItemStack filledNet = new ItemStack((ItemLike)this);
        CompoundTag entityTag = new CompoundTag();
        entity.m_20223_(entityTag);
        CompoundTag stackTag = filledNet.m_41784_();
        stackTag.m_128365_("StoredEntity", (Tag)entityTag);
        stackTag.m_128359_("StoredEntityType", EntityType.m_20613_((EntityType)entity.m_6095_()).toString());
        return filledNet;
    }

    private static boolean hasStoredEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("StoredEntity");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        String entityTypeId;
        Optional entityType;
        CompoundTag tag;
        if (BugNetItem.hasStoredEntity(stack) && (tag = stack.m_41783_()) != null && tag.m_128441_("StoredEntityType") && (entityType = EntityType.m_20632_((String)(entityTypeId = tag.m_128461_("StoredEntityType")))).isPresent()) {
            Component entityName = ((EntityType)entityType.get()).m_20676_();
            tooltip.add((Component)Component.m_237110_((String)"item.faunify.bug_net.contains", (Object[])new Object[]{entityName}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return BugNetItem.hasStoredEntity(stack);
    }
}

