/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.pepper.faunify.entity.MouseEntity;
import com.pepper.faunify.entity.client.model.MouseModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MouseRenderer
extends GeoEntityRenderer<MouseEntity> {
    private static final ResourceLocation FIELD = new ResourceLocation("faunify", "textures/entity/mouse1.png");
    private static final ResourceLocation GREY = new ResourceLocation("faunify", "textures/entity/mouse2.png");
    private static final ResourceLocation WOOD = new ResourceLocation("faunify", "textures/entity/mouse3.png");
    private static final ResourceLocation WHITE = new ResourceLocation("faunify", "textures/entity/mouse4.png");
    private static final ResourceLocation BLACK = new ResourceLocation("faunify", "textures/entity/mouse5.png");
    private static final ResourceLocation BROWNBELLY = new ResourceLocation("faunify", "textures/entity/mouse6.png");
    private static final ResourceLocation ALBINO = new ResourceLocation("faunify", "textures/entity/mousealbino.png");

    public MouseRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MouseModel());
        this.f_114477_ = 0.2f;
    }

    public ResourceLocation getTextureLocation(MouseEntity entity) {
        return MouseRenderer.getVariantTexture(entity.getVariant());
    }

    public static ResourceLocation getVariantTexture(MouseEntity.Variant variant) {
        return switch (variant) {
            case MouseEntity.Variant.FIELD -> FIELD;
            case MouseEntity.Variant.GREY -> GREY;
            case MouseEntity.Variant.WOOD -> WOOD;
            case MouseEntity.Variant.WHITE -> WHITE;
            case MouseEntity.Variant.BLACK -> BLACK;
            case MouseEntity.Variant.BROWNBELLY -> BROWNBELLY;
            case MouseEntity.Variant.ALBINO -> ALBINO;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public void preRender(PoseStack stack, MouseEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(stack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (animatable.m_6162_()) {
            float babyScale = 0.5f;
            stack.m_85841_(babyScale, babyScale, babyScale);
            float headScale = 1.3f;
            stack.m_85836_();
            model.getBone("head").ifPresent(head -> {
                head.setScaleX(headScale);
                head.setScaleY(headScale);
                head.setScaleZ(headScale);
            });
            stack.m_85849_();
        } else {
            float adultScale = 0.8f;
            stack.m_85841_(adultScale, adultScale, adultScale);
        }
    }
}

