/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity.client.model;

import com.pepper.faunify.FaunifyConfig;
import com.pepper.faunify.entity.LeafSheepEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class LeafSheepModel
extends DefaultedEntityGeoModel<LeafSheepEntity> {
    public LeafSheepModel() {
        super(new ResourceLocation("faunify", "leafsheep"), true);
    }

    public ResourceLocation getAnimationResource(LeafSheepEntity object) {
        if (((Boolean)FaunifyConfig.OLD_ANIMATION.get()).booleanValue()) {
            return new ResourceLocation("faunify", "animations/leafsheep.animation.json");
        }
        return new ResourceLocation("faunify", "animations/ratleafsheep.animation.json");
    }

    public void setCustomAnimations(LeafSheepEntity entity, long uniqueID, AnimationState<LeafSheepEntity> animationState) {
        if (!this.turnsHead) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("body");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            if (entity.isClimbing()) {
                float entityYaw;
                for (entityYaw = entity.m_146908_(); entityYaw < 0.0f; entityYaw += 360.0f) {
                }
                while (entityYaw >= 360.0f) {
                    entityYaw -= 360.0f;
                }
                float targetPitch = -270.0f;
                float targetYaw = entityYaw;
                targetYaw = entityYaw >= 315.0f || entityYaw < 45.0f ? 0.0f : (entityYaw >= 45.0f && entityYaw < 135.0f ? 0.0f : (entityYaw >= 135.0f && entityYaw < 225.0f ? 0.0f : 0.0f));
                head.setRotX(targetPitch * ((float)Math.PI / 180));
                head.setRotY(targetYaw * ((float)Math.PI / 180));
            } else {
                head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
                head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
                head.setRotZ(0.0f);
            }
        }
        CoreGeoBone neck = this.getAnimationProcessor().getBone("body_rotation");
        boolean moving = animationState.isMoving();
        if (neck != null && head != null && !entity.isClimbing()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        } else if (neck != null && entity.isClimbing()) {
            neck.setRotX(-0.6981317f);
            neck.setRotZ(0.0f);
        }
    }
}

