/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.mixins;

import com.ordana.immersive_weathering.data.block_growths.growths.builtin.LeavesGrowth;
import com.ordana.immersive_weathering.util.WeatheringHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LeavesBlock.class})
public abstract class LeavesMixin
extends Block
implements BonemealableBlock {
    protected LeavesMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"randomTick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/server/level/ServerLevel;removeBlock(Lnet/minecraft/core/BlockPos;Z)Z")})
    public void onRemoved(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random, CallbackInfo ci) {
        LeavesGrowth.decayLeavesPile(blockState, serverLevel, blockPos, random);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState targetBlock = level.m_8055_(targetPos);
            if (!WeatheringHelper.getAzaleaGrowth(targetBlock).isPresent()) continue;
            ++i;
        }
        return i > 0;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return state.m_60713_(Blocks.f_152471_);
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        for (Direction direction : Direction.values()) {
            if (!(random.m_188501_() > 0.5f)) continue;
            BlockPos targetPos = pos.m_121945_(direction);
            BlockState targetBlock = level.m_8055_(targetPos);
            WeatheringHelper.getAzaleaGrowth(targetBlock).ifPresent(s -> level.m_46597_(targetPos, s));
        }
    }
}

