/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks.charred;

import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import com.ordana.immersive_weathering.reg.ModParticles;
import com.ordana.immersive_weathering.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;

public interface Charred
extends ILightable,
Fallable {
    public static final BooleanProperty SMOLDERING = ModBlockProperties.SMOLDERING;
    public static final IntegerProperty OVERHANG = ModBlockProperties.OVERHANG;

    default public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int temperature = 0;
        boolean isTouchingWater = false;
        for (Direction direction : Direction.values()) {
            BlockPos targetPos = pos.m_121945_(direction);
            Holder biome = level.m_204166_(pos);
            BlockState neighborState = level.m_8055_(targetPos);
            if (level.m_46758_(pos.m_121945_(direction)) || neighborState.m_60819_().m_76152_() == Fluids.f_76192_ || neighborState.m_60819_().m_76152_() == Fluids.f_76193_) {
                isTouchingWater = true;
            }
            if (level.m_46758_(pos.m_121945_(direction)) || biome.m_203656_(ModTags.WET) || neighborState.m_60819_().m_76152_() == Fluids.f_76192_ || neighborState.m_60819_().m_76152_() == Fluids.f_76193_) {
                --temperature;
                continue;
            }
            if (!neighborState.m_204336_(ModTags.MAGMA_SOURCE) && !neighborState.m_204336_(BlockTags.f_13076_)) continue;
            ++temperature;
        }
        if (temperature < 0 || isTouchingWater) {
            if (this.isLitUp(state)) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(false)));
            }
        } else if (temperature > 0 && !((Boolean)state.m_61143_((Property)SMOLDERING)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(true)));
        }
    }

    default public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(16) == 0 && FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() - 0.05;
            double f = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), d, e, f, 0.0, 0.0, 0.0);
        }
        if (this.isLitUp(state)) {
            int i = pos.m_123341_();
            int j = pos.m_123342_();
            int k = pos.m_123343_();
            double d = (double)i + random.m_188500_();
            double e = (double)j + random.m_188500_();
            double f = (double)k + random.m_188500_();
            level.m_7106_((ParticleOptions)ModParticles.EMBERSPARK.get(), d, e, f, 0.1, 3.0, 0.1);
        }
    }

    default public void onEntityStepOn(BlockState state, Entity entity) {
        if (this.isLitUp(state) && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(entity.m_269291_().m_269047_(), 1.0f);
        }
    }

    default public boolean isLitUp(BlockState state) {
        return (Boolean)state.m_61143_((Property)SMOLDERING);
    }

    default public BlockState toggleLitState(BlockState state, boolean lit) {
        return (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.valueOf(lit));
    }

    default public int getOverhang(Level level, BlockPos pos) {
        int overhang = 2;
        for (Direction dir : Direction.values()) {
            if (dir == Direction.DOWN) {
                boolean free;
                boolean bl = free = FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_())) && pos.m_123342_() >= level.m_141937_();
                if (free) continue;
                overhang = 0;
                break;
            }
            if (dir == Direction.UP) continue;
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockState neighbor = level.m_8055_(neighborPos);
            if (neighbor.m_61138_((Property)OVERHANG)) {
                if ((Integer)neighbor.m_61143_((Property)OVERHANG) != 0) continue;
                overhang = 1;
                break;
            }
            if (!neighbor.m_60783_((BlockGetter)level, neighborPos, dir.m_122424_())) continue;
            overhang = 1;
            break;
        }
        return overhang;
    }

    default public void updateOverhang(BlockState state, Level level, BlockPos pos) {
        int supported = this.getOverhang(level, pos);
        if (supported != (Integer)state.m_61143_((Property)OVERHANG)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)OVERHANG, (Comparable)Integer.valueOf(supported)));
        }
        if (supported == 2) {
            level.m_186460_(pos, state.m_60734_(), 1);
        }
    }

    default public void m_48792_(Level level, BlockPos pos, BlockState blockState, BlockState blockState2, FallingBlockEntity fallingBlock) {
    }

    default public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        boolean flint = item instanceof FlintAndSteelItem;
        boolean charge = stack.m_150930_(Items.f_42613_);
        if ((flint || charge) && !((Boolean)state.m_61143_((Property)SMOLDERING)).booleanValue()) {
            level.m_5594_(player, pos, flint ? SoundEvents.f_11942_ : SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.EMBERSPARK.get()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
            if (!player.m_150110_().f_35937_) {
                if (flint) {
                    stack.m_41622_(1, (LivingEntity)player, l -> l.m_21190_(hand));
                }
                if (charge) {
                    stack.m_41774_(1);
                }
            }
            if (player instanceof ServerPlayer) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.TRUE));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)SMOLDERING)).booleanValue()) {
            level.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level.m_5776_()) {
                ParticleUtils.m_216313_((Level)level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)ModParticles.EMBERSPARK.get()), (IntProvider)UniformInt.m_146622_((int)3, (int)5));
                ParticleUtil.spawnParticlesOnBlockFaces((Level)level, (BlockPos)pos, (ParticleOptions)ParticleTypes.f_123762_, (UniformInt)UniformInt.m_146622_((int)3, (int)5), (float)-0.05f, (float)0.05f, (boolean)false);
            }
            if (player instanceof ServerPlayer) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)SMOLDERING, (Comparable)Boolean.FALSE));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

