/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.purpoid.ai;

import com.teamabnormals.endergetic.common.entity.purpoid.Purpoid;
import com.teamabnormals.endergetic.common.entity.purpoid.ai.PurpoidAttackGoal;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class PurpoidMoveNearTargetGoal
extends Goal {
    private final Purpoid purpoid;
    @Nullable
    private Path path;
    private int delayCounter;

    public PurpoidMoveNearTargetGoal(Purpoid purpoid) {
        this.purpoid = purpoid;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Purpoid purpoid = this.purpoid;
        if (PurpoidAttackGoal.shouldFollowTarget(purpoid, true)) {
            this.path = purpoid.m_21573_().m_6570_((Entity)purpoid.m_5448_(), 5);
            return this.path != null;
        }
        return false;
    }

    public void m_8056_() {
        Purpoid purpoid = this.purpoid;
        purpoid.m_21573_().m_26536_(this.path, 2.0);
        purpoid.m_21561_(true);
        this.delayCounter = 0;
    }

    public boolean m_8045_() {
        Purpoid purpoid = this.purpoid;
        return PurpoidAttackGoal.shouldFollowTarget(purpoid, true) && purpoid.m_21573_().m_26572_();
    }

    public void m_8037_() {
        this.delayCounter = Math.max(this.delayCounter - 1, 0);
        Purpoid purpoid = this.purpoid;
        LivingEntity target = purpoid.m_5448_();
        purpoid.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        RandomSource random = purpoid.m_217043_();
        if (this.delayCounter <= 0 && random.m_188501_() < 0.05f) {
            this.delayCounter = 4 + random.m_188503_(9);
            double distanceToTargetSq = purpoid.m_20280_((Entity)target);
            if (distanceToTargetSq > 1024.0) {
                this.delayCounter += 10;
            } else if (distanceToTargetSq > 256.0) {
                this.delayCounter += 5;
            }
            PathNavigation pathNavigator = purpoid.m_21573_();
            Path path = pathNavigator.m_7864_(PurpoidAttackGoal.findAirPosAboveTarget(purpoid.m_9236_(), target), random.m_188503_(3) + 3);
            if (path == null || !pathNavigator.m_26536_(path, 2.0)) {
                this.delayCounter += 15;
            }
        }
    }

    public void m_8041_() {
        Purpoid purpoid = this.purpoid;
        LivingEntity target = purpoid.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            purpoid.m_6710_(null);
        }
        purpoid.m_21561_(false);
        purpoid.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }
}

