/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.flying;

import com.teamabnormals.blueprint.client.ClientInfo;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import net.minecraft.util.Mth;

public final class FlyingRotations {
    private float prevFlyPitch;
    private float flyPitch;
    private float prevFlyRoll;
    private float flyRoll;
    private boolean looking;

    public void tick(TargetFlyingRotations targetRotations) {
        this.prevFlyPitch = this.flyPitch;
        this.prevFlyRoll = this.flyRoll;
        while (this.flyPitch - this.prevFlyPitch < -180.0f) {
            this.prevFlyPitch -= 360.0f;
        }
        while (this.flyPitch - this.prevFlyPitch >= 180.0f) {
            this.prevFlyPitch += 360.0f;
        }
        while (this.flyRoll - this.prevFlyRoll < -180.0f) {
            this.prevFlyRoll -= 360.0f;
        }
        while (this.flyRoll - this.prevFlyRoll >= 180.0f) {
            this.prevFlyRoll += 360.0f;
        }
        if (this.looking) {
            this.flyPitch = FlyingRotations.clampedRotate(this.flyPitch, targetRotations.getTargetFlyPitch(), 5.0f);
            this.flyRoll = FlyingRotations.clampedRotate(this.flyRoll, targetRotations.getTargetFlyRoll(), 5.0f);
            this.looking = false;
        } else {
            this.flyPitch = FlyingRotations.clampedRotate(this.flyPitch, 0.0f, 2.5f);
            this.flyRoll = FlyingRotations.clampedRotate(this.flyRoll, 0.0f, 2.5f);
        }
    }

    public void setLooking(boolean looking) {
        this.looking = looking;
    }

    public float getFlyPitch() {
        return this.flyPitch;
    }

    public float getFlyRoll() {
        return this.flyRoll;
    }

    public float getRenderFlyPitch() {
        return Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)this.prevFlyPitch, (float)this.flyPitch);
    }

    public float getRenderFlyRoll() {
        return Mth.m_14179_((float)ClientInfo.getPartialTicks(), (float)this.prevFlyRoll, (float)this.flyRoll);
    }

    public static float clampedRotate(float from, float to, float delta) {
        return from + Mth.m_14036_((float)Mth.m_14118_((float)from, (float)to), (float)(-delta), (float)delta);
    }
}

