/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.glider;

import com.teamabnormals.endergetic.common.entity.eetle.ChargerEetle;
import com.teamabnormals.endergetic.common.entity.eetle.GliderEetle;
import com.teamabnormals.endergetic.common.entity.eetle.flying.FlyingRotations;
import com.teamabnormals.endergetic.common.entity.eetle.flying.TargetFlyingRotations;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GliderEetleDiveGoal
extends Goal {
    private final GliderEetle glider;
    @Nullable
    private Vec3 divePos;
    @Nullable
    private Vec3 divingMotion;
    private float prevHealth;
    private int ticksGrabbed;
    private float targetYaw;
    private float targetPitch;
    private int ticksDiving;

    public GliderEetleDiveGoal(GliderEetle glider) {
        this.glider = glider;
        this.prevHealth = glider.m_21223_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        BlockPos pos;
        Level world;
        int distanceFromGround;
        GliderEetle glider = this.glider;
        LivingEntity attackTarget = glider.m_5448_();
        this.ticksGrabbed = attackTarget == null || !attackTarget.m_6084_() || GliderEetle.isEntityLarge((Entity)attackTarget) || glider.m_20069_() || !glider.isFlying() || !glider.m_20160_() || glider.m_20197_().get(0) != attackTarget || glider.m_21223_() - this.prevHealth <= -3.0f ? 0 : ++this.ticksGrabbed;
        this.prevHealth = glider.m_21223_();
        if (this.ticksGrabbed >= 30 && (distanceFromGround = GliderEetleDiveGoal.distanceFromGround(glider, world = glider.m_9236_(), (pos = glider.m_20183_()).m_122032_())) > 3 && distanceFromGround < 11 && world.m_45976_(ChargerEetle.class, new AABB(pos = pos.m_6625_(distanceFromGround)).m_82400_(4.0)).size() < 3) {
            RandomSource random = glider.m_217043_();
            for (int i = 0; i < 5; ++i) {
                Vec3 gliderPos;
                BlockPos offsetPos = pos.m_7918_(random.m_188503_(4) - random.m_188503_(4), 0, random.m_188503_(4) - random.m_188503_(4));
                if (!world.m_46575_(offsetPos.m_7495_(), (Entity)glider) || !world.m_45772_(new AABB(offsetPos)) || world.m_45547_(new ClipContext(gliderPos = new Vec3(glider.m_20185_(), glider.m_20188_(), glider.m_20189_()), Vec3.m_82528_((Vec3i)offsetPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)glider)).m_6662_() != HitResult.Type.MISS) continue;
                this.divePos = Vec3.m_82528_((Vec3i)offsetPos);
                return true;
            }
        }
        return false;
    }

    public void m_8056_() {
        GliderEetle glider = this.glider;
        glider.m_21573_().m_26573_();
        Vec3 target = this.divePos;
        double xDif = target.m_7096_() + 0.5 - glider.m_20185_();
        double yDif = target.m_7098_() - glider.m_20188_();
        double zDif = target.m_7094_() + 0.5 - glider.m_20189_();
        float magnitude = Mth.m_14116_((float)((float)(xDif * xDif + yDif * yDif + zDif * zDif)));
        double toDeg = 57.29577951308232;
        this.targetYaw = (float)(Mth.m_14136_((double)zDif, (double)xDif) * toDeg) - 90.0f;
        this.targetPitch = (float)(-(Mth.m_14136_((double)yDif, (double)magnitude) * toDeg));
        this.divingMotion = new Vec3(xDif, yDif, zDif).m_82541_().m_82542_(1.0, (double)1.3f, 1.0);
    }

    public boolean m_8045_() {
        GliderEetle glider = this.glider;
        LivingEntity attackTarget = glider.m_5448_();
        return attackTarget != null && attackTarget.m_6084_() && !GliderEetle.isEntityLarge((Entity)attackTarget) && glider.isFlying() && this.ticksDiving < 30;
    }

    public void m_8037_() {
        LivingEntity attackTarget;
        ++this.ticksDiving;
        GliderEetle glider = this.glider;
        int ticksDiving = this.ticksDiving;
        if (ticksDiving == 5) {
            glider.m_20256_(glider.m_20184_().m_82549_(this.divingMotion));
        }
        glider.setDiving(true);
        glider.setMoving(true);
        glider.setTargetFlyingRotations(new TargetFlyingRotations(this.targetPitch, glider.getTargetFlyingRotations().getTargetFlyRoll()));
        glider.m_146922_(FlyingRotations.clampedRotate(glider.m_146908_(), this.targetYaw, 15.0f));
        glider.m_21563_().m_24964_(this.divePos);
        if (ticksDiving > 5 && (glider.m_20096_() || glider.f_19862_) && (attackTarget = glider.m_5448_()) != null && glider.m_20363_((Entity)attackTarget)) {
            glider.makeGrounded();
            glider.groundedAttacker = attackTarget;
            attackTarget.m_6469_(glider.m_269291_().m_269515_(), (float)(glider.m_217043_().m_188503_(6) + 8));
        }
    }

    public void m_8041_() {
        this.divePos = null;
        this.divingMotion = null;
        this.prevHealth = this.glider.m_21223_();
        this.ticksDiving = 0;
        this.ticksGrabbed = 0;
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
    }

    private static int distanceFromGround(GliderEetle glider, Level world, BlockPos.MutableBlockPos pos) {
        int y = pos.m_123342_();
        for (int i = 0; i <= 11; ++i) {
            pos.m_142448_(y - i);
            if (!world.m_46575_((BlockPos)pos, (Entity)glider)) continue;
            return i;
        }
        return 11;
    }

    public boolean m_183429_() {
        return true;
    }
}

