/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.eetle.ai.brood;

import com.teamabnormals.endergetic.common.entity.eetle.AbstractEetle;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class BroodEetleFlingGoal
extends Goal {
    private static final TargetingConditions PREDICATE = TargetingConditions.m_148352_().m_26888_(livingEntity -> !(livingEntity instanceof AbstractEetle));
    private final BroodEetle broodEetle;
    @Nullable
    private LivingEntity target;
    private int ticksPassed;

    public BroodEetleFlingGoal(BroodEetle broodEetle) {
        this.broodEetle = broodEetle;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        BroodEetle broodEetle = this.broodEetle;
        if (broodEetle.isFiringCannon() || !broodEetle.hasWokenUp()) {
            return false;
        }
        List<LivingEntity> targets = BroodEetleFlingGoal.searchForNearbyAggressors(broodEetle, 3.0);
        if (!(targets.isEmpty() || targets.size() > 3 && broodEetle.canSlam())) {
            this.target = broodEetle.m_9236_().m_45982_(targets, PREDICATE, (LivingEntity)broodEetle, broodEetle.m_20185_(), broodEetle.m_20186_(), broodEetle.m_20189_());
            return this.target != null;
        }
        return false;
    }

    public void m_8056_() {
        this.broodEetle.m_21561_(true);
    }

    public boolean m_8045_() {
        if (this.ticksPassed >= 80) {
            return false;
        }
        LivingEntity target = this.target;
        if (target != null && target.m_6084_() && !target.m_20145_()) {
            return target.m_20280_((Entity)this.broodEetle) <= 20.25;
        }
        return false;
    }

    public void m_8037_() {
        ++this.ticksPassed;
        BroodEetle broodEetle = this.broodEetle;
        LivingEntity target = this.target;
        if (target != null) {
            broodEetle.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.ticksPassed >= 10 && broodEetle.isNoEndimationPlaying() && broodEetle.m_20280_((Entity)target) <= BroodEetleFlingGoal.getAttackReachSqr(broodEetle.m_20205_() * 1.8f, target)) {
                broodEetle.m_7327_((Entity)target);
            }
        }
    }

    public void m_8041_() {
        this.target = null;
        this.ticksPassed = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    private static double getAttackReachSqr(float width, LivingEntity attackTarget) {
        return width * 2.0f * width * 2.0f + attackTarget.m_20205_();
    }

    public static List<LivingEntity> searchForNearbyAggressors(BroodEetle broodEetle, double size) {
        return broodEetle.m_9236_().m_6443_(LivingEntity.class, broodEetle.m_20191_().m_82400_(size), livingEntity -> {
            if (livingEntity instanceof Player) {
                return livingEntity.m_6084_() && !livingEntity.m_20145_() && !((Player)livingEntity).m_7500_();
            }
            return livingEntity.m_6084_() && !livingEntity.m_20145_() && broodEetle.m_21574_().m_148306_((Entity)livingEntity) && (livingEntity instanceof Mob && ((Mob)livingEntity).m_5448_() == broodEetle || broodEetle.isAnAggressor((LivingEntity)livingEntity));
        });
    }
}

