/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.booflo;

import com.teamabnormals.blueprint.core.endimator.Endimatable;
import com.teamabnormals.endergetic.api.entity.util.EntityItemStackHelper;
import com.teamabnormals.endergetic.common.entity.booflo.Booflo;
import com.teamabnormals.endergetic.common.entity.booflo.BoofloAdolescent;
import com.teamabnormals.endergetic.common.entity.booflo.ai.BabyFollowParentGoal;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoofloBaby
extends PathfinderMob
implements Endimatable {
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.m_135353_(BoofloBaby.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BIRTH_TIMER = SynchedEntityData.m_135353_(BoofloBaby.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MOTHER_IMMUNITY_TICKS = SynchedEntityData.m_135353_(BoofloBaby.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BIRTH_POSITION_ID = SynchedEntityData.m_135353_(BoofloBaby.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean wasBred;
    public int growingAge;
    public int forcedAge;
    public int forcedAgeTimer;
    private float prevTailAnimation;
    private float tailAnimation;
    private float tailSpeed;

    public BoofloBaby(EntityType<? extends BoofloBaby> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new BoofloBabyMoveContoller(this);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
        this.prevTailAnimation = this.tailAnimation = this.f_19796_.m_188501_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOVING, (Object)false);
        this.f_19804_.m_135372_(BIRTH_TIMER, (Object)0);
        this.f_19804_.m_135372_(MOTHER_IMMUNITY_TICKS, (Object)0);
        this.f_19804_.m_135372_(BIRTH_POSITION_ID, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new BabyFollowParentGoal(this, 1.2f));
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyingGoal(this, 1.1, 20));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.85f).m_22268_(Attributes.f_22277_, 18.0);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new FlyingPathNavigation((Mob)this, worldIn){

            public boolean m_6342_(BlockPos pos) {
                return this.f_26495_.m_8055_(pos).m_60795_();
            }
        };
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_21515_() && !this.m_20069_()) {
            this.m_19920_(0.012f, vec3d);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (!this.isMoving()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, 0.0025, 0.0));
            }
        } else {
            super.m_7023_(vec3d);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Moving", this.isMoving());
        compound.m_128405_("BirthTime", this.getBirthTimer());
        compound.m_128405_("Age", this.getGrowingAge());
        compound.m_128405_("MotherImmunityTicks", this.getMotherNoClipTicks());
        compound.m_128405_("BirthPosition", this.getBirthPositionID());
        compound.m_128405_("ForcedAge", this.forcedAge);
        compound.m_128379_("WasBred", this.wasBred);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMoving(compound.m_128471_("Moving"));
        this.setBirthTimer(compound.m_128451_("BirthTime"));
        this.setGrowingAge(compound.m_128451_("Age"));
        this.setMotherNoClipTicks(compound.m_128451_("MotherImmunityTicks"));
        this.setBirthPosition(BirthPosition.get(Math.min(compound.m_128451_("BirthPosition"), 2)));
        this.forcedAge = compound.m_128451_("ForcedAge");
        this.wasBred = compound.m_128471_("WasBred");
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(MOVING);
    }

    public void setMoving(boolean moving) {
        this.f_19804_.m_135381_(MOVING, (Object)moving);
    }

    public int getBirthTimer() {
        return (Integer)this.f_19804_.m_135370_(BIRTH_TIMER);
    }

    public boolean isBeingBorn() {
        return this.getBirthTimer() > 0;
    }

    public void setBirthTimer(int birthTimer) {
        this.f_19804_.m_135381_(BIRTH_TIMER, (Object)birthTimer);
    }

    public int getMotherNoClipTicks() {
        return (Integer)this.f_19804_.m_135370_(MOTHER_IMMUNITY_TICKS);
    }

    public void setMotherNoClipTicks(int ticks) {
        this.f_19804_.m_135381_(MOTHER_IMMUNITY_TICKS, (Object)ticks);
    }

    public Vec3 getBirthPositionOffset() {
        return BirthPosition.get((int)this.getBirthPositionID()).offset;
    }

    public int getBirthPositionID() {
        return (Integer)this.f_19804_.m_135370_(BIRTH_POSITION_ID);
    }

    public void setBirthPosition(BirthPosition birthPosition) {
        this.f_19804_.m_135381_(BIRTH_POSITION_ID, (Object)birthPosition.ordinal());
    }

    public int getGrowingAge() {
        if (this.m_9236_().f_46443_) {
            return -1;
        }
        return this.growingAge;
    }

    public void setGrowingAge(int age) {
        int oldAge = this.growingAge;
        this.growingAge = age;
        if (oldAge < 0 && age >= 0 || oldAge > 0 && age < 0) {
            this.growUp();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getTailAnimation(float ptc) {
        return Mth.m_14179_((float)ptc, (float)this.prevTailAnimation, (float)this.tailAnimation);
    }

    public boolean m_21515_() {
        return !this.isBeingBorn() && super.m_21515_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.wasBred;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.SOUNDS;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            this.prevTailAnimation = this.tailAnimation;
            this.tailSpeed = this.m_20069_() ? 1.0f : (this.isMoving() ? (this.tailSpeed < 0.5f ? 1.0f : (this.tailSpeed += (0.25f - this.tailSpeed) * 0.1f)) : (this.tailSpeed += (0.1875f - this.tailSpeed) * 0.1f));
            this.tailAnimation += this.tailSpeed;
        } else {
            int birthTimer = this.getBirthTimer();
            if (birthTimer > 0) {
                if (--birthTimer == 0) {
                    Vec3 posBeforeDismount = this.m_20182_();
                    this.m_8127_();
                    this.m_146884_(posBeforeDismount);
                    this.m_146926_(180.0f);
                    this.setMotherNoClipTicks(50);
                }
                this.setBirthTimer(birthTimer);
            }
        }
        if (this.m_9236_().f_46443_) {
            if (this.forcedAgeTimer > 0) {
                if (this.forcedAgeTimer % 4 == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.m_188501_() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.m_188501_() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), 0.0, 0.0, 0.0);
                }
                --this.forcedAgeTimer;
            }
        } else if (this.m_6084_()) {
            int growingAge = this.getGrowingAge();
            if (growingAge < 0) {
                this.setGrowingAge(++growingAge);
            } else if (growingAge > 0) {
                this.setGrowingAge(--growingAge);
            }
        }
        if (this.getMotherNoClipTicks() > 0) {
            this.setMotherNoClipTicks(this.getMotherNoClipTicks() - 1);
        }
    }

    public LivingEntity growUp() {
        if (this.m_6084_()) {
            this.m_20000_((ItemLike)EEItems.BOOFLO_HIDE.get(), 1);
            BoofloAdolescent booflo = (BoofloAdolescent)((EntityType)EEEntityTypes.BOOFLO_ADOLESCENT.get()).m_20615_(this.m_9236_());
            booflo.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            if (this.m_8077_()) {
                booflo.m_6593_(this.m_7770_());
                booflo.m_20340_(this.m_20151_());
            }
            if (this.m_21523_()) {
                booflo.m_21463_(this.m_21524_(), true);
                this.m_21455_(true, false);
            }
            if (this.m_20202_() != null) {
                booflo.m_20329_(this.m_20202_());
            }
            booflo.m_21153_(booflo.m_21233_());
            booflo.setGrowingAge(-24000);
            booflo.wasBred = this.wasBred;
            this.m_9236_().m_7967_((Entity)booflo);
            this.m_146870_();
            return booflo;
        }
        return this;
    }

    public void ageUp(int growthSeconds, boolean updateForcedAge) {
        int growingAge;
        int j = growingAge = this.getGrowingAge();
        if ((growingAge += growthSeconds * 20) > 0) {
            growingAge = 0;
        }
        int k = growingAge - j;
        this.setGrowingAge(growingAge);
        if (updateForcedAge) {
            this.forcedAge += k;
            if (this.forcedAgeTimer == 0) {
                this.forcedAgeTimer = 40;
            }
        }
        if (this.getGrowingAge() == 0) {
            this.setGrowingAge(this.forcedAge);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == EEItems.BOLLOOM_FRUIT.get()) {
            EntityItemStackHelper.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f), true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setGrowingAge(-24000);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)EEItems.BOOFLO_SPAWN_EGG.get());
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Booflo)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268576_) || super.m_6673_(source);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    static class BoofloBabyMoveContoller
    extends MoveControl {
        private final BoofloBaby booflo;

        public BoofloBabyMoveContoller(BoofloBaby booflo) {
            super((Mob)booflo);
            this.booflo = booflo;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.booflo.m_21573_().m_26571_()) {
                Vec3 vec3d = new Vec3(this.f_24975_ - this.booflo.m_20185_(), this.f_24976_ - this.booflo.m_20186_(), this.f_24977_ - this.booflo.m_20189_());
                double d0 = vec3d.m_82553_();
                double d1 = vec3d.f_82480_ / d0;
                float f = (float)(Mth.m_14136_((double)vec3d.f_82481_, (double)vec3d.f_82479_) * 57.2957763671875) - 90.0f;
                this.booflo.m_146922_(this.m_24991_(this.booflo.m_146908_(), f, 10.0f));
                this.booflo.f_20883_ = this.booflo.m_146908_();
                this.booflo.f_20885_ = this.booflo.m_146908_();
                float f1 = (float)(this.f_24978_ * this.booflo.m_21051_(Attributes.f_22279_).m_22135_());
                float f2 = Mth.m_14179_((float)0.125f, (float)this.booflo.m_6113_(), (float)f1);
                this.booflo.m_7910_(f2);
                double d3 = Math.cos(this.booflo.m_146908_() * ((float)Math.PI / 180));
                double d4 = Math.sin(this.booflo.m_146908_() * ((float)Math.PI / 180));
                double d5 = Math.sin((double)(this.booflo.f_19797_ + this.booflo.m_19879_()) * 0.75) * 0.05;
                if (!this.booflo.m_20069_()) {
                    float f3 = -((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)Mth.m_14116_((float)((float)(vec3d.f_82479_ * vec3d.f_82479_ + vec3d.f_82481_ * vec3d.f_82481_)))) * 57.2957763671875));
                    f3 = Mth.m_14036_((float)Mth.m_14177_((float)f3), (float)-85.0f, (float)85.0f);
                    this.booflo.m_146926_(this.m_24991_(this.booflo.m_146909_(), f3, 5.0f));
                }
                this.booflo.m_20256_(this.booflo.m_20184_().m_82520_(0.0, d5 * (d4 + d3) * 0.25 + (double)f2 * d1 * 0.02, 0.0));
                this.booflo.setMoving(true);
            } else {
                this.booflo.m_7910_(0.0f);
                this.booflo.setMoving(false);
            }
        }
    }

    static class RandomFlyingGoal
    extends RandomStrollGoal {
        public RandomFlyingGoal(PathfinderMob p_i48937_1_, double p_i48937_2_, int p_i48937_4_) {
            super(p_i48937_1_, p_i48937_2_, p_i48937_4_);
        }

        @Nullable
        protected Vec3 m_7037_() {
            Vec3 view = this.f_25725_.m_20252_(0.0f);
            double viewX = view.f_82479_;
            double viewZ = view.f_82481_;
            Vec3 vec3d = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)7, (int)4, (double)viewX, (double)viewZ, (float)1.5707964f, (int)3, (int)1);
            int i = 0;
            while (vec3d != null && !this.f_25725_.m_9236_().m_8055_(BlockPos.m_274446_((Position)vec3d)).m_60647_((BlockGetter)this.f_25725_.m_9236_(), BlockPos.m_274446_((Position)vec3d), PathComputationType.WATER) && i++ < 10) {
                vec3d = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)7, (int)4, (double)viewX, (double)viewZ, (float)1.5707964f, (int)3, (int)1);
            }
            return vec3d;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25725_.m_20069_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.f_25725_.m_20069_();
        }
    }

    public static enum BirthPosition {
        BACK(-0.25f, 0.0f),
        LEFT(0.2f, -0.3f),
        RIGHT(0.2f, 0.3f);

        private static final BirthPosition[] VALUES;
        private final Vec3 offset;

        private BirthPosition(float xOffset, float zOffset) {
            this.offset = new Vec3((double)xOffset, 0.0, (double)zOffset);
        }

        public static BirthPosition get(int id) {
            return VALUES[id];
        }

        static {
            VALUES = BirthPosition.values();
        }
    }
}

