/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.entity.bolloom;

import com.teamabnormals.endergetic.common.entity.bolloom.BalloonColor;
import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class BolloomKnot
extends Entity {
    private BlockPos hangingPosition;
    private static final EntityDataAccessor<Integer> BALLOONS_TIED = SynchedEntityData.m_135353_(BolloomKnot.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public BolloomKnot(EntityType<? extends BolloomKnot> entityType, Level world) {
        super(entityType, world);
    }

    public BolloomKnot(Level world, BlockPos pos) {
        this((EntityType<? extends BolloomKnot>)((EntityType)EEEntityTypes.BOLLOOM_KNOT.get()), world);
        this.m_6034_((float)pos.m_123341_() + 0.5f, (float)pos.m_123342_() + 0.9f, (float)pos.m_123343_() + 0.5f);
        this.hangingPosition = pos;
        this.m_20256_(Vec3.f_82478_);
    }

    public BolloomKnot(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this((EntityType<? extends BolloomKnot>)((EntityType)EEEntityTypes.BOLLOOM_KNOT.get()), world);
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_9236_().isAreaLoaded(this.getHangingPos(), 1) && !this.onValidBlock()) {
            this.m_146870_();
        } else if (this.getBalloonsTied() <= 0) {
            this.m_146870_();
        }
    }

    @Nullable
    public static BolloomKnot getKnotForPosition(Level worldIn, BlockPos pos) {
        for (BolloomKnot entity : worldIn.m_45976_(BolloomKnot.class, new AABB(pos))) {
            if (!entity.getHangingPos().equals((Object)pos)) continue;
            return entity;
        }
        return null;
    }

    public static void createStartingKnot(Level world, BlockPos pos, BalloonColor balloonColor) {
        BolloomKnot knot = new BolloomKnot(world, pos);
        BolloomBalloon balloon = new BolloomBalloon(world, knot.m_20148_(), pos, 0.0f);
        knot.setBalloonsTied(1);
        balloon.setColor(balloonColor);
        world.m_7967_((Entity)knot);
        world.m_7967_((Entity)balloon);
    }

    public void addBalloon(BalloonColor balloonColor) {
        BolloomBalloon balloon = new BolloomBalloon(this.m_9236_(), this.m_20148_(), this.getHangingPos(), 0.1f);
        balloon.setColor(balloonColor);
        this.m_9236_().m_7967_((Entity)balloon);
        this.setBalloonsTied(this.getBalloonsTied() + 1);
    }

    private boolean onValidBlock() {
        return this.m_9236_().m_8055_(this.hangingPosition).m_204336_(BlockTags.f_13039_);
    }

    public boolean m_6087_() {
        return true;
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_6034_(double x, double y, double z) {
        this.hangingPosition = BlockPos.m_274561_((double)x, (double)y, (double)z);
        super.m_6034_(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BALLOONS_TIED, (Object)0);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.hangingPosition = new BlockPos(nbt.m_128451_("TileX"), nbt.m_128451_("TileY"), nbt.m_128451_("TileZ"));
        this.setBalloonsTied(nbt.m_128451_("BalloonsTied"));
    }

    protected void m_7380_(CompoundTag nbt) {
        BlockPos blockpos = this.getHangingPos();
        nbt.m_128405_("TileX", blockpos.m_123341_());
        nbt.m_128405_("TileY", blockpos.m_123342_());
        nbt.m_128405_("TileZ", blockpos.m_123343_());
        nbt.m_128405_("BalloonsTied", this.getBalloonsTied());
    }

    public BlockPos getHangingPos() {
        return this.hangingPosition;
    }

    public void setBalloonsTied(int amount) {
        this.m_20088_().m_135381_(BALLOONS_TIED, (Object)amount);
    }

    public int getBalloonsTied() {
        return (Integer)this.m_20088_().m_135370_(BALLOONS_TIED);
    }

    public boolean hasMaxBalloons() {
        return (Integer)this.f_19804_.m_135370_(BALLOONS_TIED) > 3;
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

